/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Medico;
import br.com.fiorilli.sip.persistence.entity.PericiaNova;
import br.com.fiorilli.sip.persistence.entity.PericiaResposta;
import br.com.fiorilli.sip.persistence.entity.PericiaStatus;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="PERICIA_AGENDA")
@Audited
public class PericiaAgendaNova
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_ALL = "SELECT p FROM PericiaAgendaNova p";
    public static final String FIND_BY_CPF_AND_PERIOD_TO_HISTORY = "SELECT DISTINCT pa FROM PericiaAgendaNova pa LEFT JOIN FETCH pa.periciaNova pn LEFT JOIN FETCH pa.periciaResposta pr LEFT JOIN FETCH pr.periciaCidPeritoList pc LEFT JOIN FETCH pc.cid c WHERE \t(((pn.trabalhador <> null) AND (pn.trabalhador.documentosPessoais.cpf = :cpf)) \t\tOR (pn.cpfPessoa = :cpf)) \tAND pa.periciaNova is not null \tAND pa.status.id = 6 \tAND pa.dataConsulta BETWEEN :dataInicial AND :dataFinal ORDER BY pa.dataConsulta desc";
    @Id
    @Column(unique=true, nullable=false)
    private Integer id;
    @ManyToOne
    @JoinColumn(name="IDPERICIA", referencedColumnName="ID", insertable=false, updatable=false)
    private PericiaNova periciaNova;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DH_CADASTRO", nullable=false)
    private Date dataCadastro;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DH_CONSULTA_INI", nullable=false)
    private Date dataConsulta;
    @Column(name="MEDICO_ID", nullable=false)
    private Integer medicoId;
    @ManyToOne
    @JoinColumn(name="MEDICO_ID", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Medico medico;
    @Column(name="LOCALEXAME")
    private String localExame;
    @Column(name="RUA")
    private String rua;
    @Column(name="BAIRRO")
    private String bairro;
    @Column(name="NUMERO")
    private String numero;
    @Column(name="CEP")
    private String cep;
    @Column(name="CIDADE")
    private String cidade;
    @Column(name="UF")
    private String uf;
    @Column(name="PROTOCOLO")
    private String protocolo;
    @ManyToOne
    @JoinColumn(name="STATUS", referencedColumnName="IDPERICIASTATUS")
    private PericiaStatus status;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="periciaAgendaNova")
    private PericiaResposta periciaResposta;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public PericiaNova getPericiaNova() {
        return this.periciaNova;
    }

    public void setPericiaNova(PericiaNova periciaNova) {
        this.periciaNova = periciaNova;
    }

    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public Date getDataConsulta() {
        return this.dataConsulta;
    }

    public void setDataConsulta(Date dataConsulta) {
        this.dataConsulta = dataConsulta;
    }

    public Integer getMedicoId() {
        return this.medicoId;
    }

    public void setMedicoId(Integer medicoId) {
        this.medicoId = medicoId;
    }

    public Medico getMedico() {
        return this.medico;
    }

    public void setMedico(Medico medico) {
        this.medico = medico;
    }

    public String getLocalExame() {
        return this.localExame;
    }

    public void setLocalExame(String localExame) {
        this.localExame = localExame;
    }

    public String getRua() {
        return this.rua;
    }

    public void setRua(String rua) {
        this.rua = rua;
    }

    public String getBairro() {
        return this.bairro;
    }

    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getCep() {
        return this.cep;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public String getCidade() {
        return this.cidade;
    }

    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    public String getUf() {
        return this.uf;
    }

    public void setUf(String uf) {
        this.uf = uf;
    }

    public String getProtocolo() {
        return this.protocolo;
    }

    public void setProtocolo(String protocolo) {
        this.protocolo = protocolo;
    }

    public PericiaStatus getStatus() {
        return this.status;
    }

    public void setStatus(PericiaStatus status) {
        this.status = status;
    }

    public PericiaResposta getPericiaResposta() {
        return this.periciaResposta;
    }

    public void setPericiaResposta(PericiaResposta periciaResposta) {
        this.periciaResposta = periciaResposta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PericiaAgendaNova that = (PericiaAgendaNova)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "PericiaAgendaNova{id=" + this.id + ", periciaNova=" + this.periciaNova + ", dataCadastro=" + this.dataCadastro + ", dataConsulta=" + this.dataConsulta + ", medico=" + this.medico + ", localExame='" + this.localExame + '\'' + ", rua='" + this.rua + '\'' + ", bairro='" + this.bairro + '\'' + ", numero='" + this.numero + '\'' + ", cep='" + this.cep + '\'' + ", cidade='" + this.cidade + '\'' + ", uf='" + this.uf + '\'' + ", protocolo='" + this.protocolo + '\'' + ", status=" + this.status + '}';
    }
}

