/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Cid;
import br.com.fiorilli.sip.persistence.entity.CodigoAfastamento;
import br.com.fiorilli.sip.persistence.entity.Medico;
import br.com.fiorilli.sip.persistence.entity.PericiaAfastamento;
import br.com.fiorilli.sip.persistence.entity.PericiaFormulario;
import br.com.fiorilli.sip.persistence.entity.PericiaFormularioResposta;
import br.com.fiorilli.sip.persistence.entity.TipoPericia;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="PERICIA")
@Audited
public class Pericia
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_PERIODO_TRABALHADOR = "SELECT p FROM Pericia p JOIN FETCH p.trabalhador t WHERE (p.dataHora >= :periodoInicio OR :periodoInicio is null) ORDER BY p.dataHora DESC";
    public static final String FIND_BY_ID = "SELECT pe FROM Pericia pe JOIN FETCH pe.trabalhador tr LEFT JOIN FETCH tr.cargoAtual ca JOIN FETCH pe.afastamentoMedico am LEFT JOIN FETCH pe.afastamentoPerito ap JOIN FETCH pe.cidMedico cm LEFT JOIN FETCH pe.cidPerito cp JOIN FETCH pe.medico me JOIN FETCH pe.perito pr JOIN FETCH pe.formulario fo WHERE pe.id = :periciaId";
    @Id
    @Column(unique=true, nullable=false)
    private int id;
    @Column(name="DIAS_AFAST_MEDICO")
    private int diasAfastamentoMedico;
    @Column(name="DIAS_AFAST_PERITO")
    private int diasAfastamentoPerito;
    @Column(name="DATA_HORA", nullable=false)
    private Date dataHora;
    @Column(name="DATA_INICIO")
    private Date dataInicio;
    @Column(name="DATA_TERMINO")
    private Date dataTermino;
    @Column(name="PROTOCOLO_AGENDAMENTO")
    private Integer protocoloAgendamento;
    @Enumerated
    @Column(name="TIPO")
    private TipoPericia tipo;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumns(value={@JoinColumn(name="AFAST_CODIGO_MEDICO", referencedColumnName="CODIGO", nullable=false), @JoinColumn(name="AFAST_EMPRESA_MEDICO", referencedColumnName="EMPRESA", nullable=false)})
    private CodigoAfastamento afastamentoMedico;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="AFAST_CODIGO_PERITO", referencedColumnName="CODIGO"), @JoinColumn(name="AFAST_EMPRESA_PERITO", referencedColumnName="EMPRESA")})
    private CodigoAfastamento afastamentoPerito;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="CID_MEDICO_ID", nullable=false)
    private Cid cidMedico;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CID_PERITO_ID")
    private Cid cidPerito;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", nullable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", nullable=false)})
    private Trabalhador trabalhador;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="MEDICO_ID", nullable=false)
    private Medico medico;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="PERITO_ID", nullable=false)
    private Medico perito;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="FORMULARIO_ID", nullable=false)
    private PericiaFormulario formulario;
    @OneToMany(mappedBy="pericia", fetch=FetchType.LAZY)
    private List<PericiaAfastamento> periciaAfastamentos;
    @OneToMany(mappedBy="pericia", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<PericiaFormularioResposta> periciaFormularioRespostas;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getDataHora() {
        return this.dataHora;
    }

    public void setDataHora(Date dataHora) {
        this.dataHora = dataHora;
    }

    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    public Date getDataTermino() {
        return this.dataTermino;
    }

    public void setDataTermino(Date dataTermino) {
        this.dataTermino = dataTermino;
    }

    public List<PericiaAfastamento> getPericiaAfastamentos() {
        return this.periciaAfastamentos;
    }

    public void setPericiaAfastamentos(List<PericiaAfastamento> periciaAfastamentos) {
        this.periciaAfastamentos = periciaAfastamentos;
    }

    public PericiaAfastamento addPericiaAfastamento(PericiaAfastamento periciaAfastamento) {
        this.getPericiaAfastamentos().add(periciaAfastamento);
        periciaAfastamento.setPericia(this);
        return periciaAfastamento;
    }

    public PericiaAfastamento removePericiaAfastamento(PericiaAfastamento periciaAfastamento) {
        this.getPericiaAfastamentos().remove(periciaAfastamento);
        periciaAfastamento.setPericia(null);
        return periciaAfastamento;
    }

    public List<PericiaFormularioResposta> getPericiaRespostas() {
        if (this.periciaFormularioRespostas == null) {
            this.periciaFormularioRespostas = new ArrayList<PericiaFormularioResposta>();
        }
        return this.periciaFormularioRespostas;
    }

    public void setPericiaRespostas(List<PericiaFormularioResposta> periciaFormularioRespostas) {
        this.periciaFormularioRespostas = periciaFormularioRespostas;
    }

    public PericiaFormularioResposta addPericiaResposta(PericiaFormularioResposta periciaFormularioResposta) {
        this.getPericiaRespostas().add(periciaFormularioResposta);
        periciaFormularioResposta.setPericia(this);
        return periciaFormularioResposta;
    }

    public PericiaFormularioResposta removePericiaResposta(PericiaFormularioResposta periciaFormularioResposta) {
        this.getPericiaRespostas().remove(periciaFormularioResposta);
        periciaFormularioResposta.setPericia(null);
        return periciaFormularioResposta;
    }

    public CodigoAfastamento getAfastamentoMedico() {
        return this.afastamentoMedico;
    }

    public void setAfastamentoMedico(CodigoAfastamento afastamentoMedico) {
        this.afastamentoMedico = afastamentoMedico;
    }

    public CodigoAfastamento getAfastamentoPerito() {
        return this.afastamentoPerito;
    }

    public void setAfastamentoPerito(CodigoAfastamento afastamentoPerito) {
        this.afastamentoPerito = afastamentoPerito;
    }

    public Cid getCidMedico() {
        return this.cidMedico;
    }

    public void setCidMedico(Cid cidMedico) {
        this.cidMedico = cidMedico;
    }

    public Cid getCidPerito() {
        return this.cidPerito;
    }

    public void setCidPerito(Cid cidPerito) {
        this.cidPerito = cidPerito;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public Medico getMedico() {
        return this.medico;
    }

    public void setMedico(Medico medico) {
        this.medico = medico;
    }

    public Medico getPerito() {
        return this.perito;
    }

    public void setPerito(Medico perito) {
        this.perito = perito;
    }

    public PericiaFormulario getFormulario() {
        return this.formulario;
    }

    public void setFormulario(PericiaFormulario formulario) {
        this.formulario = formulario;
    }

    public int getDiasAfastamentoMedico() {
        return this.diasAfastamentoMedico;
    }

    public void setDiasAfastamentoMedico(int diasAfastamentoMedico) {
        this.diasAfastamentoMedico = diasAfastamentoMedico;
    }

    public int getDiasAfastamentoPerito() {
        return this.diasAfastamentoPerito;
    }

    public void setDiasAfastamentoPerito(int diasAfastamentoPerito) {
        this.diasAfastamentoPerito = diasAfastamentoPerito;
    }

    public Integer getProtocoloAgendamento() {
        return this.protocoloAgendamento;
    }

    public void setProtocoloAgendamento(Integer protocoloAgendamento) {
        this.protocoloAgendamento = protocoloAgendamento;
    }

    public TipoPericia getTipo() {
        return this.tipo;
    }

    public void setTipo(TipoPericia tipo) {
        this.tipo = tipo;
    }
}

