/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.PerfilPermissao;
import br.com.fiorilli.sip.persistence.entity.PerfilPermissoesEntidade;
import br.com.fiorilli.sip.persistence.entity.PermissoesPerfilDivisoes;
import br.com.fiorilli.sip.persistence.entity.PermissoesPerfilEvento;
import br.com.fiorilli.sip.persistence.entity.PermissoesPerfilGrupoPonto;
import br.com.fiorilli.sip.persistence.entity.PermissoesPerfilNotificacoes;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@FilterConfigType(autoFilter=true)
@Entity
@Table(name="PERFIL_USUARIOS")
public class PerfilUsuarios
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_ALL = "SELECT p FROM PerfilUsuarios p";
    public static final String FIND_BY_USUARIO = "SELECT DISTINCT pu FROM PerfilUsuarios pu JOIN pu.usuarios us LEFT JOIN us.trabalhador WHERE us.codigo = :usuarioId";
    public static final String FIND_BY_TRABALHADOR = "SELECT pu FROM PerfilUsuarios pu JOIN pu.usuarios us JOIN us.trabalhador tr WHERE tr.trabalhadorPK = :trabalhadorPK";
    public static final String GENERATOR = "GEN_PERFILUSUARIOS";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    @FilterConfig(label="C\u00f3digo", inputType=FilterInputType.NUMBER)
    private Integer codigo;
    @Size(max=60)
    @Column(name="NOME")
    @FilterConfig(label="Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE)
    private String nome;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="perfilUsuariosList")
    private List<Usuario> usuarios;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="perfil", fetch=FetchType.LAZY)
    private List<PerfilPermissao> permissoesPerfilList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="perfil", fetch=FetchType.LAZY)
    private List<PerfilPermissoesEntidade> permissoesEntidade;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="perfil", fetch=FetchType.LAZY)
    private List<PermissoesPerfilDivisoes> permissoesPerfilDivisoesList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="perfil", fetch=FetchType.LAZY)
    private List<PermissoesPerfilEvento> permissoesPerfilEventosList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="perfil", fetch=FetchType.LAZY)
    private List<PermissoesPerfilNotificacoes> permissoesPerfilNotificacoesList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="perfil", fetch=FetchType.LAZY)
    private List<PermissoesPerfilGrupoPonto> permissoesPerfilGrupoPontoList;

    public PerfilUsuarios() {
    }

    public PerfilUsuarios(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public List<Usuario> getUsuarioList() {
        return this.usuarios;
    }

    public void setUsuarioList(List<Usuario> usuarios) {
        this.usuarios = usuarios;
    }

    public List<PerfilPermissao> getPermissoesPerfilList() {
        if (this.permissoesPerfilList == null) {
            this.permissoesPerfilList = new ArrayList<PerfilPermissao>();
        }
        return this.permissoesPerfilList;
    }

    public void setPermissoesPerfilList(List<PerfilPermissao> permissoesPerfilList) {
        this.permissoesPerfilList = permissoesPerfilList;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PerfilUsuarios)) {
            return false;
        }
        PerfilUsuarios other = (PerfilUsuarios)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.PerfilUsuarios[ codigo=" + this.codigo + " ]";
    }

    public List<PerfilPermissoesEntidade> getPermissoesEntidade() {
        if (this.permissoesEntidade == null) {
            this.permissoesEntidade = new ArrayList<PerfilPermissoesEntidade>();
        }
        return this.permissoesEntidade;
    }

    public void setPermissoesEntidade(List<PerfilPermissoesEntidade> permissoesEntidade) {
        this.permissoesEntidade = permissoesEntidade;
    }

    public List<PermissoesPerfilDivisoes> getPermissoesPerfilDivisoesList() {
        if (this.permissoesPerfilDivisoesList == null) {
            this.permissoesPerfilDivisoesList = new ArrayList<PermissoesPerfilDivisoes>();
        }
        return this.permissoesPerfilDivisoesList;
    }

    public void setPermissoesPerfilDivisoesList(List<PermissoesPerfilDivisoes> permissoesPerfilDivisoesList) {
        this.permissoesPerfilDivisoesList = permissoesPerfilDivisoesList;
    }

    public List<PermissoesPerfilEvento> getPermissoesPerfilEventosList() {
        if (this.permissoesPerfilEventosList == null) {
            this.permissoesPerfilEventosList = new ArrayList<PermissoesPerfilEvento>();
        }
        return this.permissoesPerfilEventosList;
    }

    public void setPermissoesPerfilEventosList(List<PermissoesPerfilEvento> permissoesPerfilEventosList) {
        this.permissoesPerfilEventosList = permissoesPerfilEventosList;
    }

    public List<PermissoesPerfilNotificacoes> getPermissoesPerfilNotificacoesList() {
        if (this.permissoesPerfilNotificacoesList == null) {
            this.permissoesPerfilNotificacoesList = new ArrayList<PermissoesPerfilNotificacoes>();
        }
        return this.permissoesPerfilNotificacoesList;
    }

    public void setPermissoesPerfilNotificacoesList(List<PermissoesPerfilNotificacoes> permissoesPerfilNotificacoesList) {
        this.permissoesPerfilNotificacoesList = permissoesPerfilNotificacoesList;
    }

    public List<PermissoesPerfilGrupoPonto> getPermissoesPerfilGrupoPontoList() {
        if (this.permissoesPerfilGrupoPontoList == null) {
            this.permissoesPerfilGrupoPontoList = new ArrayList<PermissoesPerfilGrupoPonto>();
        }
        return this.permissoesPerfilGrupoPontoList;
    }

    public void setPermissoesPerfilGrupoPontoList(List<PermissoesPerfilGrupoPonto> permissoesPerfilGrupoPontoList) {
        this.permissoesPerfilGrupoPontoList = permissoesPerfilGrupoPontoList;
    }
}

