/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Form;
import br.com.fiorilli.sip.persistence.entity.PerfilPermissaoPK;
import br.com.fiorilli.sip.persistence.entity.PerfilUsuarios;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PERMISSOES_PERFIL")
@Audited
public class PerfilPermissao
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_USUARIO_AND_PAGENAME = "SELECT pp FROM PerfilPermissao pp LEFT JOIN pp.perfil.usuarios us LEFT JOIN FETCH pp.form f WHERE us = :usuario   and f.pageName = :pagename";
    @EmbeddedId
    protected PerfilPermissaoPK perfilPermissaoPK;
    @Type(type="BooleanTypeSip")
    @Column(name="INCLUIR")
    private Boolean incluir;
    @Type(type="BooleanTypeSip")
    @Column(name="ALTERAR")
    private Boolean alterar;
    @Type(type="BooleanTypeSip")
    @Column(name="EXCLUIR")
    private Boolean excluir;
    @JoinColumn(name="PERFIL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private PerfilUsuarios perfil;
    @JoinColumn(name="FORM", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Form form;

    public PerfilPermissao() {
    }

    public PerfilPermissao(PerfilPermissaoPK permissoesPerfilPK) {
        this.perfilPermissaoPK = permissoesPerfilPK;
    }

    public PerfilPermissao(int perfil, int form) {
        this.perfilPermissaoPK = new PerfilPermissaoPK(perfil, form);
    }

    public PerfilPermissaoPK getPerfilPermissaoPK() {
        if (this.perfilPermissaoPK == null) {
            this.perfilPermissaoPK = new PerfilPermissaoPK();
        }
        return this.perfilPermissaoPK;
    }

    public void setPerfilPermissaoPK(PerfilPermissaoPK permissoesPerfilPK) {
        this.perfilPermissaoPK = permissoesPerfilPK;
    }

    public Boolean getIncluir() {
        return this.incluir;
    }

    public void setIncluir(Boolean incluir) {
        this.incluir = incluir;
    }

    public Boolean getAlterar() {
        return this.alterar;
    }

    public void setAlterar(Boolean alterar) {
        this.alterar = alterar;
    }

    public Boolean getExcluir() {
        return this.excluir;
    }

    public void setExcluir(Boolean excluir) {
        this.excluir = excluir;
    }

    public PerfilUsuarios getPerfil() {
        return this.perfil;
    }

    public void setPerfil(PerfilUsuarios perfilUsuarios) {
        this.perfil = perfilUsuarios;
    }

    public Form getForm() {
        return this.form;
    }

    public void setForm(Form forms) {
        this.form = forms;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.perfilPermissaoPK != null ? this.perfilPermissaoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PerfilPermissao)) {
            return false;
        }
        PerfilPermissao other = (PerfilPermissao)object;
        return (this.perfilPermissaoPK != null || other.perfilPermissaoPK == null) && (this.perfilPermissaoPK == null || this.perfilPermissaoPK.equals(other.perfilPermissaoPK));
    }

    public String toString() {
        return "perfilPermissao[ perfilPermissaoPK=" + this.perfilPermissaoPK + " ]";
    }
}

