/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Parentesco;
import br.com.fiorilli.sip.persistence.entity.PensionistaPK;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PENSIONISTAS")
@Audited
public class Pensionista
implements Serializable {
    public static final String FIND_BY_REGISTRO_MORTO = "SELECT p FROM Pensionista p JOIN FETCH p.trabalhadorPensionista JOIN FETCH p.trabalhadorRegistroMorto WHERE p.trabalhadorRegistroMorto.trabalhadorPK = :trabalhadorPK";
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected PensionistaPK pensionistaPK;
    @Type(type="BooleanTypeSip")
    @Column(name="PRINCIPAL")
    private Boolean principal;
    @FilterConfig(label="Pensionista", inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTROPENSIONISTA", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @OneToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhadorPensionista;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTROMORTO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhadorRegistroMorto;
    @Column(name="PARENTESCO")
    private String parentesco;
    @Column(name="DESCRICAO_PARENTESCO")
    private String descricaoParentesco;
    @Column(name="DTFIM")
    @Temporal(value=TemporalType.DATE)
    private Date dtFim;
    public static final String COUNT_BY_ENTIDADE_REGISTRO_PENSIONISTA = "  SELECT           COUNT(p.pensionistaPK.entidade)   FROM           Pensionista p   WHERE           p.pensionistaPK.entidade            = :entidade   AND     p.pensionistaPK.registropensionista = :registroPensionista";

    public Pensionista() {
    }

    public Pensionista(PensionistaPK pensionistaPK) {
        this.pensionistaPK = pensionistaPK;
    }

    public Pensionista(String entidade, String registromorto, String registropensionista) {
        this.pensionistaPK = new PensionistaPK(entidade, registromorto, registropensionista);
    }

    public PensionistaPK getPensionistaPK() {
        return this.pensionistaPK;
    }

    public void setPensionistaPK(PensionistaPK pensionistaPK) {
        this.pensionistaPK = pensionistaPK;
    }

    public Boolean getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    public Trabalhador getTrabalhadorPensionista() {
        return this.trabalhadorPensionista;
    }

    public void setTrabalhadorPensionista(Trabalhador trabalhadorPensionista) {
        this.trabalhadorPensionista = trabalhadorPensionista;
        if (trabalhadorPensionista != null) {
            this.pensionistaPK.setRegistropensionista(trabalhadorPensionista.getTrabalhadorPK().getRegistro());
        } else {
            this.pensionistaPK.setRegistropensionista(null);
        }
    }

    public Trabalhador getTrabalhadorRegistroMorto() {
        return this.trabalhadorRegistroMorto;
    }

    public void setTrabalhadorRegistroMorto(Trabalhador trabalhadorRegistroMorto) {
        this.trabalhadorRegistroMorto = trabalhadorRegistroMorto;
        if (trabalhadorRegistroMorto != null) {
            this.pensionistaPK.setEntidade(trabalhadorRegistroMorto.getTrabalhadorPK().getEntidade());
            this.pensionistaPK.setRegistromorto(trabalhadorRegistroMorto.getTrabalhadorPK().getRegistro());
        } else {
            this.pensionistaPK.setEntidade(null);
            this.pensionistaPK.setRegistromorto(null);
        }
    }

    public Parentesco getParentesco() {
        return Parentesco.of(this.parentesco);
    }

    public void setParentesco(Parentesco parentesco) {
        this.parentesco = parentesco.getCodigo();
    }

    public Date getDtFim() {
        return this.dtFim;
    }

    public void setDtFim(Date dtFim) {
        this.dtFim = dtFim;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.pensionistaPK != null ? this.pensionistaPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Pensionista)) {
            return false;
        }
        Pensionista other = (Pensionista)object;
        return (this.pensionistaPK != null || other.pensionistaPK == null) && (this.pensionistaPK == null || this.pensionistaPK.equals(other.pensionistaPK));
    }

    public String toString() {
        return "entity.Pensionistas[ pensionistasPK=" + this.pensionistaPK + " ]";
    }

    public String getDescricaoParentesco() {
        return this.descricaoParentesco;
    }

    public void setDescricaoParentesco(String descricaoParentesco) {
        this.descricaoParentesco = descricaoParentesco;
    }
}

