/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Medico;
import br.com.fiorilli.sip.persistence.entity.PcmsoSituacaoExame;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="PCMSO")
@Audited
public class Pcmso
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GET_FETCHED = "SELECT p FROM Pcmso p LEFT JOIN FETCH p.medico LEFT JOIN FETCH p.trabalhador WHERE p.id = :id";
    public static final String GENERATOR = "GEN_PCMSO";
    @Id
    @Basic(optional=false)
    @NotNull
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidade;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @Basic(optional=false)
    @NotNull
    @Column(name="DTEXAME")
    @Temporal(value=TemporalType.DATE)
    private Date dataExame;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=10)
    @Column(name="SITUEXAME")
    private String situacaoExame = PcmsoSituacaoExame.PENDENTE.getCodigo();
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @JoinColumn(name="MEDICO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Medico medico;

    public String getSituacaoExame() {
        return this.situacaoExame;
    }

    public void setSituacaoExame(String situacaoExame) {
        if (!PcmsoSituacaoExame.PENDENTE.getCodigo().equals(situacaoExame) && !PcmsoSituacaoExame.REALIZADO.getCodigo().equals(situacaoExame) && situacaoExame != null) {
            throw new IllegalArgumentException("Situa\u00e7\u00e3o do Exame do PCMSO Inv\u00e1lida");
        }
        this.situacaoExame = situacaoExame;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        if (trabalhador != null) {
            this.setEntidade(trabalhador.getTrabalhadorPK().getEntidade());
            this.setRegistro(trabalhador.getTrabalhadorPK().getRegistro());
        }
    }

    public Medico getMedico() {
        return this.medico;
    }

    public void setMedico(Medico medico) {
        this.medico = medico;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Date getDataExame() {
        return this.dataExame;
    }

    public void setDataExame(Date dataExame) {
        this.dataExame = dataExame;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pcmso other = (Pcmso)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "Pcmso [id=" + this.id + "]";
    }
}

