/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@FilterConfigType(autoFilter=true)
@Entity
@Table(name="PARAMVALEALIMENTACAO")
@Audited
public class ParametroValeAlimentacao
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_VALEALIMENTACAO";
    @Id
    private Integer codigo;
    @Column(name="EMPRESA", length=3)
    private String entidadeCodigo;
    @NotNull
    @Column(name="VINCULO", length=2)
    private String vinculoCodigo;
    @NotNull
    @Column(name="JORNADA")
    private Short jornadaCodigo;
    @NotNull
    @Column(name="EVENTO")
    private String eventoCodigo;
    @FilterConfig(label="Evento", inputType=FilterInputType.AUTO_COMPLETE, order=3)
    @FilterConfigSelect(query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome")
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Evento evento;
    @FilterConfig(label="Jornada", inputType=FilterInputType.AUTO_COMPLETE, order=2)
    @FilterConfigSelect(query="SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))")
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="JORNADA", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Jornada jornada;
    @FilterConfig(label="V\u00ednculo", inputType=FilterInputType.AUTO_COMPLETE, order=1)
    @FilterConfigSelect(query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo")
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="VINCULO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Vinculo vinculo;
    @Column(name="PERCENTUAL")
    private Double percentual;

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public String getVinculoCodigo() {
        return this.vinculoCodigo;
    }

    public void setVinculoCodigo(String vinculoCodigo) {
        this.vinculoCodigo = vinculoCodigo;
    }

    public Short getJornadaCodigo() {
        return this.jornadaCodigo;
    }

    public void setJornadaCodigo(Short jornadaCodigo) {
        this.jornadaCodigo = jornadaCodigo;
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public void setEventoCodigo(String eventoCodigo) {
        this.eventoCodigo = eventoCodigo;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        this.eventoCodigo = evento != null ? evento.getEventoPK().getCodigo() : null;
        this.evento = evento;
    }

    public Jornada getJornada() {
        return this.jornada;
    }

    public void setJornada(Jornada jornada) {
        this.jornadaCodigo = jornada != null ? jornada.getJornadaPK().getCodigo() : null;
        this.jornada = jornada;
    }

    public Vinculo getVinculo() {
        return this.vinculo;
    }

    public void setVinculo(Vinculo vinculo) {
        this.vinculoCodigo = vinculo != null ? vinculo.getVinculoPK().getCodigo() : null;
        this.vinculo = vinculo;
    }

    public Double getPercentual() {
        return this.percentual;
    }

    public void setPercentual(Double percentual) {
        this.percentual = percentual;
    }

    public String toString() {
        return "ParametroValeAlimentacao{codigo=" + this.codigo + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.codigo;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParametroValeAlimentacao other = (ParametroValeAlimentacao)obj;
        return this.codigo == other.codigo;
    }
}

