/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import java.util.Calendar;
import java.util.Date;

public enum ParametroHoraExtraDiaSemana {
    PADRAO(0, "Padr\u00e3o"),
    SEGUNDA_FEIRA(1, "Segunda-Feira"),
    TERCA_FEIRA(2, "Ter\u00e7a-Feira"),
    QUARTA_FEIRA(3, "Quarta-Feira"),
    QUINTA_FEIRA(4, "Quinta-Feira"),
    SEXTA_FEIRA(5, "Sexta-Feira"),
    SABADO(6, "S\u00e1bado"),
    DOMINGO(7, "Domingo");

    private int codigo;
    private String nome;

    private ParametroHoraExtraDiaSemana(int codigo, String nome) {
        this.codigo = codigo;
        this.nome = nome;
    }

    public int getCodigo() {
        return this.codigo;
    }

    public void setCodigo(int codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public static ParametroHoraExtraDiaSemana of(Integer codigo) {
        if (codigo != null) {
            for (ParametroHoraExtraDiaSemana d : ParametroHoraExtraDiaSemana.values()) {
                if (d.getCodigo() != codigo.intValue()) continue;
                return d;
            }
        }
        return null;
    }

    public static ParametroHoraExtraDiaSemana of(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayOfWeek = cal.get(7);
        if (--dayOfWeek == 0) {
            dayOfWeek = 7;
        }
        return ParametroHoraExtraDiaSemana.of(dayOfWeek);
    }

    public boolean isPadrao() {
        return this == PADRAO;
    }
}

