/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.commons.util.TimeUtils;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.ParametroHoraExtraDiaSemana;
import br.com.fiorilli.sip.persistence.entity.ParametroHoraExtraDiaSemanaDSR;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

@FilterConfigType(autoFilter=true)
@Entity
@Table(name="PARAMHORAEXTRA")
@Audited
public class ParametroHoraExtra
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ALL = "SELECT p FROM ParametroHoraExtra p";
    public static final String QUERY_UPDATE_ALL_HORA_LIMITE = "UPDATE ParametroHoraExtra p set p.horaLimiteDia = :horaLimiteDia";
    public static final String GENERATOR = "GEN_HORAEXTRA";
    @Id
    @Column(name="CODIGO", nullable=false)
    private int codigo;
    @Column(name="EMPRESA", length=3)
    private String entidadeCodigo;
    @FilterConfig(label="Per. In\u00edcio", mask="99:99", inputType=FilterInputType.TEXT, order=4)
    @Column(name="PERIODOINI", length=5)
    @NotNull
    private String periodoInicio;
    @FilterConfig(label="Per. Fim", mask="99:99", inputType=FilterInputType.TEXT, order=5)
    @Column(name="PERIODOFIM", length=5)
    @NotNull
    private String periodoFim;
    @FilterConfig(label="Feriado", inputType=FilterInputType.SELECT_ONE_MENU_BOOLEAN)
    @Type(type="BooleanTypeSip")
    @Column(name="FERIADO")
    private Boolean feriado;
    @FilterConfig(label="DSR", inputType=FilterInputType.SELECT_ONE_MENU_BOOLEAN)
    @Type(type="BooleanTypeSip")
    @Column(name="DSR")
    private Boolean dsr;
    @Column(name="DIA_SEMANA_DSR")
    private Integer diaSemanaDSR;
    @Column(name="VINCULO", length=2)
    private String vinculoCodigo;
    @Column(name="JORNADA")
    private Short jornadaCodigo;
    @NotNull
    @Column(name="EVENTO", length=3)
    private String eventoCodigo;
    @FilterConfig(label="Exclusivo para Dsr e Feriado", inputType=FilterInputType.SELECT_ONE_MENU_BOOLEAN)
    @Type(type="BooleanTypeSip")
    @Column(name="EXCLUSIVO_DSR_FERIADO")
    private Boolean exclusivoDsrFeriado;
    @FilterConfig(label="Intervalo", inputType=FilterInputType.SELECT_ONE_MENU_BOOLEAN)
    @Type(type="BooleanTypeSip")
    @Column(name="INTERVALO")
    private Boolean intervalo;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @FilterConfig(label="Evento", inputType=FilterInputType.AUTO_COMPLETE, order=1)
    @FilterConfigSelect(query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Evento evento;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @FilterConfig(label="Jornada", inputType=FilterInputType.AUTO_COMPLETE, order=3)
    @FilterConfigSelect(query="SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="JORNADA", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Jornada jornada;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @FilterConfig(label="V\u00ednculo", inputType=FilterInputType.AUTO_COMPLETE, order=2)
    @FilterConfigSelect(query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="VINCULO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Vinculo vinculo;
    @Column(name="HORA_LIMITE_DIA", length=5)
    private String horaLimiteDia;
    @Column(name="DIA_SEMANA")
    private Short diaSemana;
    @Type(type="BooleanTypeSip")
    @Column(name="IGNORAR_HORA_REDUZIDA_ADNOTURNO")
    private Boolean ignorarHoraReduzidaAdNoturno;

    public ParametroHoraExtra() {
    }

    public ParametroHoraExtra(Integer codigo) {
        this.codigo = codigo;
    }

    public ParametroHoraExtraDiaSemanaDSR getDiaSemanaDSR() {
        return ParametroHoraExtraDiaSemanaDSR.of(this.diaSemanaDSR);
    }

    public void setDiaSemanaDSR(ParametroHoraExtraDiaSemanaDSR diaSemanaDSR) {
        this.diaSemanaDSR = diaSemanaDSR == null ? null : Integer.valueOf(diaSemanaDSR.getCodigo());
    }

    public int getCodigo() {
        return this.codigo;
    }

    public void setCodigo(int codigo) {
        this.codigo = codigo;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidade) {
        this.entidadeCodigo = entidade;
    }

    public String getPeriodoInicio() {
        return this.periodoInicio;
    }

    public void setPeriodoInicio(String periodoini) {
        this.periodoInicio = periodoini;
    }

    public String getPeriodoFim() {
        return this.periodoFim;
    }

    public void setPeriodoFim(String periodofim) {
        this.periodoFim = periodofim;
    }

    public String getVinculoCodigo() {
        return this.vinculoCodigo;
    }

    public void setVinculoCodigo(String vinculo) {
        this.vinculoCodigo = vinculo;
    }

    public Short getJornadaCodigo() {
        return this.jornadaCodigo;
    }

    public void setJornadaCodigo(Short jornada) {
        this.jornadaCodigo = jornada;
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public void setEventoCodigo(String evento) {
        this.eventoCodigo = evento;
    }

    public Boolean getExclusivoDsrFeriado() {
        return this.exclusivoDsrFeriado;
    }

    public void setExclusivoDsrFeriado(Boolean exclusivoDsrFeriado) {
        this.exclusivoDsrFeriado = exclusivoDsrFeriado;
    }

    public Boolean getFeriado() {
        return this.feriado;
    }

    public void setFeriado(Boolean feriado) {
        this.feriado = feriado;
    }

    public Boolean getDsr() {
        return this.dsr;
    }

    public void setDsr(Boolean dsr) {
        this.dsr = dsr;
    }

    public Boolean getIntervalo() {
        return this.intervalo;
    }

    public void setIntervalo(Boolean intervalo) {
        this.intervalo = intervalo;
    }

    public void setDiaSemanaDSR(Integer diaSemanaDSR) {
        this.diaSemanaDSR = diaSemanaDSR;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        this.eventoCodigo = evento != null ? evento.eventoPK.getCodigo() : null;
        this.evento = evento;
    }

    public Jornada getJornada() {
        return this.jornada;
    }

    public void setJornada(Jornada jornada) {
        this.jornadaCodigo = jornada != null ? jornada.jornadaPK.getCodigo() : null;
        this.jornada = jornada;
    }

    public Vinculo getVinculo() {
        return this.vinculo;
    }

    public void setVinculo(Vinculo vinculo) {
        this.vinculoCodigo = vinculo != null ? vinculo.vinculoPK.getCodigo() : null;
        this.vinculo = vinculo;
    }

    public String getHoraLimiteDia() {
        return this.horaLimiteDia;
    }

    public void setHoraLimiteDia(String horaLimiteDia) {
        this.horaLimiteDia = horaLimiteDia;
    }

    public ParametroHoraExtraDiaSemana getDiaSemana() {
        return this.diaSemana != null ? ParametroHoraExtraDiaSemana.of(this.diaSemana.intValue()) : ParametroHoraExtraDiaSemana.PADRAO;
    }

    public void setDiaSemana(Short diaSemana) {
        this.diaSemana = diaSemana;
    }

    public void setDiaSemana(ParametroHoraExtraDiaSemana diaSemana) {
        this.diaSemana = diaSemana == null ? Short.valueOf((short)ParametroHoraExtraDiaSemana.PADRAO.getCodigo()) : Short.valueOf((short)diaSemana.getCodigo());
    }

    public Boolean getIgnorarHoraReduzidaAdNoturno() {
        return this.ignorarHoraReduzidaAdNoturno;
    }

    public void setIgnorarHoraReduzidaAdNoturno(Boolean ignorarHoraReduzidaAdNoturno) {
        this.ignorarHoraReduzidaAdNoturno = ignorarHoraReduzidaAdNoturno;
    }

    public Interval getInterval(Date date) {
        if ("00:00".equals(this.getPeriodoFim())) {
            this.setPeriodoFim("23:59");
        }
        DateTime start = TimeUtils.toDateTime((Date)date, (String)this.getPeriodoInicio());
        DateTime end = TimeUtils.toDateTime((Date)date, (String)this.getPeriodoFim());
        if (start != null && end != null) {
            if (end.isBefore((ReadableInstant)start) || this.getPeriodoInicio().equals(this.getPeriodoFim())) {
                end = end.plusDays(1);
            }
            end = this.adjustSummerTime(start, end);
            return new Interval((ReadableInstant)start, (ReadableInstant)end);
        }
        return null;
    }

    private DateTime adjustSummerTime(DateTime start, DateTime end) {
        DateTime endAdjusted;
        if (start.getZone().getOffset(start.getMillis()) != end.getZone().getOffset(end.getMillis()) && (endAdjusted = end.withZone(DateTimeZone.forOffsetHours((int)-3))).hourOfDay().get() != end.hourOfDay().get() && end.hourOfDay().get() > endAdjusted.hourOfDay().get()) {
            endAdjusted = endAdjusted.plusHours(1);
            return endAdjusted;
        }
        return end;
    }

    public List<Interval> getIntervals(Date date) {
        DateTime start = TimeUtils.toDateTime((Date)date, (String)this.getPeriodoInicio());
        DateTime end = TimeUtils.toDateTime((Date)date, (String)this.getPeriodoFim());
        if (start != null && end != null) {
            if (end.isBefore((ReadableInstant)start) || this.getPeriodoInicio().equals(this.getPeriodoFim())) {
                Interval intervalFirstDayB = new Interval((ReadableInstant)TimeUtils.toDateTime((Date)start.toDate(), (String)"00:00"), (ReadableInstant)end);
                end = end.plusDays(1);
                Interval intervalFirstDayA = new Interval((ReadableInstant)start, (ReadableInstant)end);
                Interval intervalSecondDayB = new Interval((ReadableInstant)start.plusDays(1), (ReadableInstant)TimeUtils.toDateTime((Date)end.toDate(), (String)"23:59"));
                return Arrays.asList(intervalFirstDayA, intervalFirstDayB, intervalSecondDayB);
            }
            return Arrays.asList(new Interval((ReadableInstant)start, (ReadableInstant)end));
        }
        return new ArrayList<Interval>();
    }

    public Duration getHoraLimiteDiaDuration() {
        return TimeUtils.toDuration((String)StringUtils.defaultString((String)this.horaLimiteDia, (String)"00:00"));
    }

    public boolean hasSameWeekday(Date dataPonto) {
        return this.getDiaSemana() != null && this.getDiaSemana().equals((Object)ParametroHoraExtraDiaSemana.of(dataPonto));
    }

    public String toString() {
        return "ParametroHoraExtra{codigo=" + this.codigo + ", entidadeCodigo='" + this.entidadeCodigo + '\'' + ", periodoInicio='" + this.periodoInicio + '\'' + ", periodoFim='" + this.periodoFim + '\'' + ", feriado=" + this.feriado + ", dsr=" + this.dsr + ", diaSemanaDSR=" + this.diaSemanaDSR + ", vinculoCodigo='" + this.vinculoCodigo + '\'' + ", jornadaCodigo=" + this.jornadaCodigo + ", eventoCodigo='" + this.eventoCodigo + '\'' + ", exclusivoDsrFeriado=" + this.exclusivoDsrFeriado + ", evento=" + this.evento + ", jornada=" + this.jornada + ", vinculo=" + this.vinculo + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.codigo;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParametroHoraExtra other = (ParametroHoraExtra)obj;
        return this.codigo == other.codigo;
    }
}

