/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@FilterConfigType(autoFilter=true)
@Entity
@Table(name="PARAMFALTAS")
@Audited
public class ParametroFalta
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_FALTAS";
    @Id
    private Integer codigo;
    @Column(name="EMPRESA", length=3)
    private String entidadeCodigo;
    @NotNull
    @Column(name="VINCULO", length=2)
    private String vinculoCodigo;
    @NotNull
    @Column(name="JORNADA")
    private Short jornadaCodigo;
    @NotNull
    @Column(name="EVENTO_HORAS")
    private String eventoHorasCodigo;
    @NotNull
    @Column(name="EVENTO_DIAS")
    private String eventoDiasCodigo;
    @FilterConfig(label="Per\u00edodo Inteiro Evento Dia", inputType=FilterInputType.SELECT_ONE_MENU_BOOLEAN)
    @Type(type="BooleanTypeSip")
    @Column(name="PERIODO_INTEIRO_EVENTO_DIA")
    private Boolean periodoInteiroEventoDia;
    @FilterConfig(label="Evento Dias", inputType=FilterInputType.AUTO_COMPLETE, order=3)
    @FilterConfigSelect(query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome")
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO_DIAS", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Evento eventoDias;
    @FilterConfig(label="Evento Horas", inputType=FilterInputType.AUTO_COMPLETE, order=4)
    @FilterConfigSelect(query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome")
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO_HORAS", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Evento eventoHoras;
    @FilterConfig(label="Jornada", inputType=FilterInputType.AUTO_COMPLETE, order=2)
    @FilterConfigSelect(query="SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))")
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="JORNADA", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Jornada jornada;
    @FilterConfig(label="V\u00ednculo", inputType=FilterInputType.AUTO_COMPLETE, order=1)
    @FilterConfigSelect(query="SELECT v FROM Vinculo v WHERE concat(v.vinculoPK.codigo, v.nome) LIKE concat('%', :param, '%') AND v.vinculoPK.entidade = :entidadeCodigo")
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="VINCULO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Vinculo vinculo;

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Vinculo getVinculo() {
        return this.vinculo;
    }

    public void setVinculo(Vinculo vinculo) {
        this.vinculoCodigo = vinculo != null ? vinculo.getVinculoPK().getCodigo() : null;
        this.vinculo = vinculo;
    }

    public Evento getEventoDias() {
        return this.eventoDias;
    }

    public void setEventoDias(Evento eventoDias) {
        this.eventoDiasCodigo = eventoDias != null ? eventoDias.getEventoPK().getCodigo() : null;
        this.eventoDias = eventoDias;
    }

    public Evento getEventoHoras() {
        return this.eventoHoras;
    }

    public void setEventoHoras(Evento eventoHoras) {
        this.eventoHorasCodigo = eventoHoras != null ? eventoHoras.getEventoPK().getCodigo() : null;
        this.eventoHoras = eventoHoras;
    }

    public Jornada getJornada() {
        return this.jornada;
    }

    public void setJornada(Jornada jornada) {
        this.jornadaCodigo = jornada != null ? jornada.getJornadaPK().getCodigo() : null;
        this.jornada = jornada;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeId) {
        this.entidadeCodigo = entidadeId;
    }

    public String getVinculoCodigo() {
        return this.vinculoCodigo;
    }

    public void setVinculoCodigo(String vinculoId) {
        this.vinculoCodigo = vinculoId;
    }

    public Short getJornadaCodigo() {
        return this.jornadaCodigo;
    }

    public void setJornadaCodigo(Short jornadaId) {
        this.jornadaCodigo = jornadaId;
    }

    public String getEventoHorasCodigo() {
        return this.eventoHorasCodigo;
    }

    public void setEventoHorasCodigo(String eventoHorasId) {
        this.eventoHorasCodigo = eventoHorasId;
    }

    public String getEventoDiasCodigo() {
        return this.eventoDiasCodigo;
    }

    public void setEventoDiasCodigo(String eventoDiasId) {
        this.eventoDiasCodigo = eventoDiasId;
    }

    public Boolean getPeriodoInteiroEventoDia() {
        return this.periodoInteiroEventoDia;
    }

    public void setPeriodoInteiroEventoDia(Boolean periodoInteiroEventoDia) {
        this.periodoInteiroEventoDia = periodoInteiroEventoDia;
    }

    public String toString() {
        return "ParametroFalta [codigo=" + this.codigo + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.codigo;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParametroFalta other = (ParametroFalta)obj;
        return this.codigo == other.codigo;
    }
}

