/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigEnum;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.commons.util.TimeUtils;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.BancoHorasParametros;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.MesNomeEnum;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;

@FilterConfigType(rootQueryType=PagamentoBancoHoras.class, autoFilter=true)
@Entity
@Table(name="SIPBH_SALDO_PAGTO")
@Audited
public class PagamentoBancoHoras
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GET_NEXT_ITEM = "SELECT coalesce(max(p.id), 0) + 1 FROM PagamentoBancoHoras p WHERE p.entidadeCodigo = :entidadeCodigo";
    public static final String FIND_BY_TRABALHADOR = "SELECT DISTINCT p FROM PagamentoBancoHoras p JOIN FETCH p.trabalhador WHERE p.trabalhador.trabalhadorPK.entidade = :entidade AND p.trabalhador.trabalhadorPK.registro = :registro";
    public static final String FIND_BY_EVENTO = "SELECT DISTINCT p FROM PagamentoBancoHoras p JOIN FETCH p.evento WHERE p.evento.eventoPK.entidade = :entidade AND p.evento.eventoPK.codigo = :codigo";
    @Id
    @NotNull
    @Basic(optional=false)
    private Integer id;
    @FilterConfig(label="Ano", order=3, condition=FilterCondition.ANO_IGUAL)
    @Size(max=4)
    @NotNull
    @Basic(optional=false)
    @Column(name="ANO")
    private String ano;
    @NotNull
    @Basic(optional=false)
    @Column(name="HORAS")
    private double horas;
    @FilterConfig(label="M\u00eas", inputType=FilterInputType.SELECT_ONE_MENU)
    @FilterConfigEnum(enumClass=MesNomeEnum.class, enumId="codigo", itemLabel="nome")
    @Size(max=2)
    @NotNull
    @Basic(optional=false)
    @Column(name="MES")
    private String mes;
    @NotNull
    @Basic(optional=false)
    @Column(name="TIPOREFERENCIA")
    private String tiporeferencia;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @FilterConfig(label="Evento", inputType=FilterInputType.AUTO_COMPLETE, order=5)
    @FilterConfigSelect(query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Evento evento;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @FilterConfig(label="Nome", inputType=FilterInputType.AUTO_COMPLETE, order=1)
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo")
    @NotNull
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EVENTO")
    private String eventoCodigo;
    @FilterConfig(label="Registro", order=2, condition=FilterCondition.IGUAL)
    @Column(name="REGISTRO")
    private String registro;
    @Column(name="DTLANCTO")
    @Temporal(value=TemporalType.DATE)
    private Date dataLancamento;
    @NotNull
    @Column(name="VIGENCIA")
    private Integer vigencia;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="VIGENCIA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private BancoHorasParametros bancoHorasParametros;

    public PagamentoBancoHoras() {
    }

    public PagamentoBancoHoras(Integer id) {
        this.id = id;
    }

    public PagamentoBancoHoras(Integer id, String ano, double horas, String mes, String tiporeferencia) {
        this.id = id;
        this.ano = ano;
        this.horas = horas;
        this.mes = mes;
        this.tiporeferencia = tiporeferencia;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getAno() {
        return this.ano;
    }

    public void setAno(String ano) {
        this.ano = ano;
    }

    public double getHoras() {
        return this.horas;
    }

    public void setHoras(double horas) {
        this.horas = horas;
    }

    public String getMes() {
        return this.mes;
    }

    public void setMes(String mes) {
        this.mes = mes;
    }

    public String getTiporeferencia() {
        return this.tiporeferencia;
    }

    public void setTiporeferencia(String tiporeferencia) {
        this.tiporeferencia = tiporeferencia;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        this.eventoCodigo = evento != null ? evento.eventoPK.getCodigo() : null;
        this.evento = evento;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public void setEventoCodigo(String eventoCodigo) {
        this.eventoCodigo = eventoCodigo;
    }

    public Date getDataLancamento() {
        return this.dataLancamento;
    }

    public void setDataLancamento(Date dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    public Integer getVigencia() {
        return this.vigencia;
    }

    public void setVigencia(Integer vigencia) {
        this.vigencia = vigencia;
    }

    public BancoHorasParametros getBancoHorasParametros() {
        return this.bancoHorasParametros;
    }

    public void setBancoHorasParametros(BancoHorasParametros bancoHorasParametros) {
        this.bancoHorasParametros = bancoHorasParametros;
    }

    public String getHorasString() {
        try {
            return StringUtils.leftPad((String)TimeUtils.toStringTime((Double)this.horas, (int)3), (int)6, (char)'0');
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setHorasString(String horasString) {
        try {
            this.horas = TimeUtils.toDoubleTime((String)horasString);
        }
        catch (Exception e) {
            this.horas = 0.0;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PagamentoBancoHoras)) {
            return false;
        }
        PagamentoBancoHoras other = (PagamentoBancoHoras)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "PagamentoBancoHoras [id=" + this.id + "]";
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }
}

