/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.OrdemExclusaoConvenioPK;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@FilterConfigType(rootQueryType=OrdemExclusaoConvenio.class, autoFilter=true)
@Entity
@Table(name="ORDEM_EXCLUSAO_CONVENIOS")
@Audited
public class OrdemExclusaoConvenio
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private OrdemExclusaoConvenioPK ordemExclusaoConvenioPK = new OrdemExclusaoConvenioPK();
    @FilterConfig(label="Nome", order=2)
    @FilterConfigSelect(query="SELECT e FROM Evento e WHERE UPPER(concat(e.eventoPK.codigo, e.nome)) LIKE UPPER(concat('%', :param, '%')) AND e.eventoPK.entidade = :entidadeCodigo ORDER BY e.nome")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.EAGER)
    private Evento evento;
    @FilterConfig(label="Ordem", order=3, condition=FilterCondition.CONTENHA)
    @Column(name="ORDEM")
    private int ordem;

    public OrdemExclusaoConvenioPK getOrdemExclusaoConvenioPK() {
        return this.ordemExclusaoConvenioPK;
    }

    public void setOrdemExclusaoConvenioPK(OrdemExclusaoConvenioPK id) {
        this.ordemExclusaoConvenioPK = id;
    }

    public int getOrdem() {
        return this.ordem;
    }

    public void setOrdem(int ordem) {
        this.ordem = ordem;
    }

    public Evento getEvento() {
        if (this.evento == null) {
            this.evento = new Evento();
        }
        return this.evento;
    }

    public void setEvento(Evento evento) {
        if (evento != null) {
            this.ordemExclusaoConvenioPK.setEvento(evento.getEventoPK().getCodigo());
            this.ordemExclusaoConvenioPK.setEmpresa(evento.getEventoPK().getEntidade());
        } else {
            this.ordemExclusaoConvenioPK.setEvento(null);
            this.ordemExclusaoConvenioPK.setEmpresa(null);
        }
        this.evento = evento;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ordemExclusaoConvenioPK == null ? 0 : this.ordemExclusaoConvenioPK.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrdemExclusaoConvenio)) {
            return false;
        }
        OrdemExclusaoConvenio other = (OrdemExclusaoConvenio)obj;
        return !(this.ordemExclusaoConvenioPK == null ? other.ordemExclusaoConvenioPK != null : !this.ordemExclusaoConvenioPK.equals(other.ordemExclusaoConvenioPK));
    }

    public String toString() {
        return "OrdemExclusaoConvenio [ordemExclusaoConvenioPK=" + this.ordemExclusaoConvenioPK + "]";
    }
}

