/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="NAO_OPTANTE_INCIDENCIA")
@FilterConfigType(autoFilter=true)
@Audited
public class NaoOptanteIncidencia
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_NAOOPTANTEINCIDENCIA";
    @Id
    @NotNull
    @Column(name="ID")
    private Integer id;
    @NotNull
    @Basic(optional=false)
    @Size(max=3)
    @Column(name="EVENTO")
    private String eventoCodigo;
    @NotNull
    @Basic(optional=false)
    @Size(max=3)
    @Column(name="EMPRESA")
    private String entidade;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @FilterConfig(label="Evento", condition=FilterCondition.COMECE, order=1, inputType=FilterInputType.TEXT)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento evento;
    @NotNull
    @Basic(optional=false)
    @Column(name="REGISTRO")
    private String registro;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public void setEventoCodigo(String eventoCodigo) {
        this.eventoCodigo = eventoCodigo;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public Evento getEvento() {
        if (this.evento == null) {
            this.evento = new Evento();
        }
        return this.evento;
    }

    public void setEvento(Evento evento) {
        this.evento = evento;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        if (trabalhador != null) {
            this.entidade = trabalhador.getTrabalhadorPK().getEntidade();
            this.registro = trabalhador.getTrabalhadorPK().getRegistro();
        } else {
            this.entidade = null;
            this.registro = null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NaoOptanteIncidencia other = (NaoOptanteIncidencia)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "NaoOptanteIncidencia [id=" + this.id + "]";
    }
}

