/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Causa;
import br.com.fiorilli.sip.persistence.entity.Cid;
import br.com.fiorilli.sip.persistence.entity.CidMovimentoSefip;
import br.com.fiorilli.sip.persistence.entity.CodigoAfastamento;
import br.com.fiorilli.sip.persistence.entity.CodigoMovimentoSefip;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorCargo;
import br.com.fiorilli.sip.persistence.entity.Medico;
import br.com.fiorilli.sip.persistence.entity.MovimentoSefipDocumentoRetorno;
import br.com.fiorilli.sip.persistence.entity.MovimentoSefipDocumentoSaida;
import br.com.fiorilli.sip.persistence.entity.MovimentoSefipTransferencia;
import br.com.fiorilli.sip.persistence.entity.Referencia;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorSituacao;
import br.com.fiorilli.sipweb.vo.FrequenciaVO;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="MOVTOSEFIP")
@Audited
public class MovimentoSefip
implements Serializable {
    public static final String GENERATOR = "GEN_MOVTOSEFIP";
    public static final String FIND_BY_ID = "SELECT m FROM MovimentoSefip m WHERE m.id = :id";
    public static final String GET_FETCHED = "SELECT m FROM MovimentoSefip m LEFT JOIN FETCH m.documentoSaida.tipoLegal LEFT JOIN FETCH m.documentoRetorno.tipoLegal LEFT JOIN FETCH m.medico LEFT JOIN FETCH m.perito LEFT JOIN FETCH m.cidmedico LEFT JOIN FETCH m.cidperito LEFT JOIN FETCH m.codigoMovimentoSefipSaida LEFT JOIN FETCH m.codigoMovimentoSefipEntrada LEFT JOIN FETCH m.trabalhador LEFT JOIN FETCH m.causa WHERE m.id = :id";
    public static final String FIND_BY_TRABALHADOR = "SELECT mo FROM MovimentoSefip mo JOIN FETCH mo.trabalhador tr LEFT JOIN FETCH mo.codigoAfastamento sr LEFT JOIN FETCH mo.cidperito ci LEFT JOIN FETCH mo.causa LEFT JOIN FETCH mo.codigoMovimentoSefipEntrada LEFT JOIN FETCH mo.codigoMovimentoSefipSaida LEFT JOIN FETCH mo.medico LEFT JOIN FETCH mo.perito LEFT JOIN FETCH mo.documentoSaida.tipoLegal LEFT JOIN FETCH mo.documentoRetorno.tipoLegal LEFT JOIN FETCH mo.cidperito LEFT JOIN FETCH mo.cidmedico WHERE tr.trabalhadorPK = :trabalhadorPK AND mo.situacao IN ('3') ORDER BY mo.dataInicio DESC";
    public static final String FIND_BY_TRABALHADOR_FOR_MOVIMENTOVO = "SELECT NEW br.com.fiorilli.sipweb.vo.MovimentoVo(m.situacao, m.causaCodigo, COALESCE(CONCAT(m.codigoMovimentoSefipSaidaCodigo, ''), m.causaCodigo), CONCAT(m.codigoMovimentoSefipSaidaCodigo, ''), m.dataInicio, m.dataFim, s.nome, e.nome,  c.nome, m.codigoAfastamentoId, r.nome, m.documentoSaida.tipoLegal, m.documentoSaida.numeroDocumento, m.documentoSaida.data) FROM MovimentoSefip m LEFT JOIN m.codigoMovimentoSefipSaida s LEFT JOIN m.codigoMovimentoSefipEntrada e LEFT JOIN m.causa c LEFT JOIN m.codigoAfastamento r WHERE m.trabalhador.trabalhadorPK = :trabalhadorPK  AND ((m.codigoMovimentoSefipSaida IS NOT NULL) OR (m.causaCodigo IN ('97','99'))) and ((((m.situacao IN ('3')) AND ( ((m.dataFim IS NULL) AND (m.dataInicio < :periodoFim)) OR (m.dataInicio BETWEEN :periodoInicio AND :periodoFim) OR ((m.dataFim > :periodoInicio) AND (m.dataInicio <= :periodoFim)) OR ((m.dataFim > :periodoFim) AND (m.dataInicio <= :periodoFim))))) OR ((m.situacao IN ('2','4','5')) AND (m.dataInicio BETWEEN :periodoInicio AND :periodoFim)))  ORDER BY m.dataInicio, m.dataFim ";
    public static final String IS_TRABALHADOR_AFASTADO = "SELECT CASE WHEN COALESCE(COUNT(mo.id), 0) > 0 THEN TRUE ELSE FALSE END FROM MovimentoSefip mo JOIN mo.trabalhador tr WHERE tr.documentosPessoais.cpf = :cpf AND mo.situacao IN ('3') AND CURRENT_DATE BETWEEN mo.dataInicio AND COALESCE((mo.dataFim - 1), CURRENT_DATE)";
    public static final String FIND_BY_DATA = "SELECT concat(m.codigoAfastamentoId, ' - ', m.codigoAfastamento.nome) AS causa, m.dataInicio AS dataInicio, m.dataFim AS dataFim FROM MovimentoSefip m WHERE m.trabalhador.trabalhadorPK = :trabalhadorPK AND (\t(m.situacao = '3' AND ((m.dataFim IS NULL AND m.dataInicio < :dataFim) OR (m.dataInicio BETWEEN :dataInicio AND :dataFim) OR (m.dataFim > :dataInicio AND m.dataInicio <= :dataFim) OR (m.dataFim > :dataFim AND m.dataInicio <= :dataFim))) \tOR \t(m.situacao IN ('2', '4', '5') AND m.dataInicio BETWEEN :dataInicio AND :dataFim))";
    public static final String FIND_BY_PERIODO = "SELECT concat(m.codigoAfastamentoId, ' - ', m.codigoAfastamento.nome) AS causa, m.dataInicio AS gozoInicio, coalesce(m.dataAlta, m.dataFim-1) AS gozoFim FROM MovimentoSefip m WHERE m.trabalhador.trabalhadorPK = :trabalhadorPK AND ((m.codigoMovimentoSefipSaida IS NOT NULL) OR (m.causaCodigo IN ('97','99'))) and ((((m.situacao IN ('3')) AND ( ((m.dataFim IS NULL) AND (m.dataInicio < :periodoFim)) OR (m.dataInicio BETWEEN :periodoInicio AND :periodoFim) OR ((m.dataFim > :periodoInicio) AND (m.dataInicio <= :periodoFim)) OR ((m.dataFim > :periodoFim) AND (m.dataInicio <= :periodoFim))))) OR ((m.situacao IN ('2','4','5')) AND (m.dataInicio BETWEEN :periodoInicio AND :periodoFim))) AND m.codigoAfastamento.verificaFrequencia = true  ORDER BY m.dataInicio, m.dataFim ";
    public static final String FIND_AFASTAMENTO_APOS_FERIAS_BY_DATA = "SELECT m.dataInicio AS dataInicio, m.dataFim AS dataFim FROM MovimentoSefip m WHERE m.trabalhador.trabalhadorPK = :trabalhadorPK AND m.situacao IN ('2', '4', '5') AND (COALESCE(m.dataFim, CURRENT_DATE) + 1) = :data";
    public static final String FIND_DATA_INICIO_BY_ENTIDADE_REGISTRO_CAUSA = " SELECT s.dataInicio  FROM MovimentoSefip s  WHERE s.entidadeCodigo = :empresa  AND s.registro = :registro  AND s.causaCodigo = :causa ";
    private static final long serialVersionUID = 1L;
    @Id
    @NotNull
    @Column(name="ITEM", unique=true, nullable=false)
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Column(name="SITUACAO")
    private String situacao;
    @NotNull
    @Column(name="RAIS", length=2)
    private String causaCodigo;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="RAIS", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Causa causa;
    @FilterConfig(label="Data Saida", inputType=FilterInputType.CALENDAR, condition=FilterCondition.INTERVALO)
    @Column(name="DTINI")
    @Temporal(value=TemporalType.DATE)
    private Date dataInicio;
    @Embedded
    private MovimentoSefipDocumentoSaida documentoSaida;
    @FilterConfig(label="Data Retorno", inputType=FilterInputType.CALENDAR, condition=FilterCondition.INTERVALO)
    @Column(name="DTFIM")
    @Temporal(value=TemporalType.DATE)
    private Date dataFim;
    @Type(type="BooleanTypeSip")
    @Column(name="RECOLHEUGRFC")
    private Boolean recolheugrfc;
    @Type(type="BooleanTypeSip")
    @Column(name="PERDE_13SAL_SAIDA")
    private Boolean perde13salSaida;
    @Column(name="PERD_13SAL_RETORNO")
    private Character perd13salRetorno;
    @Column(name="DTALTA")
    @Temporal(value=TemporalType.DATE)
    private Date dataAlta;
    @Column(name="TIPO_CONTRATO_MTE1621")
    private Short tipoContratoMte1621;
    @Size(max=3)
    @Column(name="CAUSA_TRCT_1057")
    private String causaTrct1057;
    @OneToOne(cascade={CascadeType.ALL}, mappedBy="movtosefip", fetch=FetchType.LAZY)
    private MovimentoSefipTransferencia movtosefipTransf;
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Entidade entidade;
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @Column(name="DATA_LANCAMENTO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataLancamento;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @FilterConfig(label="Trabalhador", inputType=FilterInputType.AUTO_COMPLETE, blockCondition=true)
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @Embedded
    private MovimentoSefipDocumentoRetorno documentoRetorno;
    @Column(name="REDUZIDO")
    private Integer codigoAfastamentoId;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REDUZIDO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    private CodigoAfastamento codigoAfastamento;
    @Column(name="REFERENCIA")
    private Integer referenciaCodigo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="REFERENCIA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Referencia referencia;
    @Column(name="PERITO")
    private Integer peritoCodigo;
    @JoinColumn(name="PERITO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Medico perito;
    @Column(name="MEDICO")
    private Integer medicoCodigo;
    @JoinColumn(name="MEDICO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Medico medico;
    @Column(name="ID_SEFIP_ENT")
    private Integer codigoMovimentoSefipEntradaCodigo;
    @JoinColumn(name="ID_SEFIP_ENT", referencedColumnName="ID", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.EAGER)
    private CodigoMovimentoSefip codigoMovimentoSefipEntrada;
    @Column(name="ID_SEFIP_SAI")
    private Integer codigoMovimentoSefipSaidaCodigo;
    @JoinColumn(name="ID_SEFIP_SAI", referencedColumnName="ID", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.EAGER)
    private CodigoMovimentoSefip codigoMovimentoSefipSaida;
    @Column(name="CIDPERITO")
    private String cidPeritoCodigo;
    @JoinColumn(name="CIDPERITO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Cid cidperito;
    @Column(name="CIDMEDICO")
    private String cidMedicoCodigo;
    @JoinColumn(name="CIDMEDICO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Cid cidmedico;
    @JoinColumn(name="ID_HISTTRABCARGO", referencedColumnName="ID")
    @ManyToOne(fetch=FetchType.LAZY)
    private HistoricoTrabalhadorCargo historicoTrabalhadorCargo;
    @Size(max=10)
    @Column(name="NUMERO_BENEFICIO")
    private String numeroBeneficio;
    @Size(max=512)
    @Column(name="OBS")
    private String obs;
    @Column(name="DT_PERICIA")
    @Temporal(value=TemporalType.DATE)
    private Date dataPericia;
    @Column(name="USER_WS_INC")
    @Size(max=30)
    private String userWsInc;
    @Column(name="DT_WS_INC")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataWsInc;
    @Column(name="USER_WS_ALT")
    @Size(max=30)
    private String userWsAlt;
    @Column(name="DT_WS_ALT")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataWsAlt;
    @OneToMany(mappedBy="movimentoSefip", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CidMovimentoSefip> cids;

    public MovimentoSefip() {
    }

    public MovimentoSefip(Integer id) {
        this.id = id;
    }

    public MovimentoSefip(Integer id, String situacao, Causa causa) {
        this.id = id;
        this.situacao = situacao;
        this.causaCodigo = causa.getCodigo();
    }

    public MovimentoSefip(Builder builder) {
        this.setTrabalhador(builder.trabalhador);
        this.setCodigoAfastamento(builder.sefipReduzido);
        this.setCausa(builder.causa);
        this.setCodigoMovimentoSefipEntrada(builder.sefipEntrada);
        this.setCodigoMovimentoSefipSaida(builder.sefipSaida);
        this.setDataInicio(builder.dataSaida);
        this.setSituacao(builder.situacao);
        this.setDocumentoSaida(builder.documentacaoSaida);
        this.setMedico(builder.medico);
        this.setCidmedico(builder.cidMedico);
        this.setPerito(builder.perito);
        this.setCidperito(builder.cidPerito);
        this.setDataPericia(builder.dataPericia);
        this.setDocumentoRetorno(builder.documentacaoRetorno);
        this.setNumeroBeneficio(builder.numeroBenificioRetorno);
        this.setObs(builder.observacoes);
        this.setDataFim(builder.dataFim);
        this.setDataAlta(builder.dataAlta);
        this.setUserWsInc(builder.usuarioDeInclusaoNoWebService);
        this.setDataWsInc(builder.dataInclusaoNoWebService);
        this.setUserWsAlt(builder.usuarioDeAlteracaoNoWebService);
        this.setDataWsAlt(builder.dataAlteracaoNoWebService);
    }

    public TrabalhadorSituacao getSituacao() {
        return TrabalhadorSituacao.get(this.situacao);
    }

    public void setSituacao(TrabalhadorSituacao trabalahdorSituacao) {
        this.situacao = trabalahdorSituacao.getCodigo();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    public Date getDataFim() {
        return this.dataFim;
    }

    public void setDataFim(Date dataFim) {
        this.dataFim = dataFim;
    }

    public Boolean getRecolheugrfc() {
        return this.recolheugrfc;
    }

    public void setRecolheugrfc(Boolean recolheugrfc) {
        this.recolheugrfc = recolheugrfc;
    }

    public Boolean getPerde13salSaida() {
        return this.perde13salSaida;
    }

    public void setPerde13salSaida(Boolean perde13salSaida) {
        this.perde13salSaida = perde13salSaida;
    }

    public Character getPerd13salRetorno() {
        return this.perd13salRetorno;
    }

    public void setPerd13salRetorno(Character perd13salRetorno) {
        this.perd13salRetorno = perd13salRetorno;
    }

    public Date getDataAlta() {
        return this.dataAlta;
    }

    public void setDataAlta(Date dtalta) {
        this.dataAlta = dtalta;
    }

    public Short getTipoContratoMte1621() {
        return this.tipoContratoMte1621;
    }

    public void setTipoContratoMte1621(Short tipoContratoMte1621) {
        this.tipoContratoMte1621 = tipoContratoMte1621;
    }

    public String getCausaTrct1057() {
        return this.causaTrct1057;
    }

    public void setCausaTrct1057(String causaTrct1057) {
        this.causaTrct1057 = causaTrct1057;
    }

    public MovimentoSefipTransferencia getMovtosefipTransf() {
        return this.movtosefipTransf;
    }

    public void setMovtosefipTransf(MovimentoSefipTransferencia movtosefipTransf) {
        this.movtosefipTransf = movtosefipTransf;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        if (trabalhador != null) {
            this.registro = trabalhador.getTrabalhadorPK().getRegistro();
            this.entidadeCodigo = trabalhador.getTrabalhadorPK().getEntidade();
        } else {
            this.registro = null;
            this.entidadeCodigo = null;
        }
        this.trabalhador = trabalhador;
    }

    public CodigoAfastamento getCodigoAfastamento() {
        return this.codigoAfastamento;
    }

    public void setCodigoAfastamento(CodigoAfastamento codigo) {
        this.codigoAfastamentoId = codigo != null ? codigo.getSefipReduzidoPK().getCodigo() : null;
        this.codigoAfastamento = codigo;
    }

    public Referencia getReferencia() {
        return this.referencia;
    }

    public void setReferencia(Referencia referencia) {
        this.referenciaCodigo = referencia != null ? referencia.getCodigo() : null;
        this.referencia = referencia;
    }

    public Medico getPerito() {
        return this.perito;
    }

    public void setPerito(Medico perito) {
        this.peritoCodigo = perito != null ? perito.getCodigo() : null;
        this.perito = perito;
    }

    public Medico getMedico() {
        return this.medico;
    }

    public void setMedico(Medico medico) {
        this.medicoCodigo = medico != null ? medico.getCodigo() : null;
        this.medico = medico;
    }

    public CodigoMovimentoSefip getCodigoMovimentoSefipEntrada() {
        return this.codigoMovimentoSefipEntrada;
    }

    public void setCodigoMovimentoSefipEntrada(CodigoMovimentoSefip codigoMovimentoSefipEntrada) {
        this.codigoMovimentoSefipEntradaCodigo = codigoMovimentoSefipEntrada != null ? codigoMovimentoSefipEntrada.getId() : null;
        this.codigoMovimentoSefipEntrada = codigoMovimentoSefipEntrada;
    }

    public CodigoMovimentoSefip getCodigoMovimentoSefipSaida() {
        return this.codigoMovimentoSefipSaida;
    }

    public void setCodigoMovimentoSefipSaida(CodigoMovimentoSefip codigoMovimentoSefipSaida) {
        this.codigoMovimentoSefipSaidaCodigo = codigoMovimentoSefipSaida != null ? codigoMovimentoSefipSaida.getId() : null;
        this.codigoMovimentoSefipSaida = codigoMovimentoSefipSaida;
    }

    public Cid getCidperito() {
        return this.cidperito;
    }

    public void setCidperito(Cid cidperito) {
        this.cidPeritoCodigo = cidperito != null ? cidperito.getCodigo() : null;
        this.cidperito = cidperito;
    }

    public Cid getCidmedico() {
        return this.cidmedico;
    }

    public void setCidmedico(Cid cidmedico) {
        this.cidMedicoCodigo = cidmedico != null ? cidmedico.getCodigo() : null;
        this.cidmedico = cidmedico;
    }

    public Integer getCodigoAfastamentoId() {
        return this.codigoAfastamentoId;
    }

    public void setCodigoAfastamentoId(Integer reduzido) {
        this.codigoAfastamentoId = reduzido;
    }

    public String getCausaCodigo() {
        return this.causaCodigo;
    }

    public void setCausaCodigo(String causaCodigo) {
        this.causaCodigo = causaCodigo;
    }

    public Causa getCausa() {
        return this.causa;
    }

    public void setCausa(Causa causa) {
        this.causaCodigo = causa != null ? causa.getCodigo() : null;
        this.causa = causa;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Integer getReferenciaCodigo() {
        return this.referenciaCodigo;
    }

    public void setReferenciaCodigo(Integer referenciaCodigo) {
        this.referenciaCodigo = referenciaCodigo;
    }

    public Integer getPeritoCodigo() {
        return this.peritoCodigo;
    }

    public void setPeritoCodigo(Integer peritoCodigo) {
        this.peritoCodigo = peritoCodigo;
    }

    public Integer getMedicoCodigo() {
        return this.medicoCodigo;
    }

    public void setMedicoCodigo(Integer medicoCodigo) {
        this.medicoCodigo = medicoCodigo;
    }

    public String getCidPeritoCodigo() {
        return this.cidPeritoCodigo;
    }

    public void setCidPeritoCodigo(String cidPeritoCodigo) {
        this.cidPeritoCodigo = cidPeritoCodigo;
    }

    public String getCidMedicoCodigo() {
        return this.cidMedicoCodigo;
    }

    public void setCidMedicoCodigo(String cidMedicoCodigo) {
        this.cidMedicoCodigo = cidMedicoCodigo;
    }

    public Integer getCodigoMovimentoSefipEntradaCodigo() {
        return this.codigoMovimentoSefipEntradaCodigo;
    }

    public void setCodigoMovimentoSefipEntradaCodigo(Integer codigoMovimentoSefipEntradaCodigo) {
        this.codigoMovimentoSefipEntradaCodigo = codigoMovimentoSefipEntradaCodigo;
    }

    public Integer getCodigoMovimentoSefipSaidaCodigo() {
        return this.codigoMovimentoSefipSaidaCodigo;
    }

    public void setCodigoMovimentoSefipSaidaCodigo(Integer codigoMovimentoSefipSaidaCodigo) {
        this.codigoMovimentoSefipSaidaCodigo = codigoMovimentoSefipSaidaCodigo;
    }

    public final Date getDataLancamento() {
        return this.dataLancamento;
    }

    public final void setDataLancamento(Date dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    public HistoricoTrabalhadorCargo getHistoricoTrabalhadorCargo() {
        return this.historicoTrabalhadorCargo;
    }

    public void setHistoricoTrabalhadorCargo(HistoricoTrabalhadorCargo historicoTrabalhadorCargo) {
        this.historicoTrabalhadorCargo = historicoTrabalhadorCargo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MovimentoSefip other = (MovimentoSefip)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "MovimentoSefip [id=" + this.id + ", dataInicio=" + this.dataInicio + ", dataFim=" + this.dataFim + ", registro=" + this.registro + "]";
    }

    public MovimentoSefipDocumentoSaida getDocumentoSaida() {
        if (this.documentoSaida == null) {
            this.documentoSaida = new MovimentoSefipDocumentoSaida();
        }
        return this.documentoSaida;
    }

    public void setDocumentoSaida(MovimentoSefipDocumentoSaida documentoSaida) {
        this.documentoSaida = documentoSaida;
    }

    public MovimentoSefipDocumentoRetorno getDocumentoRetorno() {
        if (this.documentoRetorno == null) {
            this.documentoRetorno = new MovimentoSefipDocumentoRetorno();
        }
        return this.documentoRetorno;
    }

    public void setDocumentoRetorno(MovimentoSefipDocumentoRetorno documentoRetorno) {
        this.documentoRetorno = documentoRetorno;
    }

    public String getNumeroBeneficio() {
        return this.numeroBeneficio;
    }

    public void setNumeroBeneficio(String numeroBeneficio) {
        this.numeroBeneficio = numeroBeneficio;
    }

    public String getObs() {
        return this.obs;
    }

    public void setObs(String obs) {
        this.obs = obs;
    }

    public Date getDataPericia() {
        return this.dataPericia;
    }

    public void setDataPericia(Date dataPericia) {
        this.dataPericia = dataPericia;
    }

    public String getUserWsInc() {
        return this.userWsInc;
    }

    public void setUserWsInc(String userWsInc) {
        this.userWsInc = userWsInc;
    }

    public Date getDataWsInc() {
        return this.dataWsInc;
    }

    public void setDataWsInc(Date dataWsInc) {
        this.dataWsInc = dataWsInc;
    }

    public String getUserWsAlt() {
        return this.userWsAlt;
    }

    public void setUserWsAlt(String userWsAlt) {
        this.userWsAlt = userWsAlt;
    }

    public Date getDataWsAlt() {
        return this.dataWsAlt;
    }

    public void setDataWsAlt(Date dataWsAlt) {
        this.dataWsAlt = dataWsAlt;
    }

    public List<CidMovimentoSefip> getCids() {
        return this.cids;
    }

    public void setCids(List<CidMovimentoSefip> cids) {
        this.cids = cids;
    }

    public static class MovimentoSefipSql {
        public static final String FIND_BY_ENTIDADE_PERIODO_WS = "SELECT NEW " + FrequenciaVO.class.getCanonicalName() + "(" + "tr.trabalhadorPK.entidade, " + "tr.trabalhadorPK.registro, " + "m.dataInicio, " + "m.dataAlta, " + "'2', " + "m.causaCodigo, " + "m.id||'', " + "tr.matricula, " + "tr.contrato, " + "tr.documentosPessoais.cpf, " + "0.0, " + "'', " + "'', " + "sr.sefipReduzidoPK.codigo, " + "sr.nome) " + "FROM MovimentoSefip m JOIN m.trabalhador tr LEFT JOIN m.movtosefipTransf mt " + "LEFT JOIN m.causa c " + "LEFT JOIN m.codigoAfastamento sr " + "WHERE m.trabalhador.trabalhadorPK.entidade = :entidadeCodigo " + "AND m.situacao = '3' " + "AND (m.trabalhador.trabalhadorPK.registro = :registro or :registro = '000000') AND " + "((m.codigoMovimentoSefipSaida IS NOT NULL) OR (m.causaCodigo IN ('97','99'))) " + "and ((((m.situacao IN ('3')) AND ( ((m.dataAlta IS NULL) AND (m.dataInicio < :periodoFim)) OR " + "(m.dataInicio BETWEEN :periodoInicio AND :periodoFim) OR " + "((m.dataAlta > :periodoInicio) AND (m.dataInicio <= :periodoFim)) OR " + "((m.dataAlta > :periodoFim) AND (m.dataInicio <= :periodoFim)))))) " + " ORDER BY m.dataInicio, m.dataFim ";
        public static final String WHERE_FIND_PERIODO = "((m.codigoMovimentoSefipSaida IS NOT NULL) OR (m.causaCodigo IN ('97','99'))) and ((((m.situacao IN ('3')) AND ( ((m.dataFim IS NULL) AND (m.dataInicio < :periodoFim)) OR (m.dataInicio BETWEEN :periodoInicio AND :periodoFim) OR ((m.dataFim > :periodoInicio) AND (m.dataInicio <= :periodoFim)) OR ((m.dataFim > :periodoFim) AND (m.dataInicio <= :periodoFim))))) OR ((m.situacao IN ('2','4','5')) AND (m.dataInicio BETWEEN :periodoInicio AND :periodoFim))) ";
        public static final String FIND_BY_PERIODO_WS = "SELECT NEW " + FrequenciaVO.class.getCanonicalName() + "(" + "tr.trabalhadorPK.entidade, " + "tr.trabalhadorPK.registro, " + "m.dataInicio, " + "m.dataAlta, " + "'2', " + "m.causaCodigo, " + "m.id||'', " + "tr.matricula, " + "tr.contrato, " + "tr.documentosPessoais.cpf, " + "0.0, " + "'', " + "'', " + "sr.sefipReduzidoPK.codigo, " + "sr.nome) " + "FROM MovimentoSefip m JOIN m.trabalhador tr LEFT JOIN m.movtosefipTransf mt " + "LEFT JOIN m.causa c " + "LEFT JOIN m.codigoAfastamento sr " + "WHERE (m.trabalhador.trabalhadorPK.registro = :registro or :registro = '000000') " + "AND m.situacao = '3' " + "AND (m.trabalhador.trabalhadorPK.registro = :registro or :registro = '000000') AND " + "((m.codigoMovimentoSefipSaida IS NOT NULL) OR (m.causaCodigo IN ('97','99'))) " + "and ((((m.situacao IN ('3')) AND ( ((m.dataAlta IS NULL) AND (m.dataInicio < :periodoFim)) OR " + "(m.dataInicio BETWEEN :periodoInicio AND :periodoFim) OR " + "((m.dataAlta > :periodoInicio) AND (m.dataInicio <= :periodoFim)) OR " + "((m.dataAlta > :periodoFim) AND (m.dataInicio <= :periodoFim)))))) " + " ORDER BY m.dataInicio, m.dataFim ";
        public static final String FIND_BY_ENTIDADE_MATRICULA_CONTRATO_PERIODO_WS = "SELECT NEW " + FrequenciaVO.class.getCanonicalName() + "(" + "tr.trabalhadorPK.entidade, " + "tr.trabalhadorPK.registro, " + "m.dataInicio, " + "m.dataAlta, " + "'2', " + "m.causaCodigo, " + "m.id||'', " + "tr.matricula, " + "tr.contrato, " + "tr.documentosPessoais.cpf, " + "0.0, " + "'', " + "'', " + "sr.sefipReduzidoPK.codigo, " + "sr.nome) " + "FROM MovimentoSefip m JOIN m.trabalhador tr LEFT JOIN m.movtosefipTransf mt " + "LEFT JOIN m.causa c " + "LEFT JOIN m.codigoAfastamento sr " + "WHERE m.trabalhador.trabalhadorPK.entidade = :entidadeCodigo " + "AND m.trabalhador.matricula = :matricula " + "AND m.trabalhador.contrato = :contrato  " + "AND m.situacao = '3' " + "AND ((m.codigoMovimentoSefipSaida IS NOT NULL) OR (m.causaCodigo IN ('97','99'))) " + "and ((((m.situacao IN ('3')) AND ( ((m.dataAlta IS NULL) AND (m.dataInicio < :periodoFim)) OR " + "(m.dataInicio BETWEEN :periodoInicio AND :periodoFim) OR " + "((m.dataAlta > :periodoInicio) AND (m.dataInicio <= :periodoFim)) OR " + "((m.dataAlta > :periodoFim) AND (m.dataInicio <= :periodoFim)))))) " + " ORDER BY m.dataInicio, m.dataFim ";
        public static final String ORDER_BY_PERIODO = " ORDER BY m.dataInicio, m.dataFim ";
    }

    public static class Builder {
        private Trabalhador trabalhador;
        private CodigoAfastamento sefipReduzido;
        private Causa causa;
        private CodigoMovimentoSefip sefipEntrada;
        private CodigoMovimentoSefip sefipSaida;
        private Date dataSaida;
        private TrabalhadorSituacao situacao;
        private MovimentoSefipDocumentoSaida documentacaoSaida;
        private Medico medico;
        private Cid cidMedico;
        private Medico perito;
        private Cid cidPerito;
        private Date dataPericia;
        private MovimentoSefipDocumentoRetorno documentacaoRetorno;
        private String numeroBenificioRetorno;
        private String observacoes;
        private Date dataFim;
        private Date dataAlta;
        private String usuarioDeInclusaoNoWebService;
        private Date dataInclusaoNoWebService;
        private String usuarioDeAlteracaoNoWebService;
        private Date dataAlteracaoNoWebService;

        public Builder comUsuarioDeInclusaoNoWebService(String usuarioDeInclusaoNoWebService) {
            this.usuarioDeInclusaoNoWebService = usuarioDeInclusaoNoWebService;
            return this;
        }

        public Builder comDataInclusaoNoWebService(Date dataInclusaoNoWebService) {
            this.dataInclusaoNoWebService = dataInclusaoNoWebService;
            return this;
        }

        public Builder comUsuarioDeAlteracaoNoWebService(String usuarioDeAlteracaoNoWebService) {
            this.usuarioDeAlteracaoNoWebService = usuarioDeAlteracaoNoWebService;
            return this;
        }

        public Builder comDataAlteracaoNoWebService(Date dataAlteracaoNoWebService) {
            this.dataAlteracaoNoWebService = dataAlteracaoNoWebService;
            return this;
        }

        public Builder(Trabalhador trabalhador, CodigoAfastamento sefipReduzido, Causa causa, CodigoMovimentoSefip sefipEntrada, CodigoMovimentoSefip sefipSaida, Date dataSaida, TrabalhadorSituacao situacao) {
            this.trabalhador = trabalhador;
            this.sefipReduzido = sefipReduzido;
            this.causa = causa;
            this.sefipEntrada = sefipEntrada;
            this.sefipSaida = sefipSaida;
            this.dataSaida = dataSaida;
            this.situacao = situacao;
        }

        public Builder comDocumentacaoSaida(MovimentoSefipDocumentoSaida documentacaoSaida) {
            this.documentacaoSaida = documentacaoSaida;
            return this;
        }

        public Builder comMedico(Medico medico) {
            this.medico = medico;
            return this;
        }

        public Builder comCidMedico(Cid cidMedico) {
            this.cidMedico = cidMedico;
            return this;
        }

        public Builder comPerito(Medico perito) {
            this.perito = perito;
            return this;
        }

        public Builder comCidPerito(Cid cidPerito) {
            this.cidPerito = cidPerito;
            return this;
        }

        public Builder comDataPericia(Date dataPericia) {
            this.dataPericia = dataPericia;
            return this;
        }

        public Builder comDocumentacaoRetorno(MovimentoSefipDocumentoRetorno documentacaoRetorno) {
            this.documentacaoRetorno = documentacaoRetorno;
            return this;
        }

        public Builder comNumeroBeneficiarioRetorno(String numeroBenificioRetorno) {
            this.numeroBenificioRetorno = numeroBenificioRetorno;
            return this;
        }

        public Builder comObservacoes(String observacoes) {
            this.observacoes = observacoes;
            return this;
        }

        public Builder comDataFim(Date dataFim) {
            this.dataFim = dataFim;
            return this;
        }

        public Builder comDataAlta(Date dataAlta) {
            this.dataAlta = dataAlta;
            return this;
        }

        public MovimentoSefip build() {
            return new MovimentoSefip(this);
        }
    }
}

