/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.DocumentoMovimentoProcedimentoAdministrativo;
import br.com.fiorilli.sip.persistence.entity.DocumentoProcedimentoAdministrativo;
import br.com.fiorilli.sip.persistence.entity.ProcedimentoAdministrativo;
import br.com.fiorilli.sip.persistence.entity.TipoMovimentoProcedimentoAdministrativo;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang3.time.DateUtils;

@Entity
@Table(name="MOV_PROC_ADM")
@Audited
public class MovimentoProcedimentoAdministrativo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_PROC_ADM_ID = "SELECT DISTINCT m FROM MovimentoProcedimentoAdministrativo m JOIN FETCH m.tipoMovimento LEFT JOIN FETCH m.docMovProcAdms WHERE m.procAdmId = :procAdmId ORDER BY m.dataHora DESC";
    @Id
    @Column(unique=true, nullable=false)
    private int id;
    @Column(name="ID_PROC_ADM", nullable=false)
    private int procAdmId;
    @Column(name="DATA_HORA", nullable=false)
    private Date dataHora;
    @Column(length=512)
    private String texto;
    @Column(name="TIPO_MOV_PROC_ADM", nullable=false)
    private int tipoMovimentoId;
    @OneToMany(mappedBy="movProcAdm", cascade={CascadeType.REMOVE})
    private List<DocumentoMovimentoProcedimentoAdministrativo> docMovProcAdms;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PROC_ADM", insertable=false, updatable=false)
    private ProcedimentoAdministrativo procedimentoAdministrativo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TIPO_MOV_PROC_ADM", insertable=false, updatable=false)
    private TipoMovimentoProcedimentoAdministrativo tipoMovimento;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getDataHora() {
        return this.dataHora;
    }

    public void setDataHora(Date dataHora) {
        this.dataHora = dataHora;
    }

    public String getTexto() {
        return this.texto;
    }

    public void setTexto(String texto) {
        this.texto = texto;
    }

    public int getTipoMovimentoId() {
        return this.tipoMovimentoId;
    }

    public void setTipoMovimentoId(int tipoMovimentacao) {
        this.tipoMovimentoId = tipoMovimentacao;
    }

    public List<DocumentoMovimentoProcedimentoAdministrativo> getDocMovProcAdms() {
        return this.docMovProcAdms;
    }

    public void setDocMovProcAdms(List<DocumentoMovimentoProcedimentoAdministrativo> docMovProcAdms) {
        this.docMovProcAdms = docMovProcAdms;
    }

    public DocumentoProcedimentoAdministrativo addDocMovProcAdm(DocumentoMovimentoProcedimentoAdministrativo docMovProcAdm) {
        this.getDocMovProcAdms().add(docMovProcAdm);
        docMovProcAdm.setMovProcAdm(this);
        return docMovProcAdm;
    }

    public DocumentoProcedimentoAdministrativo removeDocMovProcAdm(DocumentoMovimentoProcedimentoAdministrativo docMovProcAdm) {
        this.getDocMovProcAdms().remove(docMovProcAdm);
        docMovProcAdm.setMovProcAdm(null);
        return docMovProcAdm;
    }

    public ProcedimentoAdministrativo getProcedimentoAdministrativo() {
        return this.procedimentoAdministrativo;
    }

    public void setProcedimentoAdministrativo(ProcedimentoAdministrativo procAdm) {
        this.procedimentoAdministrativo = procAdm;
    }

    public int getProcAdmId() {
        return this.procAdmId;
    }

    public void setProcAdmId(int procAdmId) {
        this.procAdmId = procAdmId;
    }

    public TipoMovimentoProcedimentoAdministrativo getTipoMovimento() {
        return this.tipoMovimento;
    }

    public void setTipoMovimento(TipoMovimentoProcedimentoAdministrativo tipoMovimento) {
        this.tipoMovimento = tipoMovimento;
    }

    public void setHora(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.dataHora = DateUtils.setHours((Date)this.dataHora, (int)cal.get(11));
        this.dataHora = DateUtils.setMinutes((Date)this.dataHora, (int)cal.get(12));
    }

    public Date getHora() {
        return this.dataHora;
    }
}

