/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.commons.util.SIPNumberUtil;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Autonomo;
import br.com.fiorilli.sip.persistence.entity.TomadorObra;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="MOVTOAUTONOMOSEFIP")
@Audited
public class MovimentoAutonomo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_MOVTOAUTONOMO";
    public static final String GET_FETCHED = "SELECT m FROM MovimentoAutonomo m LEFT JOIN FETCH m.unidade LEFT JOIN FETCH m.tomadorObra LEFT JOIN FETCH m.autonomo a LEFT JOIN FETCH a.categoria c WHERE m.codigo = :codigo";
    @FilterConfig(label="C\u00f3digo", order=1)
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private int codigo;
    @FilterConfig(label="Ano", order=3)
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=4)
    @Column(name="ANO")
    private String ano;
    @FilterConfig(label="M\u00eas", order=2)
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=2)
    @Column(name="MES")
    private String mes;
    @FilterConfig(label="Data do Servi\u00e7o", inputType=FilterInputType.CALENDAR)
    @Basic(optional=false)
    @NotNull
    @Column(name="DTSERVICO")
    @Temporal(value=TemporalType.DATE)
    private Date dataServico;
    @Column(name="REMSEM13")
    private BigDecimal remSem13;
    @Column(name="REM13")
    private BigDecimal rem13;
    @FilterConfig(label="Sal\u00e1rio Base", order=6)
    @Column(name="SALBASE")
    private BigDecimal salarioBase;
    @FilterConfig(label="Valor Segurado")
    @Column(name="VLRSEGURADO")
    private BigDecimal valorSegurado;
    @FilterConfig(label="13\u00ba Sal\u00e1rio")
    @Column(name="BASEPREV13NOMES")
    private BigDecimal basePrevidencia13NoMes;
    @FilterConfig(label="Referente a GPS da compet\u00eancia 13")
    @Column(name="BASEPREV13MES13")
    private BigDecimal basePrev13Mes13;
    @Column(name="CONTRSALBASE")
    private BigDecimal contrSalarioBase;
    @FilterConfig(label="Base")
    @Column(name="BASEPREVSOCIAL")
    private BigDecimal basePrevSocial;
    @FilterConfig(label="Valor Empresa")
    @Column(name="VALOR_EMPRESA")
    private BigDecimal valorEntidade;
    @FilterConfig(label="Valor Contribuinte")
    @Column(name="VALOR_CONTRIBUINTE")
    private BigDecimal valorContribuinte;
    @Column(name="BASEIRRF")
    private BigDecimal baseIrrf;
    @FilterConfig(label="Valor Irrf")
    @Column(name="VALORIRRF")
    private BigDecimal valorIrrf;
    @Column(name="VALOR_EMPRESA_OUTRA_ENTID")
    private BigDecimal valorEntidadeOutraEntidade;
    @FilterConfig(label="Descri\u00e7\u00e3o")
    @Size(max=150)
    @Column(name="DESCRICAO")
    private String descricao;
    @FilterConfig(label="Base ISS")
    @Column(name="BASEISS")
    private BigDecimal baseIss;
    @FilterConfig(label="Al\u00edquota ISS")
    @Column(name="ALIQUOTA_SERVICO")
    private BigDecimal aliquotaServico;
    @Column(name="VALORISS")
    private BigDecimal valorIss;
    @FilterConfig(label="L\u00edquido")
    @Column(name="LIQUIDO")
    private BigDecimal liquido;
    @Column(name="VALORPENSAO")
    private BigDecimal valorPensao;
    @Column(name="VALOROUTRAS")
    private BigDecimal valorOutras;
    @Column(name="TAXA_IRRF")
    private BigDecimal taxaIrrf;
    @Column(name="DEDUCAO_RPA_ANTERIOR")
    private BigDecimal deducaoRpaAnterior;
    @Column(name="IRRF_RPA_ANTERIOR")
    private BigDecimal irrfRpaAnterior;
    @Column(name="IRRF_SEM_DEDUCAO")
    private BigDecimal irrfSemDeducao;
    @Column(name="DEDUCAO_IRRF_TABELA")
    private BigDecimal deducaoIrrfTabela;
    @Column(name="INSS_RPA_ANTERIOR")
    private BigDecimal inssRpaAnterior;
    @Column(name="DEDUDEPTEIRRF")
    private BigDecimal deducaoDependenteIrrf;
    @Column(name="BASEINSSPERCENTUAL")
    private BigDecimal baseInssPercentual;
    @Column(name="BASEIRRFPERCENTUAL")
    private BigDecimal baseIrrfPercentual;
    @FilterConfig(label="Valor do Servi\u00e7o")
    @Column(name="VALOR_SERVICO")
    private BigDecimal valorServico;
    @Column(name="DEPDESPESA")
    private Integer unidadeCodigo;
    @FilterConfig(label="Unidade Or\u00e7ament\u00e1ria", inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT u FROM Unidade u WHERE UPPER(u.nome) LIKE UPPER('%'||:param||'%') AND u.responsavelEntidade = :entidadeCodigo AND YEAR(CURRENT_DATE) = u.ano")
    @JoinColumn(name="DEPDESPESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Unidade unidade;
    @JoinColumns(value={@JoinColumn(name="EMPRESATOMADOROBRA", referencedColumnName="EMPRESA"), @JoinColumn(name="CODIGOTOMADOROBRA", referencedColumnName="CODIGO")})
    @ManyToOne(fetch=FetchType.LAZY)
    private TomadorObra tomadorObra;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="AUTONOMO")
    private String autonomoCodigo;
    @Column(name="EMPRESA")
    private String entidade;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @FilterConfig(label="Nome", order=4, inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT a FROM Autonomo a WHERE a.nome LIKE '%'||:param||'%' ")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="AUTONOMO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Autonomo autonomo;

    public MovimentoAutonomo() {
    }

    public MovimentoAutonomo(Integer codigo) {
        this.codigo = codigo;
    }

    public MovimentoAutonomo(Integer codigo, String ano, String mes, Date dtservico) {
        this.codigo = codigo;
        this.ano = ano;
        this.mes = mes;
        this.dataServico = dtservico;
    }

    public int getCodigo() {
        return this.codigo;
    }

    public void setCodigo(int codigo) {
        this.codigo = codigo;
    }

    public String getAno() {
        return this.ano;
    }

    public void setAno(String ano) {
        this.ano = ano;
    }

    public String getMes() {
        return this.mes;
    }

    public void setMes(String mes) {
        this.mes = mes;
    }

    public Date getDataServico() {
        return this.dataServico;
    }

    public void setDataServico(Date dtservico) {
        this.dataServico = dtservico;
    }

    public BigDecimal getRemSem13() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.remSem13);
    }

    public void setRemSem13(BigDecimal remsem13) {
        this.remSem13 = remsem13;
    }

    public BigDecimal getRem13() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.rem13);
    }

    public void setRem13(BigDecimal rem13) {
        this.rem13 = rem13;
    }

    public BigDecimal getSalarioBase() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.salarioBase);
    }

    public void setSalarioBase(BigDecimal salbase) {
        this.salarioBase = salbase;
    }

    public BigDecimal getValorSegurado() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.valorSegurado);
    }

    public void setValorSegurado(BigDecimal vlrsegurado) {
        this.valorSegurado = vlrsegurado;
    }

    public BigDecimal getBasePrevidencia13NoMes() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.basePrevidencia13NoMes);
    }

    public void setBasePrevidencia13NoMes(BigDecimal baseprev13nomes) {
        this.basePrevidencia13NoMes = baseprev13nomes;
    }

    public BigDecimal getBasePrev13Mes13() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.basePrev13Mes13);
    }

    public void setBasePrev13Mes13(BigDecimal baseprev13mes13) {
        this.basePrev13Mes13 = baseprev13mes13;
    }

    public BigDecimal getContrSalarioBase() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.contrSalarioBase);
    }

    public void setContrSalarioBase(BigDecimal contrsalbase) {
        this.contrSalarioBase = contrsalbase;
    }

    public BigDecimal getBasePrevSocial() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.basePrevSocial);
    }

    public void setBasePrevSocial(BigDecimal baseprevsocial) {
        this.basePrevSocial = baseprevsocial;
    }

    public BigDecimal getValorEntidade() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.valorEntidade);
    }

    public void setValorEntidade(BigDecimal valorEntidade) {
        this.valorEntidade = valorEntidade;
    }

    public BigDecimal getValorContribuinte() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.valorContribuinte);
    }

    public void setValorContribuinte(BigDecimal valorContribuinte) {
        this.valorContribuinte = valorContribuinte;
    }

    public BigDecimal getBaseIrrf() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.baseIrrf);
    }

    public void setBaseIrrf(BigDecimal baseirrf) {
        this.baseIrrf = baseirrf;
    }

    public BigDecimal getValorIrrf() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.valorIrrf);
    }

    public void setValorIrrf(BigDecimal valorirrf) {
        this.valorIrrf = valorirrf;
    }

    public BigDecimal getValorEntidadeOutraEntidade() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.valorEntidadeOutraEntidade);
    }

    public void setValorEntidadeOutraEntidade(BigDecimal valorEntidadeOutraEntid) {
        this.valorEntidadeOutraEntidade = valorEntidadeOutraEntid;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public BigDecimal getBaseIss() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.baseIss);
    }

    public void setBaseIss(BigDecimal baseiss) {
        this.baseIss = baseiss;
    }

    public BigDecimal getAliquotaServico() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.aliquotaServico);
    }

    public void setAliquotaServico(BigDecimal aliquotaServico) {
        this.aliquotaServico = aliquotaServico;
    }

    public BigDecimal getValorIss() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.valorIss);
    }

    public void setValorIss(BigDecimal valoriss) {
        this.valorIss = valoriss;
    }

    public BigDecimal getLiquido() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.liquido);
    }

    public void setLiquido(BigDecimal liquido) {
        this.liquido = liquido;
    }

    public BigDecimal getValorPensao() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.valorPensao);
    }

    public void setValorPensao(BigDecimal valorpensao) {
        this.valorPensao = valorpensao;
    }

    public BigDecimal getValorOutras() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.valorOutras);
    }

    public void setValorOutras(BigDecimal valoroutras) {
        this.valorOutras = valoroutras;
    }

    public BigDecimal getTaxaIrrf() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.taxaIrrf);
    }

    public void setTaxaIrrf(BigDecimal taxaIrrf) {
        this.taxaIrrf = taxaIrrf;
    }

    public BigDecimal getDeducaoRpaAnterior() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.deducaoRpaAnterior);
    }

    public void setDeducaoRpaAnterior(BigDecimal deducaoRpaAnterior) {
        this.deducaoRpaAnterior = deducaoRpaAnterior;
    }

    public BigDecimal getIrrfRpaAnterior() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.irrfRpaAnterior);
    }

    public void setIrrfRpaAnterior(BigDecimal irrfRpaAnterior) {
        this.irrfRpaAnterior = irrfRpaAnterior;
    }

    public BigDecimal getIrrfSemDeducao() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.irrfSemDeducao);
    }

    public void setIrrfSemDeducao(BigDecimal irrfSemDeducao) {
        this.irrfSemDeducao = irrfSemDeducao;
    }

    public BigDecimal getDeducaoIrrfTabela() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.deducaoIrrfTabela);
    }

    public void setDeducaoIrrfTabela(BigDecimal deducaoIrrfTabela) {
        this.deducaoIrrfTabela = deducaoIrrfTabela;
    }

    public BigDecimal getInssRpaAnterior() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.inssRpaAnterior);
    }

    public void setInssRpaAnterior(BigDecimal inssRpaAnterior) {
        this.inssRpaAnterior = inssRpaAnterior;
    }

    public BigDecimal getDeducaoDependenteIrrf() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.deducaoDependenteIrrf);
    }

    public void setDeducaoDependenteIrrf(BigDecimal dedudepteirrf) {
        this.deducaoDependenteIrrf = dedudepteirrf;
    }

    public BigDecimal getBaseInssPercentual() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.baseInssPercentual);
    }

    public void setBaseInssPercentual(BigDecimal baseInssPercentual) {
        this.baseInssPercentual = baseInssPercentual;
    }

    public BigDecimal getBaseIrrfPercentual() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.baseIrrfPercentual);
    }

    public void setBaseIrrfPercentual(BigDecimal baseirrfpercentual) {
        this.baseIrrfPercentual = baseirrfpercentual;
    }

    public BigDecimal getValorServico() {
        return SIPNumberUtil.bigDecimalDefault((BigDecimal)this.valorServico);
    }

    public void setValorServico(BigDecimal valorServico) {
        this.valorServico = valorServico;
    }

    public Unidade getUnidade() {
        return this.unidade;
    }

    public void setUnidade(Unidade unidade) {
        this.unidadeCodigo = unidade == null ? null : unidade.getCodigo();
        this.unidade = unidade;
    }

    public TomadorObra getTomadorObra() {
        return this.tomadorObra;
    }

    public void setTomadorObra(TomadorObra tomadorobra) {
        this.tomadorObra = tomadorobra;
    }

    public Autonomo getAutonomo() {
        return this.autonomo;
    }

    public void setAutonomo(Autonomo autonomo) {
        if (autonomo != null) {
            this.autonomoCodigo = autonomo.getAutonomoPK().getCodigo();
            this.entidade = autonomo.getAutonomoPK().getEntidade();
        } else {
            this.autonomoCodigo = null;
            this.entidade = null;
        }
        this.autonomo = autonomo;
    }

    public String toString() {
        return "MovimentoAutonomo [codigo=" + this.codigo + "\n remSem13=" + this.remSem13 + "\n rem13=" + this.rem13 + "\n salarioBase=" + this.salarioBase + "\n valorSegurado=" + this.valorSegurado + "\n basePrevidencia13NoMes=" + this.basePrevidencia13NoMes + "\n basePrev13Mes13=" + this.basePrev13Mes13 + "\n contrSalarioBase=" + this.contrSalarioBase + "\n basePrevSocial=" + this.basePrevSocial + "\n valorEntidade=" + this.valorEntidade + "\n valorContribuinte=" + this.valorContribuinte + "\n baseIrrf=" + this.baseIrrf + "\n valorIrrf=" + this.valorIrrf + "\n valorEntidadeOutraEntidade=" + this.valorEntidadeOutraEntidade + "\n descricao=" + this.descricao + "\n baseIss=" + this.baseIss + "\n aliquotaServico=" + this.aliquotaServico + "\n valorIss=" + this.valorIss + "\n liquido=" + this.liquido + "\n valorPensao=" + this.valorPensao + "\n valorOutras=" + this.valorOutras + "\n taxaIrrf=" + this.taxaIrrf + "\n deducaoRpaAnterior=" + this.deducaoRpaAnterior + "\n irrfRpaAnterior=" + this.irrfRpaAnterior + "\n irrfSemDeducao=" + this.irrfSemDeducao + "\n deducaoIrrfTabela=" + this.deducaoIrrfTabela + "\n inssRpaAnterior=" + this.inssRpaAnterior + "\n deducaoDependenteIrrf=" + this.deducaoDependenteIrrf + "\n baseInssPercentual=" + this.baseInssPercentual + "\n baseIrrfPercentual=" + this.baseIrrfPercentual + "\n valorServico=" + this.valorServico + "\n autonomoCodigo=" + this.autonomoCodigo + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.codigo;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MovimentoAutonomo other = (MovimentoAutonomo)obj;
        return this.codigo == other.codigo;
    }

    public String getAutonomoCodigo() {
        return this.autonomoCodigo;
    }

    public void setAutonomoCodigo(String autonomoCodigo) {
        this.autonomoCodigo = autonomoCodigo;
    }

    public Integer getUnidadeCodigo() {
        return this.unidadeCodigo;
    }

    public void setUnidadeCodigo(Integer unidadeCodigo) {
        this.unidadeCodigo = unidadeCodigo;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }
}

