/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;

public enum MesNomeEnum {
    JANEIRO("01", "Janeiro", "JAN"),
    FEVEREIRO("02", "Fevereiro", "FEV"),
    MARCO("03", "Mar\u00e7o", "MAR"),
    ABRIL("04", "Abril", "ABR"),
    MAIO("05", "Maio", "MAI"),
    JUNHO("06", "Junho", "JUN"),
    JULHO("07", "Julho", "JUL"),
    AGOSTO("08", "Agosto", "AGO"),
    SETEMBRO("09", "Setembro", "SET"),
    OUTUBRO("10", "Outubro", "OUT"),
    NOVEMBRO("11", "Novembro", "NOV"),
    DEZEMBRO("12", "Dezembro", "DEZ");

    private final String codigo;
    private final String nome;
    private final String nomeAbreviado;

    private MesNomeEnum(String codigo, String nome, String nomeAbreviado) {
        this.codigo = codigo;
        this.nome = nome;
        this.nomeAbreviado = nomeAbreviado;
    }

    public static final MesNomeEnum of(String mes) {
        if (StringUtils.isNotBlank((CharSequence)mes) && mes.trim().length() == 1) {
            mes = "0" + mes;
        }
        for (MesNomeEnum m : MesNomeEnum.values()) {
            if (!m.getCodigo().equals(mes)) continue;
            return m;
        }
        throw new ContextedRuntimeException((Throwable)new IllegalArgumentException("O par\u00e2metro n\u00e3o \u00e9 um m\u00eas v\u00e1lido. Informe n\u00fameros de 1 a 12")).addContextValue("M\u00eas Informado", (Object)mes);
    }

    public static String codigoByNome(String nome) {
        for (MesNomeEnum mesNomeEnum : MesNomeEnum.values()) {
            if (!mesNomeEnum.nome.equals(nome)) continue;
            return mesNomeEnum.codigo;
        }
        return "";
    }

    public MesNomeEnum next() {
        int ordinal = this.ordinal();
        ordinal = ordinal < 11 ? ++ordinal : 0;
        return MesNomeEnum.values()[ordinal];
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public String getNomeAbreviado() {
        return this.nomeAbreviado;
    }

    public static MesNomeEnum of(int monthOfYear) {
        return MesNomeEnum.of(Integer.valueOf(monthOfYear).toString());
    }

    public int getCodigoInt() {
        return this.ordinal() + 1;
    }

    public MesNomeEnum prior() {
        int i = this.ordinal() - 1;
        if (i < JANEIRO.ordinal()) {
            return DEZEMBRO;
        }
        return MesNomeEnum.values()[i];
    }
}

