/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.entity.MesNomeEnum;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.math.NumberUtils;

public class MesAno {
    private int mes;
    private int ano;

    public MesAno() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        this.mes = cal.get(2) + NumberUtils.INTEGER_ONE;
        this.ano = cal.get(1);
    }

    public MesAno(int mes, int ano) {
        this.mes = mes;
        this.ano = ano;
    }

    public MesAno(String mes, String ano) {
        try {
            this.mes = Integer.parseInt(mes);
            this.ano = Integer.parseInt(ano);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("O parametros m\u00eas e/ou ano n\u00e3o s\u00e3o v\u00e1lidos");
        }
    }

    public MesAno(Date data) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        this.mes = cal.get(2) + NumberUtils.INTEGER_ONE;
        this.ano = cal.get(1);
    }

    public boolean isBefore(MesAno b) {
        if (this.ano < b.getAno()) {
            return true;
        }
        if (this.ano > b.getAno()) {
            return false;
        }
        return this.mes <= b.getMes();
    }

    public boolean isAfter(MesAno b) {
        return !this.isBefore(b);
    }

    public void addMes(int quantidade) {
        if (quantidade >= 0) {
            if (this.mes + quantidade > 12) {
                int _anos = Double.valueOf(quantidade / 12).intValue();
                this.ano += _anos;
                this.mes += quantidade - _anos;
            } else {
                this.mes += quantidade;
            }
        } else {
            throw new IllegalArgumentException("A quantidade deve ser um valor positivo.");
        }
    }

    public void subMes(int quantidade) {
        if (quantidade <= 0) {
            this.mes = quantidade;
            if (this.mes < 1) {
                int _anos = Double.valueOf(quantidade / 12).intValue();
                this.ano += _anos;
                this.mes += quantidade - _anos;
            } else {
                this.mes += quantidade;
            }
        } else {
            throw new IllegalArgumentException("A quantidade deve ser um valor negativo.");
        }
    }

    public void addAno(int quantidade) {
        if (quantidade >= 0) {
            this.ano += quantidade;
        } else {
            throw new IllegalArgumentException("A quantidade deve ser um valor positivo.");
        }
    }

    public void subAno(int quantidade) {
        if (quantidade <= 0) {
            this.ano -= Math.abs(quantidade);
        } else {
            throw new IllegalArgumentException("A quantidade deve ser um valor negativo.");
        }
    }

    public int getMes() {
        return this.mes;
    }

    public int getAno() {
        return this.ano;
    }

    public String getMesStr() {
        return this.mes < 10 ? "0" + this.mes : Integer.toString(this.mes);
    }

    public String getAnoStr() {
        return Integer.toString(this.ano);
    }

    public String toString() {
        return this.getMesStr() + "/" + this.getAnoStr();
    }

    public String getMesNomeExtenso() {
        return MesNomeEnum.of(this.getMesStr()).getNome();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.ano;
        result = 31 * result + this.mes;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MesAno other = (MesAno)obj;
        if (this.ano != other.ano) {
            return false;
        }
        return this.mes == other.mes;
    }
}

