/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CestaBasica;
import br.com.fiorilli.sip.persistence.entity.MesPK;
import br.com.fiorilli.sip.persistence.entity.Meses;
import br.com.fiorilli.sip.persistence.entity.Referencia;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Size;

@Entity
@Table(name="MES")
@Audited
public class Mes
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected MesPK mesPK;
    @Size(max=7)
    @Column(name="CNAE_PREPONDERANTE")
    private String cnaePreponderante;
    @Column(name="TAXAINSSACIDENTE")
    private Double taxaInssAcidente;
    @JoinColumn(name="MES", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Meses meses;
    @OneToMany(mappedBy="mes")
    private List<CestaBasica> cestaBasicaList;
    @OneToMany(mappedBy="mes")
    private List<Referencia> referenciaList;

    public Mes() {
    }

    public Mes nextMes() {
        return null;
    }

    public Mes previousMes() {
        return null;
    }

    public Mes(MesPK mesPK) {
        this.mesPK = mesPK;
    }

    public Mes(String entidade, String ano, String mes) {
        this.mesPK = new MesPK(entidade, ano, mes);
    }

    public MesPK getMesPK() {
        return this.mesPK;
    }

    public void setMesPK(MesPK mesPK) {
        this.mesPK = mesPK;
    }

    public String getCnaePreponderante() {
        return this.cnaePreponderante;
    }

    public void setCnaePreponderante(String cnaePreponderante) {
        this.cnaePreponderante = cnaePreponderante;
    }

    public Double getTaxaInssAcidente() {
        return this.taxaInssAcidente;
    }

    public void setTaxaInssAcidente(Double taxainssacidente) {
        this.taxaInssAcidente = taxainssacidente;
    }

    public Meses getMeses() {
        return this.meses;
    }

    public void setMeses(Meses meses) {
        this.meses = meses;
    }

    public List<CestaBasica> getCestaBasicaList() {
        return this.cestaBasicaList;
    }

    public void setCestaBasicaList(List<CestaBasica> cestaBasicaList) {
        this.cestaBasicaList = cestaBasicaList;
    }

    public List<Referencia> getReferenciaList() {
        return this.referenciaList;
    }

    public void setReferenciaList(List<Referencia> referenciaList) {
        this.referenciaList = referenciaList;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.mesPK != null ? this.mesPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Mes)) {
            return false;
        }
        Mes other = (Mes)object;
        return (this.mesPK != null || other.mesPK == null) && (this.mesPK == null || this.mesPK.equals(other.mesPK));
    }

    public String toString() {
        return "entity.Mes[ mesPK=" + this.mesPK + " ]";
    }
}

