/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.MovimentoSefip;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@FilterConfigType(rootQueryType=Medico.class, autoFilter=true)
@Entity
@Table(name="MEDICOS")
@Audited
public class Medico
implements Serializable,
GenericEntity {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_MEDICOS";
    public static final String FIND_PERITOS_BY_NOME = "SELECT m FROM Medico m WHERE m.perito = 'S' AND m.nome LIKE '%'||:nome||'%' ORDER BY m.nome";
    public static final String FIND_BY_NOME = "SELECT m FROM Medico m WHERE m.nome LIKE '%' || :param || '%' ORDER BY m.nome";
    @FilterConfig(label="C\u00f3digo", inputType=FilterInputType.NUMBER)
    @Id
    @Basic(optional=false)
    @Column(name="CODIGO")
    private Integer codigo;
    @FilterConfig(label="Nome", condition=FilterCondition.COMECE)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @FilterConfig(label="CRM", condition=FilterCondition.COMECE)
    @Column(name="CRM")
    @Size(max=10)
    private String crm;
    @FilterConfig(label="Perito", inputType=FilterInputType.SELECT_CHECKBOX_MENU)
    @Column(name="PERITO")
    @Type(type="BooleanTypeSip")
    private Boolean perito;
    @OneToMany(mappedBy="perito", fetch=FetchType.LAZY)
    private List<MovimentoSefip> movimentoSefipPeritoList;
    @OneToMany(mappedBy="medico", fetch=FetchType.LAZY)
    private List<MovimentoSefip> movimentoSefipMedicoList;

    public Medico() {
    }

    public Medico(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCrm() {
        return this.crm;
    }

    public void setCrm(String crm) {
        this.crm = crm;
    }

    public List<MovimentoSefip> getMovimentoSefipPeritoList() {
        return this.movimentoSefipPeritoList;
    }

    public void setMovimentoSefipPeritoList(List<MovimentoSefip> movtosefipList) {
        this.movimentoSefipPeritoList = movtosefipList;
    }

    public List<MovimentoSefip> getMovimentoSefipMedicoList() {
        return this.movimentoSefipMedicoList;
    }

    public void setMovimentoSefipMedicoList(List<MovimentoSefip> movtosefipList1) {
        this.movimentoSefipMedicoList = movtosefipList1;
    }

    public Boolean getPerito() {
        return this.perito;
    }

    public void setPerito(Boolean perito) {
        this.perito = perito;
    }

    public String toString() {
        return "Medico [codigo=" + this.codigo + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.codigo;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Medico other = (Medico)obj;
        return this.codigo == other.codigo;
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.codigo);
    }

    public static class MedicoSql {
        public static final String DOES_EXIST_BY_CODIGO_AND_ISPERITO = " SELECT count(m.codigo)  FROM Medico m  WHERE m.codigo = :codigo  AND m.perito = :isPerito ";
        public static final String FIND_PERITO_BY = " SELECT m  FROM Medico m  WHERE m.codigo = :codigo  AND m.perito = 'S' ";
    }
}

