/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.VeiculoPublicacao;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Embeddable
public class LocalTrabalhoDocumentoExtincao
implements Documento {
    private static final long serialVersionUID = 1L;
    @Column(name="TIPOLEGAL_EXTINCAO")
    private Integer tipoLegalCodigo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TIPOLEGAL_EXTINCAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private TipoDocumentoLegal tipoLegal;
    @Column(name="NUMDOC_EXTINCAO")
    private String numeroDocumento;
    @Column(name="DTEXTINCAO")
    private Date data;
    @Column(name="MOTIVO_EXTINCAO")
    private String motivo;
    @Column(name="VEICULO_PUBLICACAO_EXTINCAO")
    private Integer veiculoPublicacaoCodigo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="VEICULO_PUBLICACAO_EXTINCAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private VeiculoPublicacao veiculoPublicacao;

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal value) {
        this.tipoLegalCodigo = value != null ? value.getCodigo() : null;
        this.tipoLegal = value;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String value) {
        this.numeroDocumento = value;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.data;
    }

    @Override
    public void setData(Date value) {
        this.data = value;
    }

    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public Integer getVeiculoPublicacaoCodigo() {
        return this.veiculoPublicacaoCodigo;
    }

    public void setVeiculoPublicacaoCodigo(Integer veiculoPublicacaoCodigo) {
        this.veiculoPublicacaoCodigo = veiculoPublicacaoCodigo;
    }

    public VeiculoPublicacao getVeiculoPublicacao() {
        return this.veiculoPublicacao;
    }

    public void setVeiculoPublicacao(VeiculoPublicacao veiculoPublicacao) {
        this.veiculoPublicacaoCodigo = veiculoPublicacao != null ? veiculoPublicacao.getCodigo() : null;
        this.veiculoPublicacao = veiculoPublicacao;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.motivo == null ? 0 : this.motivo.hashCode());
        result = 31 * result + (this.numeroDocumento == null ? 0 : this.numeroDocumento.hashCode());
        result = 31 * result + (this.tipoLegalCodigo == null ? 0 : this.tipoLegalCodigo.hashCode());
        result = 31 * result + (this.veiculoPublicacaoCodigo == null ? 0 : this.veiculoPublicacaoCodigo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalTrabalhoDocumentoExtincao other = (LocalTrabalhoDocumentoExtincao)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.motivo == null ? other.motivo != null : !this.motivo.equals(other.motivo)) {
            return false;
        }
        if (this.numeroDocumento == null ? other.numeroDocumento != null : !this.numeroDocumento.equals(other.numeroDocumento)) {
            return false;
        }
        if (this.tipoLegalCodigo == null ? other.tipoLegalCodigo != null : !this.tipoLegalCodigo.equals(other.tipoLegalCodigo)) {
            return false;
        }
        return !(this.veiculoPublicacaoCodigo == null ? other.veiculoPublicacaoCodigo != null : !this.veiculoPublicacaoCodigo.equals(other.veiculoPublicacaoCodigo));
    }

    public String toString() {
        return "LocalTrabalhoDocumentoExtincao [tipoLegalCodigo=" + this.tipoLegalCodigo + ", tipoLegal=" + this.tipoLegal + ", numeroDocumento=" + this.numeroDocumento + ", data=" + this.data + ", motivo=" + this.motivo + ", veiculoPublicacaoCodigo=" + this.veiculoPublicacaoCodigo + ", veiculoPublicacao=" + this.veiculoPublicacao + "]";
    }
}

