/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalhoDocumentoCriacao;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalhoDocumentoExtincao;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalhoPK;
import br.com.fiorilli.sip.persistence.entity.PericiaNova;
import br.com.fiorilli.sip.persistence.entity.PontoWeb;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sipweb.vo.ws.LocalTrabalhoMinWsVo;
import br.com.fiorilli.sipweb.vo.ws.LocalTrabalhoWsVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.validation.constraints.Size;

@FilterConfigType(rootQueryType=LocalTrabalho.class)
@Entity
@Table(name="LOCAL_TRABALHO")
@Audited
public class LocalTrabalho
implements Serializable,
GenericEntity,
Filterable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_POR_ENTIDADE = "SELECT l FROM LocalTrabalho l where l.localTrabalhoPK.entidade = :entidadeId";
    public static final String QUERY_FIND_BY_ENTIDADE_TO_WS = "SELECT new " + LocalTrabalhoMinWsVo.class.getName() + "(" + "l.localTrabalhoPK.codigo, " + "l.nome) " + "FROM LocalTrabalho l " + "WHERE l.localTrabalhoPK.entidade = :entidade";
    public static final String FIND_FOR_FILTER = "SELECT l FROM LocalTrabalho l where UPPER(concat(l.localTrabalhoPK.codigo, l.nome)) LIKE UPPER('%'||:param||'%') AND l.localTrabalhoPK.entidade = :entidadeCodigo";
    public static final String GET_FULL_BY_PK = "SELECT l FROM LocalTrabalho l LEFT JOIN FETCH l.documentoCriacao.tipoLegal LEFT JOIN FETCH l.documentoExtincao.tipoLegal LEFT JOIN FETCH l.documentoCriacao.veiculoPublicacao LEFT JOIN FETCH l.documentoExtincao.veiculoPublicacao WHERE l.localTrabalhoPK = :pk ";
    public static final String QUERY_FIND_BY_PK_TO_WS = "SELECT new " + LocalTrabalhoWsVo.class.getName() + "(" + "l.localTrabalhoPK.codigo, " + "l.nome, " + "l.endereco, " + "l.latitude, " + "l.longitude," + "l.registroResponsavel) " + "FROM LocalTrabalho l " + "WHERE l.localTrabalhoPK = :pk ";
    @EmbeddedId
    protected LocalTrabalhoPK localTrabalhoPK;
    @FilterConfig(label="Nome", order=2)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Embedded
    private Endereco endereco;
    @Embedded
    private LocalTrabalhoDocumentoCriacao documentoCriacao;
    @Embedded
    private LocalTrabalhoDocumentoExtincao documentoExtincao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Entidade entidade;
    @Column(name="LATITUDE")
    private Double latitude;
    @Column(name="LONGITUDE")
    private Double longitude;
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registroResponsavel;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="localTrabalho", cascade={CascadeType.ALL})
    private List<PericiaNova> pericias = new ArrayList<PericiaNova>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="localTrabalho", cascade={CascadeType.ALL})
    private List<PontoWeb> pontosWeb = new ArrayList<PontoWeb>();
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador responsavel;
    @Column(name="TOLERANCIA_BATIDA_METROS")
    private Double toleranciaBatidaMetros;

    @PostLoad
    public void postLoad() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
    }

    public LocalTrabalho() {
    }

    public LocalTrabalho(LocalTrabalhoPK localTrabalhoPK) {
        this.localTrabalhoPK = localTrabalhoPK;
    }

    public LocalTrabalho(String entidade, String codigo) {
        this.localTrabalhoPK = new LocalTrabalhoPK(entidade, codigo);
    }

    public static LocalTrabalho createNotNull(String entidadeCodigo) {
        LocalTrabalho lt = new LocalTrabalho(entidadeCodigo, null);
        lt.endereco = new Endereco();
        return lt;
    }

    public LocalTrabalhoPK getLocalTrabalhoPK() {
        return this.localTrabalhoPK;
    }

    public void setLocalTrabalhoPK(LocalTrabalhoPK localTrabalhoPK) {
        this.localTrabalhoPK = localTrabalhoPK;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Endereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public List<PericiaNova> getPericias() {
        return this.pericias;
    }

    public void setPericias(List<PericiaNova> pericias) {
        this.pericias = pericias;
    }

    public List<PontoWeb> getPontosWeb() {
        return this.pontosWeb;
    }

    public void setPontosWeb(List<PontoWeb> pontosWeb) {
        this.pontosWeb = pontosWeb;
    }

    public String getRegistroResponsavel() {
        return this.registroResponsavel;
    }

    public void setRegistroResponsavel(String responsavelRegistro) {
        this.registroResponsavel = responsavelRegistro;
    }

    public Trabalhador getResponsavel() {
        return this.responsavel;
    }

    public void setResponsavel(Trabalhador responsavel) {
        this.responsavel = responsavel;
    }

    public Double getToleranciaBatidaMetros() {
        return this.toleranciaBatidaMetros;
    }

    public void setToleranciaBatidaMetros(Double toleranciaBatidaMetros) {
        this.toleranciaBatidaMetros = toleranciaBatidaMetros;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.localTrabalhoPK != null ? this.localTrabalhoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocalTrabalho)) {
            return false;
        }
        LocalTrabalho other = (LocalTrabalho)object;
        return (this.localTrabalhoPK != null || other.localTrabalhoPK == null) && (this.localTrabalhoPK == null || this.localTrabalhoPK.equals(other.localTrabalhoPK));
    }

    public String toString() {
        return "entity.LocalTrabalho[ localTrabalhoPK=" + this.localTrabalhoPK + " ]";
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    @Override
    public String getHashId() {
        return Integer.toString(this.hashCode());
    }

    public String getItemId() {
        return this.localTrabalhoPK.getCodigo();
    }

    public String getItemLabel() {
        return this.nome;
    }

    public LocalTrabalhoDocumentoCriacao getDocumentoCriacao() {
        return this.documentoCriacao;
    }

    public void setDocumentoCriacao(LocalTrabalhoDocumentoCriacao documentoCriacao) {
        this.documentoCriacao = documentoCriacao;
    }

    public LocalTrabalhoDocumentoExtincao getDocumentoExtincao() {
        return this.documentoExtincao;
    }

    public void setDocumentoExtincao(LocalTrabalhoDocumentoExtincao documentoExtincao) {
        this.documentoExtincao = documentoExtincao;
    }
}

