/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CancelaLicencaPremio;
import br.com.fiorilli.sip.persistence.entity.LicencaPremio;
import br.com.fiorilli.sip.persistence.entity.LicencaPremioMovimentoPK;
import br.com.fiorilli.sip.persistence.entity.Referencia;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sipweb.vo.FrequenciaVO;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="MOVTOLICENCAPREMIO")
@Audited
public class LicencaPremioMovimento
implements Serializable,
Documento {
    public static final String FIND_BY_TRABALHADOR_FOR_MOVIMENTOVO = "SELECT NEW br.com.fiorilli.sipweb.vo.MovimentoVo('1', '', '', '', m.gozoInicio, m.gozoFim, CONCAT('Gozo de Licen\u00e7a-Pr\u00eamio', CASE WHEN COALESCE(m.pagamentoDias, 0) > 0 THEN CONCAT('/Dias Pagto:', m.pagamentoDias) ELSE '' END, CASE WHEN COALESCE(m.diasAbono, 0) > 0 THEN CONCAT('/Dias Abono:', m.diasAbono) ELSE '' END), '',  CONCAT('Per\u00edodo Aquisitivo: ', YEAR(l.aquisitivoInicio), ' - ', YEAR(l.aquisitivoFim)), 0, '',  m.tipolegal, m.numdoc, m.datadoc)FROM LicencaPremioMovimento m LEFT JOIN m.licencaPremio l WHERE m.trabalhador.trabalhadorPK = :trabalhadorPK AND ((m.gozoInicio BETWEEN :periodoInicio AND :periodoFim) or (m.gozoFim between :periodoInicio and :periodoFim) or (m.gozoInicio < :periodoInicio and m.gozoFim > :periodoFim))";
    public static final String IS_TRABALHADOR_EM_LICENCA = "SELECT CASE WHEN COALESCE(COUNT(m.licencaPremioMovimentoPK.registro), 0) > 0 THEN TRUE ELSE FALSE END FROM LicencaPremioMovimento m WHERE m.licencaPremio.trabalhador.documentosPessoais.cpf = :cpf AND CURRENT_DATE BETWEEN m.gozoInicio AND m.gozoFim";
    public static final String FIND_BY_LICENCA = "select m from LicencaPremioMovimento m LEFT JOIN FETCH m.tipolegal LEFT JOIN FETCH m.licencaPremio where m.licencaPremio.licencaPremioPK = :licencaPremioPK order by m.licencaPremioMovimentoPK.item";
    public static final String GET_NEXT_ITEM = "select coalesce(max(m.licencaPremioMovimentoPK.item), 0) + 1 from LicencaPremioMovimento m where m.licencaPremio.licencaPremioPK = :licencaPremioPK";
    public static final String FIND_BY_DATA = "SELECT m.gozoInicio AS gozoInicio, m.gozoFim AS gozoFim FROM LicencaPremioMovimento m LEFT JOIN m.cancelaLicencaPremioList c WHERE m.trabalhador.trabalhadorPK = :trabalhadorPK AND (:data BETWEEN m.gozoInicio AND COALESCE(m.gozoFim, CURRENT_DATE)) AND c.tipo IS NULL ";
    public static final String FIND_BY_PERIODO = "select m.gozoInicio AS gozoInicio, m.gozoFim AS gozoFim, c as cancelaLicencaPremio from LicencaPremioMovimento m left join m.trabalhador tr left join m.cancelaLicencaPremioList c where tr.trabalhadorPK = :trabalhadorPK and (\t(m.gozoInicio between :primeiro_dia and :ultimo_dia) \tor (m.gozoFim between :primeiro_dia and :ultimo_dia) \tor (m.gozoInicio < :primeiro_dia and m.gozoFim > :ultimo_dia)) and (    c.dtretorno is null    or (c.dtretorno =        (select min(c2.dtretorno) from CancelaLicencaPremio c2 where c2.movtolicencapremio = m)   ) )";
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected LicencaPremioMovimentoPK licencaPremioMovimentoPK;
    @Size(max=2)
    @Column(name="PAGTOMES")
    private String mesPagamento;
    @Size(max=4)
    @Column(name="PAGTOANO")
    private String anoPagamento;
    @Column(name="GOZOINI")
    @Temporal(value=TemporalType.DATE)
    private Date gozoInicio;
    @Column(name="GOZOFIM")
    @Temporal(value=TemporalType.DATE)
    private Date gozoFim;
    @Column(name="GOZODIAS")
    private Short gozodias;
    @Column(name="PAGTODIAS")
    private Short pagamentoDias;
    @Column(name="DIASABONO")
    private Short diasAbono;
    @Type(type="BooleanTypeSip")
    @Column(name="ADIANTAMENTO")
    private Boolean adiantamento;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date datadoc;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numdoc;
    @Column(name="DTPAGTO")
    @Temporal(value=TemporalType.DATE)
    private Date dtpagto;
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO_LICPREM")
    private Integer codigoLicprem;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipolegal;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @JoinColumn(name="REFERENCIA_PAGTO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Referencia referenciaPagto;
    @Column(name="REFERENCIA_PAGTO")
    private Integer referenciaPagtoCodigo;
    @Column(name="TIPOREFERENCIA")
    private Integer tipoReferencia;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false), @JoinColumn(name="LICENCAPREMIO", referencedColumnName="ITEM", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private LicencaPremio licencaPremio;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador trabalhador;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="movtolicencapremio", fetch=FetchType.LAZY, orphanRemoval=true)
    private List<CancelaLicencaPremio> cancelaLicencaPremioList;
    @Transient
    private CancelaLicencaPremio cancelaLicencaPremio;

    public LicencaPremioMovimento() {
    }

    public LicencaPremioMovimento(LicencaPremioMovimentoPK movtolicencapremioPK) {
        this.licencaPremioMovimentoPK = movtolicencapremioPK;
    }

    public LicencaPremioMovimento(LicencaPremioMovimentoPK movtolicencapremioPK, int codigoLicprem) {
        this.licencaPremioMovimentoPK = movtolicencapremioPK;
        this.codigoLicprem = codigoLicprem;
    }

    public LicencaPremioMovimento(String entidade, String registro, short licencapremio, short item) {
        this.licencaPremioMovimentoPK = new LicencaPremioMovimentoPK(entidade, registro, licencapremio, item);
    }

    public LicencaPremioMovimentoPK getLicencaPremioMovimentoPK() {
        if (this.licencaPremioMovimentoPK == null) {
            this.licencaPremioMovimentoPK = new LicencaPremioMovimentoPK();
        }
        return this.licencaPremioMovimentoPK;
    }

    public void setLicencaPremioMovimentoPK(LicencaPremioMovimentoPK movtolicencapremioPK) {
        this.licencaPremioMovimentoPK = movtolicencapremioPK;
    }

    public String getMesPagamento() {
        return this.mesPagamento;
    }

    public void setMesPagamento(String pagtomes) {
        this.mesPagamento = pagtomes;
    }

    public String getAnoPagamento() {
        return this.anoPagamento;
    }

    public void setAnoPagamento(String pagtoano) {
        this.anoPagamento = pagtoano;
    }

    public Date getGozoInicio() {
        return this.gozoInicio;
    }

    public void setGozoInicio(Date gozoInicio) {
        this.gozoInicio = gozoInicio;
    }

    public Date getGozoFim() {
        return this.gozoFim;
    }

    public void setGozoFim(Date gozoFim) {
        this.gozoFim = gozoFim;
    }

    public Short getGozodias() {
        return this.gozodias;
    }

    public void setGozodias(Short gozodias) {
        this.gozodias = gozodias;
    }

    public Short getPagamentoDias() {
        return this.pagamentoDias;
    }

    public void setPagamentoDias(Short pagtodias) {
        this.pagamentoDias = pagtodias;
    }

    public Short getDiasAbono() {
        return this.diasAbono;
    }

    public void setDiasAbono(Short diasabono) {
        this.diasAbono = diasabono;
    }

    public Boolean getAdiantamento() {
        return this.adiantamento;
    }

    public void setAdiantamento(Boolean adiantamento) {
        this.adiantamento = adiantamento;
    }

    public Date getDatadoc() {
        return this.datadoc;
    }

    public void setDatadoc(Date datadoc) {
        this.datadoc = datadoc;
    }

    public String getNumdoc() {
        return this.numdoc;
    }

    public void setNumdoc(String numdoc) {
        this.numdoc = numdoc;
    }

    public Date getDtpagto() {
        return this.dtpagto;
    }

    public void setDtpagto(Date dtpagto) {
        this.dtpagto = dtpagto;
    }

    public int getCodigoLicprem() {
        return this.codigoLicprem;
    }

    public void setCodigoLicprem(Integer codigoLicprem) {
        this.codigoLicprem = codigoLicprem;
    }

    public TipoDocumentoLegal getTipolegal() {
        return this.tipolegal;
    }

    public void setTipolegal(TipoDocumentoLegal tipolegal) {
        this.tipolegal = tipolegal;
    }

    public Referencia getReferenciaPagto() {
        if (this.referenciaPagto == null) {
            this.referenciaPagto = new Referencia();
        }
        return this.referenciaPagto;
    }

    public void setReferenciaPagto(Referencia referenciaPagto) {
        this.referenciaPagto = referenciaPagto;
        this.referenciaPagtoCodigo = referenciaPagto == null ? null : referenciaPagto.getCodigo();
    }

    public LicencaPremio getLicencaPremio() {
        return this.licencaPremio;
    }

    public void setLicencaPremio(LicencaPremio licencaPremio) {
        this.licencaPremio = licencaPremio;
        if (licencaPremio != null) {
            this.getLicencaPremioMovimentoPK().setEntidade(licencaPremio.getLicencaPremioPK().getEntidade());
            this.getLicencaPremioMovimentoPK().setRegistro(licencaPremio.getLicencaPremioPK().getRegistro());
            this.getLicencaPremioMovimentoPK().setLicencapremio(licencaPremio.getLicencaPremioPK().getItem());
            this.setCodigoLicprem(licencaPremio.getCodigo());
        } else {
            this.getLicencaPremioMovimentoPK().setEntidade(null);
            this.getLicencaPremioMovimentoPK().setRegistro(null);
            this.setCodigoLicprem(null);
        }
    }

    public List<CancelaLicencaPremio> getCancelaLicencaPremioList() {
        return this.cancelaLicencaPremioList;
    }

    public void setCancelaLicencaPremioList(List<CancelaLicencaPremio> cancelaLicencapremioList) {
        this.cancelaLicencaPremioList = cancelaLicencapremioList;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.licencaPremioMovimentoPK != null ? this.licencaPremioMovimentoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LicencaPremioMovimento)) {
            return false;
        }
        LicencaPremioMovimento other = (LicencaPremioMovimento)object;
        return (this.licencaPremioMovimentoPK != null || other.licencaPremioMovimentoPK == null) && (this.licencaPremioMovimentoPK == null || this.licencaPremioMovimentoPK.equals(other.licencaPremioMovimentoPK));
    }

    public String toString() {
        return "entity.Movtolicencapremio[ movtolicencapremioPK=" + this.licencaPremioMovimentoPK + " ]";
    }

    public CancelaLicencaPremio getCancelaLicencaPremio() {
        if (this.getCancelaLicencaPremioList() != null && this.getCancelaLicencaPremioList().size() > 0) {
            this.cancelaLicencaPremio = this.getCancelaLicencaPremioList().get(0);
        }
        return this.cancelaLicencaPremio;
    }

    public void setCancelaLicencaPremio(CancelaLicencaPremio cancelaLicencaPremio) {
        this.cancelaLicencaPremio = cancelaLicencaPremio;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public Integer getReferenciaPagtoCodigo() {
        return this.referenciaPagtoCodigo;
    }

    public void setReferenciaPagtoCodigo(Integer referenciaPagtoCodigo) {
        this.referenciaPagtoCodigo = referenciaPagtoCodigo;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipolegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal value) {
        this.tipoLegalCodigo = this.tipolegal != null ? value.getCodigo() : null;
        this.tipolegal = value;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numdoc;
    }

    @Override
    public void setNumeroDocumento(String value) {
        this.numdoc = value;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numdoc);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numdoc);
    }

    @Override
    public Date getData() {
        return this.datadoc;
    }

    @Override
    public void setData(Date value) {
        this.datadoc = value;
    }

    public Integer getTipoReferencia() {
        return this.tipoReferencia;
    }

    public void setTipoReferencia(Integer tipoReferencia) {
        this.tipoReferencia = tipoReferencia;
    }

    public static class LicencaPremioMovimentoSql {
        public static final String FIND_BY_ENTIDADE_PERIODO_WS = "SELECT    NEW " + FrequenciaVO.class.getCanonicalName() + "(" + "m.licencaPremioMovimentoPK.entidade, " + "m.licencaPremioMovimentoPK.registro, " + "m.gozoInicio, " + "CASE COALESCE(c.tipo, 0) WHEN 2 THEN COALESCE(c.dtretorno - 1, m.gozoFim) ELSE m.gozoFim END, " + "'4', " + "'', " + "m.licencaPremioMovimentoPK.entidade||'-'||m.licencaPremioMovimentoPK.registro||'-'||m.licencaPremioMovimentoPK.licencapremio||'-'||m.licencaPremioMovimentoPK.item, " + "t.matricula, " + "t.contrato, " + "t.documentosPessoais.cpf, " + "0.0, " + "'', " + "'', " + "0, " + "'') " + "FROM LicencaPremioMovimento m " + "INNER JOIN m.trabalhador t " + "LEFT JOIN m.cancelaLicencaPremioList c " + "WHERE m.licencaPremioMovimentoPK.entidade = :entidadeCodigo " + "   AND (m.licencaPremioMovimentoPK.registro = :registro or :registro = '000000') " + "   AND ((m.gozoInicio between :periodoInicio and :periodoFim) " + "       or (m.gozoFim between :periodoInicio and :periodoFim) " + "       or (m.gozoInicio < :periodoInicio and m.gozoFim > :periodoFim)) " + "   AND COALESCE(c.tipo, 0) NOT IN (3, 1) " + "   AND ((COALESCE(c.tipo, 0) <> 2) OR ((COALESCE(c.tipo, 0) = 2) AND ((COALESCE(c.dtretorno, c.datadoc) - 1) > m.gozoInicio))) ";
        public static final String FIND_BY_PERIODO_WS = "SELECT NEW " + FrequenciaVO.class.getCanonicalName() + "(" + "m.licencaPremioMovimentoPK.entidade, " + "m.licencaPremioMovimentoPK.registro, " + "m.gozoInicio, " + "CASE COALESCE(c.tipo, 0) WHEN 2 THEN COALESCE(c.dtretorno - 1, m.gozoFim) ELSE  m.gozoFim END, " + "'4', " + "'', " + "m.licencaPremioMovimentoPK.entidade||'-'||m.licencaPremioMovimentoPK.registro||'-'||m.licencaPremioMovimentoPK.licencapremio||'-'||m.licencaPremioMovimentoPK.item, " + "t.matricula, " + "t.contrato, " + "t.documentosPessoais.cpf, " + "0.0, " + "'', " + "'', " + "0, " + "'') " + "FROM LicencaPremioMovimento m " + "INNER JOIN m.trabalhador t " + "LEFT JOIN m.cancelaLicencaPremioList c " + "WHERE (m.licencaPremioMovimentoPK.registro = :registro or :registro = '000000') " + "   AND ((m.gozoInicio between :periodoInicio and :periodoFim) " + "       OR (m.gozoFim between :periodoInicio and :periodoFim) " + "       OR (m.gozoInicio < :periodoInicio and m.gozoFim > :periodoFim)) " + "   AND COALESCE(c.tipo, 0) NOT IN (3, 1) " + "   AND ((COALESCE(c.tipo, 0) <> 2) OR ((COALESCE(c.tipo, 0) = 2) AND ((COALESCE(c.dtretorno, c.datadoc) - 1) > m.gozoInicio))) ";
        public static final String FIND_BY_ENTIDADE_MATRICULA_CONTRATO_PERIODO_WS = "SELECT NEW " + FrequenciaVO.class.getCanonicalName() + "(" + "m.licencaPremioMovimentoPK.entidade, " + "m.licencaPremioMovimentoPK.registro, " + "m.gozoInicio, " + "CASE COALESCE(c.tipo, 0) WHEN 2 THEN COALESCE(c.dtretorno - 1, m.gozoFim) ELSE m.gozoFim END, " + "'4', " + "'', " + "m.licencaPremioMovimentoPK.entidade||'-'||m.licencaPremioMovimentoPK.registro||'-'||m.licencaPremioMovimentoPK.licencapremio||'-'||m.licencaPremioMovimentoPK.item, " + "t.matricula, " + "t.contrato, " + "t.documentosPessoais.cpf, " + "0.0, " + "'', " + "'', " + "0, " + "'') " + "FROM LicencaPremioMovimento m " + "INNER JOIN m.trabalhador t " + "LEFT JOIN m.cancelaLicencaPremioList c " + "WHERE m.licencaPremioMovimentoPK.entidade = :entidadeCodigo " + "   AND t.matricula = :matricula " + "   AND t.contrato = :contrato " + "   AND ((m.gozoInicio between :periodoInicio and :periodoFim) " + "       OR (m.gozoFim between :periodoInicio and :periodoFim) " + "       OR (m.gozoInicio < :periodoInicio and m.gozoFim > :periodoFim)) " + "   AND COALESCE(c.tipo, 0) NOT IN (3, 1) " + "   AND ((COALESCE(c.tipo, 0) <> 2) OR ((COALESCE(c.tipo, 0) = 2) AND ((COALESCE(c.dtretorno, c.datadoc) - 1) > m.gozoInicio))) ";
    }
}

