/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.LicencaPremioMovimento;
import br.com.fiorilli.sip.persistence.entity.LicencaPremioPK;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="LICENCA_PREMIO")
@Audited
public class LicencaPremio
implements Serializable {
    public static final String FIND_BY_TRABALHADOR = "SELECT l FROM LicencaPremio l WHERE l.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY l.licencaPremioPK.item";
    public static final String GET_NEXT_ITEM = "select coalesce(max(l.licencaPremioPK.item), 0) + 1 from LicencaPremio l where l.trabalhador.trabalhadorPK = :trabalhadorPK";
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected LicencaPremioPK licencaPremioPK;
    @Column(name="AQUISINI")
    @Temporal(value=TemporalType.DATE)
    private Date aquisitivoInicio;
    @Column(name="AQUISFIM")
    @Temporal(value=TemporalType.DATE)
    private Date aquisitivoFim;
    @Column(name="VENCIDO")
    @Type(type="BooleanTypeSip")
    private Boolean vencido;
    @Type(type="BooleanTypeSip")
    @Column(name="PAGO")
    private Boolean pago;
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Column(name="SUSPENSOES")
    private Short suspensoes;
    @Type(type="BooleanTypeSip")
    @Column(name="CANCELADO")
    private Boolean cancelado;
    @Size(max=512)
    @Column(name="OBS")
    private String obs;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="licencaPremio", fetch=FetchType.LAZY)
    private List<LicencaPremioMovimento> movimentoList;

    public LicencaPremio() {
    }

    public LicencaPremio(LicencaPremioPK licencaPremioPK) {
        this.licencaPremioPK = licencaPremioPK;
    }

    public LicencaPremio(LicencaPremioPK licencaPremioPK, int codigo) {
        this.licencaPremioPK = licencaPremioPK;
        this.codigo = codigo;
    }

    public LicencaPremio(String entidade, String registro, short item) {
        this.licencaPremioPK = new LicencaPremioPK(entidade, registro, item);
    }

    public LicencaPremioPK getLicencaPremioPK() {
        if (this.licencaPremioPK == null) {
            this.licencaPremioPK = new LicencaPremioPK();
        }
        return this.licencaPremioPK;
    }

    public void setLicencaPremioPK(LicencaPremioPK licencaPremioPK) {
        this.licencaPremioPK = licencaPremioPK;
    }

    public Date getAquisitivoInicio() {
        return this.aquisitivoInicio;
    }

    public void setAquisitivoInicio(Date aquisini) {
        this.aquisitivoInicio = aquisini;
    }

    public Date getAquisitivoFim() {
        return this.aquisitivoFim;
    }

    public void setAquisitivoFim(Date aquisfim) {
        this.aquisitivoFim = aquisfim;
    }

    public Boolean getVencido() {
        return this.vencido;
    }

    public void setVencido(Boolean vencido) {
        this.vencido = vencido;
    }

    public Boolean getPago() {
        return this.pago;
    }

    public void setPago(Boolean pago) {
        this.pago = pago;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Short getSuspensoes() {
        return this.suspensoes;
    }

    public void setSuspensoes(Short suspensoes) {
        this.suspensoes = suspensoes;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        if (trabalhador != null) {
            this.getLicencaPremioPK().setEntidade(trabalhador.getTrabalhadorPK().getEntidade());
            this.getLicencaPremioPK().setRegistro(trabalhador.getTrabalhadorPK().getRegistro());
        } else {
            this.getLicencaPremioPK().setEntidade(null);
            this.getLicencaPremioPK().setRegistro(null);
        }
    }

    public List<LicencaPremioMovimento> getMovimentoList() {
        return this.movimentoList;
    }

    public void setMovimentoList(List<LicencaPremioMovimento> movtolicencapremioList) {
        this.movimentoList = movtolicencapremioList;
    }

    public Boolean getCancelado() {
        return this.cancelado;
    }

    public void setCancelado(Boolean cancelado) {
        this.cancelado = cancelado;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.licencaPremioPK != null ? this.licencaPremioPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LicencaPremio)) {
            return false;
        }
        LicencaPremio other = (LicencaPremio)object;
        return (this.licencaPremioPK != null || other.licencaPremioPK == null) && (this.licencaPremioPK == null || this.licencaPremioPK.equals(other.licencaPremioPK));
    }

    public String toString() {
        return "entity.LicencaPremio[ licencaPremioPK=" + this.licencaPremioPK + " ]";
    }

    public String getObs() {
        return this.obs;
    }

    public void setObs(String obs) {
        this.obs = obs;
    }
}

