/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.api.SearchCodigo;
import br.com.fiorilli.sip.persistence.api.SearchEntidade;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Embeddable
public class JornadaPK
implements Serializable {
    private static final long serialVersionUID = 1L;
    @SearchEntidade
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidade;
    @SearchCodigo
    @FilterConfig(label="C\u00f3digo", order=1, inputType=FilterInputType.NUMBER)
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Short codigo;

    public JornadaPK() {
    }

    public JornadaPK(String entidade, short codigo) {
        this.entidade = entidade;
        this.codigo = codigo;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public Short getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Short codigo) {
        this.codigo = codigo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JornadaPK jornadaPK = (JornadaPK)o;
        return Objects.equals(this.entidade, jornadaPK.entidade) && Objects.equals(this.codigo, jornadaPK.codigo);
    }

    public int hashCode() {
        return Objects.hash(this.entidade, this.codigo);
    }

    public String toString() {
        return "JornadaPK{entidade='" + this.entidade + '\'' + ", codigo=" + this.codigo + '}';
    }
}

