/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.commons.util.SIPDateUtil;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.AgendamentoDeJornada;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.JornadaColetiva;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="JORNADA_EVENTUAL")
@FilterConfigType(autoFilter=true)
@Audited
public class JornadaEventual
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_JORNADA_EVENTUAL";
    @Id
    @NotNull
    @Column(name="ID")
    private Integer id;
    @NotNull
    @Column(name="EMPRESA")
    @Size(min=1, max=3)
    private String entidadeCodigo;
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @NotNull
    @Column(name="JORNADA")
    private Short jornadaCodigo;
    @FilterConfig(label="Per. In\u00edcio", inputType=FilterInputType.CALENDAR, condition=FilterCondition.MAIOR_IGUAL, order=3)
    @NotNull
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DH_INICIO")
    private Date dataHoraInicio;
    @FilterConfig(label="Per. Fim", inputType=FilterInputType.CALENDAR, condition=FilterCondition.MENOR_IGUAL, order=4)
    @NotNull
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DH_TERMINO")
    private Date dataHoraTermino;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @FilterConfig(label="Trabalhador", inputType=FilterInputType.AUTO_COMPLETE, order=1)
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @FilterConfig(label="Jornada", inputType=FilterInputType.AUTO_COMPLETE, order=2)
    @FilterConfigSelect(query="SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="JORNADA", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Jornada jornada;
    @Column(name="AGENDAMENTO_ID")
    private Integer agendamentoId;
    @JoinColumn(name="AGENDAMENTO_ID", referencedColumnName="ID", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private AgendamentoDeJornada agendamento;
    @Basic(optional=false)
    @Column(name="JORNADA_COLETIVA")
    private Integer jornadaColetivaCodigo;
    @JoinColumn(name="JORNADA_COLETIVA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private JornadaColetiva jornadaColetiva;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Short getJornadaCodigo() {
        return this.jornadaCodigo;
    }

    public void setJornadaCodigo(Short jornadaCodigo) {
        this.jornadaCodigo = jornadaCodigo;
    }

    public Date getDataHoraInicio() {
        return this.dataHoraInicio;
    }

    public void setDataHoraInicio(Date dataHoraInicio) {
        this.dataHoraInicio = dataHoraInicio;
    }

    public Date getDataHoraTermino() {
        return this.dataHoraTermino;
    }

    public void setDataHoraTermino(Date dataHoraTermino) {
        this.dataHoraTermino = dataHoraTermino;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        if (trabalhador == null) {
            this.entidadeCodigo = null;
            this.registro = null;
        } else {
            this.entidadeCodigo = trabalhador.getTrabalhadorPK().getEntidade();
            this.registro = trabalhador.getTrabalhadorPK().getRegistro();
        }
        this.trabalhador = trabalhador;
    }

    public Jornada getJornada() {
        return this.jornada;
    }

    public void setJornada(Jornada jornada) {
        this.jornadaCodigo = jornada == null ? null : jornada.getJornadaPK().getCodigo();
        this.jornada = jornada;
    }

    public AgendamentoDeJornada getAgendamento() {
        return this.agendamento;
    }

    public void setAgendamento(AgendamentoDeJornada agendamento) {
        this.agendamentoId = agendamento == null ? null : agendamento.getId();
        this.agendamento = agendamento;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataHoraInicio == null ? 0 : this.dataHoraInicio.hashCode());
        result = 31 * result + (this.dataHoraTermino == null ? 0 : this.dataHoraTermino.hashCode());
        result = 31 * result + (this.entidadeCodigo == null ? 0 : this.entidadeCodigo.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.jornadaCodigo == null ? 0 : this.jornadaCodigo.hashCode());
        result = 31 * result + (this.registro == null ? 0 : this.registro.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JornadaEventual other = (JornadaEventual)obj;
        if (this.dataHoraInicio == null ? other.dataHoraInicio != null : !this.dataHoraInicio.equals(other.dataHoraInicio)) {
            return false;
        }
        if (this.dataHoraTermino == null ? other.dataHoraTermino != null : !this.dataHoraTermino.equals(other.dataHoraTermino)) {
            return false;
        }
        if (this.entidadeCodigo == null ? other.entidadeCodigo != null : !this.entidadeCodigo.equals(other.entidadeCodigo)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.jornadaCodigo == null ? other.jornadaCodigo != null : !this.jornadaCodigo.equals(other.jornadaCodigo)) {
            return false;
        }
        return !(this.registro == null ? other.registro != null : !this.registro.equals(other.registro));
    }

    public String toString() {
        return "JornadaEventual [id=" + this.id + ", entidadeCodigo=" + this.entidadeCodigo + ", registro=" + this.registro + ", jornadaCodigo=" + this.jornadaCodigo + ", dataHoraInicio=" + this.dataHoraInicio + ", dataHoraTermino=" + this.dataHoraTermino + "]";
    }

    public static JornadaEventual criarParaAgenda(String entidade, String registro, Date data, Jornada jornada) {
        JornadaEventual jornadaEventual = new JornadaEventual();
        jornadaEventual.entidadeCodigo = entidade;
        jornadaEventual.registro = registro;
        jornadaEventual.dataHoraInicio = SIPDateUtil.withFirstTimeOfDay((Date)data);
        jornadaEventual.dataHoraTermino = SIPDateUtil.withLastTimeOfDay((Date)data);
        jornadaEventual.jornada = jornada;
        jornadaEventual.jornadaCodigo = jornada.jornadaPK.getCodigo();
        return jornadaEventual;
    }

    public Integer getJornadaColetivaCodigo() {
        return this.jornadaColetivaCodigo;
    }

    public void setJornadaColetivaCodigo(Integer jornadaColetivaCodigo) {
        this.jornadaColetivaCodigo = jornadaColetivaCodigo;
    }

    public JornadaColetiva getJornadaColetiva() {
        return this.jornadaColetiva;
    }

    public void setJornadaColetiva(JornadaColetiva jornadaColetiva) {
        this.jornadaColetivaCodigo = jornadaColetiva == null ? null : jornadaColetiva.getCodigo();
        this.jornadaColetiva = jornadaColetiva;
    }

    @AssertTrue(message="A data de in\u00edcio \u00e9 maior que a data de fim")
    public boolean isPeriodoValido() {
        return this.dataHoraInicio == null || this.dataHoraTermino == null || this.dataHoraInicio.getTime() <= this.dataHoraTermino.getTime();
    }

    public Integer getAgendamentoId() {
        return this.agendamentoId;
    }

    public void setAgendamentoId(Integer agendamentoId) {
        this.agendamentoId = agendamentoId;
    }
}

