/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public enum JornadaDiaSemana {
    SEGUNDA_FEIRA(1, "Segunda-feira"),
    TERCA_FEIRA(2, "Ter\u00e7a-feira"),
    QUARTA_FEIRA(3, "Quarta-feira"),
    QUINTA_FEIRA(4, "Quinta-feira"),
    SEXTA_FEIRA(5, "Sexta-feira"),
    SABADO(6, "S\u00e1bado"),
    DOMINGO(7, "Domingo"),
    TURNO_HORA(8, "Turno/Hora"),
    TURNO_DIA(9, "Turno/Dia"),
    TURNO_VARIADO(10, "Turno/Variado");

    private final int codigo;
    private final String nome;

    private JornadaDiaSemana(int codigo, String nome) {
        this.codigo = codigo;
        this.nome = nome;
    }

    public int getCodigo() {
        return this.codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public static JornadaDiaSemana get(Integer codigo) {
        if (codigo == null) {
            return null;
        }
        for (JornadaDiaSemana j : JornadaDiaSemana.values()) {
            if (j.getCodigo() != codigo.intValue()) continue;
            return j;
        }
        throw new IllegalArgumentException("N\u00e3o existe um dia da semana com o c\u00f3digo " + codigo);
    }

    public static JornadaDiaSemana getNextDiaSemana(JornadaDiaSemana diaSemana) {
        int max = JornadaDiaSemana.values().length;
        int next = diaSemana.getCodigo() + 1;
        if (next < max) {
            return JornadaDiaSemana.get(next);
        }
        return SEGUNDA_FEIRA;
    }

    public static JornadaDiaSemana getByDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayOfWeek = cal.get(7);
        if (--dayOfWeek == 0) {
            dayOfWeek = 7;
        }
        return JornadaDiaSemana.get(dayOfWeek);
    }

    public boolean isTurnoHora() {
        return this.equals((Object)TURNO_HORA);
    }

    public boolean isTurnoDia() {
        return this.equals((Object)TURNO_DIA);
    }

    public boolean isTurno() {
        return this.isTurnoDia() || this.isTurnoHora() || this.isTurnoVariado();
    }

    public boolean isTurnoVariado() {
        return TURNO_VARIADO == this;
    }

    public boolean isBefore(JornadaDiaSemana outroDiaDaSemana) {
        return this.codigo < outroDiaDaSemana.codigo;
    }

    public boolean isBeforeOrEqual(JornadaDiaSemana outroDiaDaSemana) {
        return this.codigo <= outroDiaDaSemana.codigo;
    }

    public boolean isAfter(JornadaDiaSemana outroDiaDaSemana) {
        return this.codigo > outroDiaDaSemana.codigo;
    }

    public static List<JornadaDiaSemana> getOnlyDaysOfWeek() {
        LinkedList<JornadaDiaSemana> diasSemana = new LinkedList<JornadaDiaSemana>();
        for (JornadaDiaSemana dia : JornadaDiaSemana.values()) {
            if (dia.ordinal() > DOMINGO.ordinal()) break;
            diasSemana.add(dia);
        }
        return diasSemana;
    }
}

