/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.api.IdentificadorESocial;
import br.com.fiorilli.sip.persistence.entity.JornadaDiaSemana;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Embeddable
public class JornadaDiaPK
implements Serializable,
IdentificadorESocial {
    private static final long serialVersionUID = 1L;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidade;
    @Basic(optional=false)
    @NotNull
    @Column(name="JORNADA")
    private Short jornada;
    @Basic(optional=false)
    @NotNull
    @Column(name="DIA")
    private Integer dia;

    public JornadaDiaPK() {
    }

    public JornadaDiaPK(String entidade, Short jornada, Integer dia) {
        this.entidade = entidade;
        this.jornada = jornada;
        this.dia = dia;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public Short getJornada() {
        return this.jornada;
    }

    public void setJornada(Short jornada) {
        this.jornada = jornada;
    }

    public JornadaDiaSemana getDia() {
        return JornadaDiaSemana.get(this.dia);
    }

    public void setDia(JornadaDiaSemana dia) {
        this.dia = dia.getCodigo();
    }

    public int hashCode() {
        int hash = 0;
        hash += this.entidade != null ? this.entidade.hashCode() : 0;
        hash += this.jornada.shortValue();
        return hash += this.dia.intValue();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JornadaDiaPK)) {
            return false;
        }
        JornadaDiaPK other = (JornadaDiaPK)object;
        if (this.entidade == null && other.entidade != null || this.entidade != null && !this.entidade.equals(other.entidade)) {
            return false;
        }
        if (this.jornada != other.jornada) {
            return false;
        }
        return this.dia == other.dia;
    }

    public String toString() {
        return "JornadaDiaPK{entidade='" + this.entidade + '\'' + ", jornada=" + this.jornada + ", dia=" + this.dia + '}';
    }

    @Override
    public String getESocialId() {
        return this.getEntidade() + "-" + this.getJornada() + "-" + this.getDia().getCodigo();
    }
}

