/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.TimeUtils;
import br.com.fiorilli.sip.persistence.entity.JornadaDia;
import br.com.fiorilli.sip.persistence.entity.PontoMovimento;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;

public enum JornadaDiaMovimento {
    ENTRADA1,
    SAIDA1,
    ENTRADA2,
    SAIDA2,
    ENTRADA3,
    SAIDA3,
    ENTRADA4,
    SAIDA4,
    ENTRADA5,
    SAIDA5;


    public LocalTime get(JornadaDia jornadaDia) {
        if (jornadaDia == null) {
            return null;
        }
        String methodName = String.format("get%s", this.capitalize());
        return TimeUtils.toLocalTime((String)((String)this.invokeMethod(jornadaDia, methodName, new Object[0])));
    }

    public Interval intervalOfTolerance(JornadaDia jornadaDia, Date data) {
        return this.interval(jornadaDia, data, true);
    }

    private Interval interval(JornadaDia jornadaDia, Date data, boolean withTolerance) {
        if (jornadaDia == null || data == null) {
            return null;
        }
        String TEMPLATE = "get%s%s";
        String mStart = String.format("get%s%s", this.capitalize(), withTolerance ? "a" : "");
        String mEnd = String.format("get%s%s", this.capitalize(), withTolerance ? "b" : "");
        LocalTime tStart = (LocalTime)this.invokeMethod(jornadaDia, mStart, new Object[0]);
        LocalTime tEnd = (LocalTime)this.invokeMethod(jornadaDia, mEnd, new Object[0]);
        if (tStart != null && tEnd != null) {
            DateTime end;
            DateTime dataBase = new DateTime((Object)data);
            DateTime start = dataBase.withMillisOfDay(tStart.getMillisOfDay());
            if (start.isAfter((ReadableInstant)(end = dataBase.withMillisOfDay(tEnd.getMillisOfDay())))) {
                SimpleDateFormat fmtDataToStr = new SimpleDateFormat("dd/MM/yyyy");
                String dataNova = fmtDataToStr.format(data);
                end = dataNova.equals("16/10/2021") ? end.plusDays(1).withZone(DateTimeZone.forOffsetHours((int)-3)).plusHours(1) : end.plusDays(1);
            }
            return new Interval((ReadableInstant)start, (ReadableInstant)end);
        }
        return null;
    }

    private String capitalize() {
        return StringUtils.capitalize((String)this.name().toLowerCase());
    }

    private Object invokeMethod(Object obj, String methodName, Object ... args) {
        try {
            if (obj == null) {
                return null;
            }
            return MethodUtils.invokeMethod((Object)obj, (String)methodName, (Object[])args);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            String msg = String.format("Ocorreu um erro ao executar o m\u00e9todo %s no objeto ponto.", methodName);
            throw new RuntimeException(msg);
        }
    }

    public static Interval intervalOfConfiguration(JornadaDia jornadaDia, Date date, int index) {
        if (jornadaDia == null || date == null || index < 0 || index >= JornadaDiaMovimento.maxIntervals()) {
            return null;
        }
        LocalTime tStart = JornadaDiaMovimento.entradas()[index].get(jornadaDia);
        LocalTime tEnd = JornadaDiaMovimento.saidas()[index].get(jornadaDia);
        if (tStart != null && tEnd != null) {
            DateTime end;
            DateTime dataBase = new DateTime((Object)date);
            DateTime start = dataBase.withMillisOfDay(tStart.getMillisOfDay());
            if (start.isAfter((ReadableInstant)(end = dataBase.withMillisOfDay(tEnd.getMillisOfDay())))) {
                SimpleDateFormat fmtDataToStr = new SimpleDateFormat("dd/MM/yyyy");
                String dataNova = fmtDataToStr.format(date);
                end = dataNova.equals("16/10/2021") ? end.plusDays(1).withZone(DateTimeZone.forOffsetHours((int)-3)).plusHours(1) : end.plusDays(1);
            }
            return new Interval((ReadableInstant)start, (ReadableInstant)end);
        }
        return null;
    }

    public static Interval intervalOfConfiguration(JornadaDia jornadaDia, Date date) {
        if (jornadaDia == null || date == null) {
            return null;
        }
        LocalTime tStart = JornadaDiaMovimento.entradas()[0].get(jornadaDia);
        LocalTime tEnd = JornadaDiaMovimento.saidas()[1].get(jornadaDia);
        if (tStart != null && tEnd != null) {
            DateTime end;
            DateTime dataBase = new DateTime((Object)date);
            DateTime start = dataBase.withMillisOfDay(tStart.getMillisOfDay());
            if (start.isAfter((ReadableInstant)(end = dataBase.withMillisOfDay(tEnd.getMillisOfDay())))) {
                SimpleDateFormat fmtDataToStr = new SimpleDateFormat("dd/MM/yyyy");
                String dataNova = fmtDataToStr.format(date);
                end = dataNova.equals("16/10/2021") ? end.plusDays(1).withZone(DateTimeZone.forOffsetHours((int)-3)).plusHours(1) : end.plusDays(1);
            }
            return new Interval((ReadableInstant)start, (ReadableInstant)end);
        }
        return null;
    }

    public static Interval intervalOfMovimentoForHoraExtra(JornadaDia jornadaDia, Date date, int index) {
        JornadaDiaMovimento entrada = JornadaDiaMovimento.entradas()[index];
        String methodName = String.format("get%sa", entrada.capitalize());
        DateTime entradaA = TimeUtils.toDateTime((Date)date, (String)((String)entrada.invokeMethod(jornadaDia, methodName, new Object[0])));
        methodName = String.format("get%s", entrada.capitalize());
        DateTime entradaPontual = TimeUtils.toDateTime((Date)date, (String)((String)entrada.invokeMethod(jornadaDia, methodName, new Object[0])));
        JornadaDiaMovimento saida = JornadaDiaMovimento.saidas()[index];
        methodName = String.format("get%sb", saida.capitalize());
        DateTime saidaB = TimeUtils.toDateTime((Date)date, (String)((String)saida.invokeMethod(jornadaDia, methodName, new Object[0])));
        methodName = String.format("get%s", saida.capitalize());
        DateTime saidaPontual = TimeUtils.toDateTime((Date)date, (String)((String)saida.invokeMethod(jornadaDia, methodName, new Object[0])));
        if (entradaA == null) {
            entradaA = entradaPontual;
        }
        if (saidaB == null) {
            saidaB = saidaPontual;
        }
        if (entradaA.isAfter((ReadableInstant)entradaPontual)) {
            entradaA = entradaA.minusDays(1);
        } else if (entradaA.isAfter((ReadableInstant)saidaB)) {
            saidaB = saidaB.plusDays(1);
        }
        return new Interval((ReadableInstant)entradaA, (ReadableInstant)saidaB);
    }

    public static Interval intervalOfMovimentoForHoraExtra(JornadaDia jornadaDia, Date date) {
        JornadaDiaMovimento entrada = JornadaDiaMovimento.entradas()[0];
        String methodName = String.format("get%sa", entrada.capitalize());
        String hora = (String)entrada.invokeMethod(jornadaDia, methodName, new Object[0]);
        DateTime entradaA = TimeUtils.toDateTime((Date)date, (String)hora);
        entrada = JornadaDiaMovimento.entradas()[0];
        methodName = String.format("get%s", entrada.capitalize());
        DateTime entradaPontual = TimeUtils.toDateTime((Date)date, (String)((String)entrada.invokeMethod(jornadaDia, methodName, new Object[0])));
        JornadaDiaMovimento saida = JornadaDiaMovimento.saidas()[1];
        methodName = String.format("get%sb", saida.capitalize());
        DateTime saidaB = TimeUtils.toDateTime((Date)date, (String)((String)saida.invokeMethod(jornadaDia, methodName, new Object[0])));
        methodName = String.format("get%s", saida.capitalize());
        DateTime saidaPontual = TimeUtils.toDateTime((Date)date, (String)((String)saida.invokeMethod(jornadaDia, methodName, new Object[0])));
        if (entradaA == null) {
            entradaA = entradaPontual;
        }
        if (saidaB == null) {
            saidaB = saidaPontual;
        }
        if (entradaA.isAfter((ReadableInstant)entradaPontual)) {
            entradaA = entradaA.minusDays(1);
        } else if (entradaA.isAfter((ReadableInstant)saidaB)) {
            saidaB = saidaB.plusDays(1);
        }
        return new Interval((ReadableInstant)entradaA, (ReadableInstant)saidaB);
    }

    public static Interval intervalOfMovimentoForFalta(JornadaDia jornadaDia, Date date, int index, boolean intervaloLivreFalta) {
        JornadaDiaMovimento entrada = JornadaDiaMovimento.entradas()[index];
        String methodName = String.format("get%sb", entrada.capitalize());
        DateTime entradaB = TimeUtils.toDateTime((Date)date, (String)((String)entrada.invokeMethod(jornadaDia, methodName, new Object[0])));
        methodName = String.format("get%s", entrada.capitalize());
        DateTime entradaPontual = TimeUtils.toDateTime((Date)date, (String)((String)entrada.invokeMethod(jornadaDia, methodName, new Object[0])));
        JornadaDiaMovimento saida = JornadaDiaMovimento.saidas()[index];
        methodName = String.format("get%sa", saida.capitalize());
        DateTime saidaA = TimeUtils.toDateTime((Date)date, (String)((String)saida.invokeMethod(jornadaDia, methodName, new Object[0])));
        methodName = String.format("get%s", saida.capitalize());
        DateTime saidaPontual = TimeUtils.toDateTime((Date)date, (String)((String)saida.invokeMethod(jornadaDia, methodName, new Object[0])));
        if (entradaB == null || intervaloLivreFalta && index > 0) {
            entradaB = entradaPontual;
        }
        if (saidaA == null) {
            saidaA = saidaPontual;
        }
        if (entradaB.isAfter((ReadableInstant)saidaA)) {
            saidaA = saidaA.plusDays(1);
        }
        return new Interval((ReadableInstant)entradaB, (ReadableInstant)saidaA);
    }

    public static Interval intervalOfToleranceAfterEntradaForFalta(JornadaDia jornadaDia, Date date, int index) {
        if (index > JornadaDiaMovimento.entradas().length - 1) {
            return null;
        }
        JornadaDiaMovimento entrada = JornadaDiaMovimento.entradas()[index];
        String methodName = String.format("get%s", entrada.capitalize());
        DateTime entradaPontual = TimeUtils.toDateTime((Date)date, (String)((String)entrada.invokeMethod(jornadaDia, methodName, new Object[0])));
        methodName = String.format("get%sb", entrada.capitalize());
        DateTime entradaB = TimeUtils.toDateTime((Date)date, (String)((String)entrada.invokeMethod(jornadaDia, methodName, new Object[0])));
        if (entradaPontual == null || entradaB == null) {
            return null;
        }
        if (entradaPontual.isAfter((ReadableInstant)entradaB)) {
            entradaB = entradaB.plusDays(1);
        }
        return new Interval((ReadableInstant)entradaPontual, (ReadableInstant)entradaB);
    }

    public static Interval[] intervalsOfJornadaDia(JornadaDia jornadaDia, Date date) {
        Interval[] intervals = new Interval[5];
        for (int index = 0; index < 5; ++index) {
            intervals[index] = JornadaDiaMovimento.intervalOfConfiguration(jornadaDia, date, index);
        }
        return intervals;
    }

    public static List<Interval> intervalsListOfJornadaDia(JornadaDia jornadaDia, Date date) {
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        for (int index = 0; index < 5; ++index) {
            Interval interval = JornadaDiaMovimento.intervalOfConfiguration(jornadaDia, date, index);
            if (interval == null) continue;
            intervals.add(interval);
        }
        return intervals;
    }

    public static JornadaDiaMovimento[] entradas() {
        return new JornadaDiaMovimento[]{ENTRADA1, ENTRADA2, ENTRADA3, ENTRADA4, ENTRADA5};
    }

    public static JornadaDiaMovimento[] saidas() {
        return new JornadaDiaMovimento[]{SAIDA1, SAIDA2, SAIDA3, SAIDA4, SAIDA5};
    }

    public static int maxIntervals() {
        return JornadaDiaMovimento.entradas().length;
    }

    public static JornadaDiaMovimento of(PontoMovimento m) {
        return JornadaDiaMovimento.valueOf(m.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Interval> intervalsInJornadaDia(JornadaDia jornadaDia, Date date) {
        ArrayList<Interval> intervalList = new ArrayList<Interval>();
        try {
            for (JornadaDiaMovimento movimento : JornadaDiaMovimento.values()) {
                if (movimento.ordinal() % 2 != 0 || movimento.ordinal() <= 0) continue;
                String methodNameSaida = String.format("get%s", JornadaDiaMovimento.values()[movimento.ordinal() - 1].capitalize());
                String methodNameEntrada = String.format("get%s", movimento.capitalize());
                DateTime tStart = TimeUtils.toDateTime((Date)date, (String)((String)movimento.invokeMethod(jornadaDia, methodNameSaida, new Object[0])));
                DateTime tEnd = TimeUtils.toDateTime((Date)date, (String)((String)movimento.invokeMethod(jornadaDia, methodNameEntrada, new Object[0])));
                if (tStart == null || tEnd == null || !tEnd.isAfter((ReadableInstant)tStart)) continue;
                intervalList.add(new Interval((ReadableInstant)tStart, (ReadableInstant)tEnd));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return intervalList;
        }
    }
}

