/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.commons.util.TimeUtils;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.JornadaDiaMovimento;
import br.com.fiorilli.sip.persistence.entity.JornadaDiaPK;
import br.com.fiorilli.sip.persistence.entity.JornadaDiaSemana;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;

@Entity
@Table(name="JORNADA_DIAS")
@Audited
public class JornadaDia
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_JORNADA = "SELECT j FROM JornadaDia j JOIN FETCH j.jornada WHERE j.jornada.jornadaPK = :jornadaPK";
    public static final String FIND_BY_ENTIDADE = "SELECT jd FROM JornadaDia jd JOIN FETCH jd.jornada WHERE jd.jornadaDiaPK.entidade = :entidadeCodigo ORDER BY jd.jornadaDiaPK.jornada, jd.jornadaDiaPK.dia";
    @EmbeddedId
    protected JornadaDiaPK jornadaDiaPK;
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Size(max=5)
    @Column(name="ENTRADA1")
    private String entrada1;
    @Size(max=5)
    @Column(name="ENTRADA1A")
    private String entrada1a;
    @Size(max=5)
    @Column(name="ENTRADA1B")
    private String entrada1b;
    @Size(max=5)
    @Column(name="ENTRADA2")
    private String entrada2;
    @Size(max=5)
    @Column(name="ENTRADA2A")
    private String entrada2a;
    @Size(max=5)
    @Column(name="ENTRADA2B")
    private String entrada2b;
    @Size(max=5)
    @Column(name="ENTRADA3")
    private String entrada3;
    @Size(max=5)
    @Column(name="ENTRADA3A")
    private String entrada3a;
    @Size(max=5)
    @Column(name="ENTRADA3B")
    private String entrada3b;
    @Size(max=5)
    @Column(name="ENTRADA4")
    private String entrada4;
    @Size(max=5)
    @Column(name="ENTRADA4A")
    private String entrada4a;
    @Size(max=5)
    @Column(name="ENTRADA4B")
    private String entrada4b;
    @Size(max=5)
    @Column(name="ENTRADA5")
    private String entrada5;
    @Size(max=5)
    @Column(name="ENTRADA5A")
    private String entrada5a;
    @Size(max=5)
    @Column(name="ENTRADA5B")
    private String entrada5b;
    @Size(max=5)
    @Column(name="SAIDA1")
    private String saida1;
    @Size(max=5)
    @Column(name="SAIDA1A")
    private String saida1a;
    @Size(max=5)
    @Column(name="SAIDA1B")
    private String saida1b;
    @Size(max=5)
    @Column(name="SAIDA2")
    private String saida2;
    @Size(max=5)
    @Column(name="SAIDA2A")
    private String saida2a;
    @Size(max=5)
    @Column(name="SAIDA2B")
    private String saida2b;
    @Size(max=5)
    @Column(name="SAIDA3")
    private String saida3;
    @Size(max=5)
    @Column(name="SAIDA3A")
    private String saida3a;
    @Size(max=5)
    @Column(name="SAIDA3B")
    private String saida3b;
    @Size(max=5)
    @Column(name="SAIDA4")
    private String saida4;
    @Size(max=5)
    @Column(name="SAIDA4A")
    private String saida4a;
    @Size(max=5)
    @Column(name="SAIDA4B")
    private String saida4b;
    @Size(max=5)
    @Column(name="SAIDA5")
    private String saida5;
    @Size(max=5)
    @Column(name="SAIDA5A")
    private String saida5a;
    @Size(max=5)
    @Column(name="SAIDA5B")
    private String saida5b;
    @Type(type="BooleanTypeSip")
    @Column(name="PERIODO2")
    private Boolean periodo2;
    @Type(type="BooleanTypeSip")
    @Column(name="PERIODO3")
    private Boolean periodo3;
    @Type(type="BooleanTypeSip")
    @Column(name="PERIODO4")
    private Boolean periodo4;
    @Type(type="BooleanTypeSip")
    @Column(name="PERIODO5")
    private Boolean periodo5;
    @Size(max=5)
    @Column(name="HRNORMAIS")
    private String horasNormais;
    @Size(max=5)
    @Column(name="HORAS_REDUZIDAS")
    private String horasReduzidas;
    @Type(type="BooleanTypeSip")
    @Column(name="HORAS_REDUZIDAS_FERIADOS")
    private Boolean horasReduzidasFeriados;
    @Column(name="DIA_HORAS_REDUZIDAS")
    private Integer diaHoraReduzida;
    @Column(name="SEGUNDO_DIA_HORAS_REDUZIDAS")
    private Integer segundoDiaHoraReduzida;
    @Size(max=5)
    @Column(name="HRDESCANSO")
    private String horasDescanso;
    @Column(name="DIAS_TRABALHADOS")
    private Short diasTrabalhados;
    @Column(name="DIAS_DESCANSO")
    private Short diasDescanso;
    @Type(type="BooleanTypeSip")
    @Column(name="HORA_ATIVIDADE")
    private Boolean horaAtividade;
    @Column(name="HORA_ATIVIDADE_PERIODO")
    private Short horaAtividadePeriodo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="JORNADA", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Jornada jornada;

    public JornadaDia(JornadaDiaPK jornadaDiaPK) {
        this.jornadaDiaPK = jornadaDiaPK;
    }

    public JornadaDia(String entidade, Short jornada, int dia) {
        this.jornadaDiaPK = new JornadaDiaPK(entidade, jornada, dia);
    }

    public JornadaDiaPK getJornadaDiasPK() {
        return this.jornadaDiaPK;
    }

    public void setJornadaDiasPK(JornadaDiaPK jornadaDiaPK) {
        this.jornadaDiaPK = jornadaDiaPK;
    }

    public String getEntrada1a() {
        return this.entrada1a;
    }

    public void setEntrada1a(String entrada1a) {
        this.entrada1a = entrada1a;
    }

    public String getEntrada1() {
        return this.entrada1;
    }

    public void setEntrada1(String entrada1) {
        this.entrada1 = entrada1;
    }

    public String getEntrada1b() {
        return this.entrada1b;
    }

    public void setEntrada1b(String entrada1b) {
        this.entrada1b = entrada1b;
    }

    public String getSaida1a() {
        return this.saida1a;
    }

    public void setSaida1a(String saida1a) {
        this.saida1a = saida1a;
    }

    public String getSaida1() {
        return this.saida1;
    }

    public void setSaida1(String saida1) {
        this.saida1 = saida1;
    }

    public String getSaida1b() {
        return this.saida1b;
    }

    public void setSaida1b(String saida1b) {
        this.saida1b = saida1b;
    }

    public Boolean getPeriodo2() {
        return this.periodo2;
    }

    public void setPeriodo2(Boolean periodo2) {
        if (!periodo2.booleanValue()) {
            this.entrada2b = null;
            this.entrada2a = null;
            this.entrada2 = null;
            this.saida2b = null;
            this.saida2a = null;
            this.saida2 = null;
        }
        this.periodo2 = periodo2;
    }

    public String getEntrada2a() {
        return this.entrada2a;
    }

    public void setEntrada2a(String entrada2a) {
        this.entrada2a = entrada2a;
    }

    public String getEntrada2() {
        return this.entrada2;
    }

    public void setEntrada2(String entrada2) {
        this.entrada2 = entrada2;
    }

    public String getEntrada2b() {
        return this.entrada2b;
    }

    public void setEntrada2b(String entrada2b) {
        this.entrada2b = entrada2b;
    }

    public String getSaida2a() {
        return this.saida2a;
    }

    public void setSaida2a(String saida2a) {
        this.saida2a = saida2a;
    }

    public String getSaida2() {
        return this.saida2;
    }

    public void setSaida2(String saida2) {
        this.saida2 = saida2;
    }

    public String getSaida2b() {
        return this.saida2b;
    }

    public void setSaida2b(String saida2b) {
        this.saida2b = saida2b;
    }

    public String getHorasNormais() {
        return this.horasNormais;
    }

    public void setHorasNormais(String hrnormais) {
        this.horasNormais = hrnormais;
    }

    public String getHorasDescanso() {
        return this.horasDescanso;
    }

    public void setHorasDescanso(String hrdescanso) {
        this.horasDescanso = hrdescanso;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Boolean getHoraAtividade() {
        return this.horaAtividade;
    }

    public void setHoraAtividade(Boolean horaAtividade) {
        this.horaAtividade = horaAtividade;
    }

    public Short getHoraAtividadePeriodo() {
        return this.horaAtividadePeriodo;
    }

    public void setHoraAtividadePeriodo(Short horaAtividadePeriodo) {
        this.horaAtividadePeriodo = horaAtividadePeriodo;
    }

    public Jornada getJornada() {
        return this.jornada;
    }

    public void setJornada(Jornada jornada) {
        if (jornada != null) {
            this.jornadaDiaPK.setJornada(jornada.getJornadaPK().getCodigo());
        } else {
            this.jornadaDiaPK.setJornada(null);
        }
        this.jornada = jornada;
    }

    public Boolean getPeriodo3() {
        return this.periodo3;
    }

    public void setPeriodo3(Boolean periodo3) {
        if (!periodo3.booleanValue()) {
            this.entrada3b = null;
            this.entrada3a = null;
            this.entrada3 = null;
            this.saida3b = null;
            this.saida3a = null;
            this.saida3 = null;
        }
        this.periodo3 = periodo3;
    }

    public String getEntrada3() {
        return this.entrada3;
    }

    public void setEntrada3(String entrada3) {
        this.entrada3 = entrada3;
    }

    public String getEntrada3a() {
        return this.entrada3a;
    }

    public void setEntrada3a(String entrada3a) {
        this.entrada3a = entrada3a;
    }

    public String getEntrada3b() {
        return this.entrada3b;
    }

    public void setEntrada3b(String entrada3b) {
        this.entrada3b = entrada3b;
    }

    public String getSaida3() {
        return this.saida3;
    }

    public void setSaida3(String saida3) {
        this.saida3 = saida3;
    }

    public String getSaida3a() {
        return this.saida3a;
    }

    public void setSaida3a(String saida3a) {
        this.saida3a = saida3a;
    }

    public String getSaida3b() {
        return this.saida3b;
    }

    public void setSaida3b(String saida3b) {
        this.saida3b = saida3b;
    }

    public Short getDiasTrabalhados() {
        return this.diasTrabalhados;
    }

    public void setDiasTrabalhados(Short diasTrabalhados) {
        this.diasTrabalhados = diasTrabalhados;
    }

    public Short getDiasDescanso() {
        return this.diasDescanso;
    }

    public void setDiasDescanso(Short diasDescanso) {
        this.diasDescanso = diasDescanso;
    }

    public String getEntrada4() {
        return this.entrada4;
    }

    public void setEntrada4(String entrada4) {
        this.entrada4 = entrada4;
    }

    public String getEntrada4a() {
        return this.entrada4a;
    }

    public void setEntrada4a(String entrada4a) {
        this.entrada4a = entrada4a;
    }

    public String getEntrada4b() {
        return this.entrada4b;
    }

    public void setEntrada4b(String entrada4b) {
        this.entrada4b = entrada4b;
    }

    public String getEntrada5() {
        return this.entrada5;
    }

    public void setEntrada5(String entrada5) {
        this.entrada5 = entrada5;
    }

    public String getEntrada5a() {
        return this.entrada5a;
    }

    public void setEntrada5a(String entrada5a) {
        this.entrada5a = entrada5a;
    }

    public String getEntrada5b() {
        return this.entrada5b;
    }

    public void setEntrada5b(String entrada5b) {
        this.entrada5b = entrada5b;
    }

    public String getSaida4() {
        return this.saida4;
    }

    public void setSaida4(String saida4) {
        this.saida4 = saida4;
    }

    public String getSaida4a() {
        return this.saida4a;
    }

    public void setSaida4a(String saida4a) {
        this.saida4a = saida4a;
    }

    public String getSaida4b() {
        return this.saida4b;
    }

    public void setSaida4b(String saida4b) {
        this.saida4b = saida4b;
    }

    public String getSaida5() {
        return this.saida5;
    }

    public void setSaida5(String saida5) {
        this.saida5 = saida5;
    }

    public String getSaida5a() {
        return this.saida5a;
    }

    public void setSaida5a(String saida5a) {
        this.saida5a = saida5a;
    }

    public String getSaida5b() {
        return this.saida5b;
    }

    public void setSaida5b(String saida5b) {
        this.saida5b = saida5b;
    }

    public Boolean getPeriodo4() {
        return this.periodo4;
    }

    public void setPeriodo4(Boolean periodo4) {
        if (!periodo4.booleanValue()) {
            this.entrada4b = null;
            this.entrada4a = null;
            this.entrada4 = null;
            this.saida4b = null;
            this.saida4a = null;
            this.saida4 = null;
        }
        this.periodo4 = periodo4;
    }

    public Boolean getPeriodo5() {
        return this.periodo5;
    }

    public void setPeriodo5(Boolean periodo5) {
        if (!periodo5.booleanValue()) {
            this.entrada5b = null;
            this.entrada5a = null;
            this.entrada5 = null;
            this.saida5b = null;
            this.saida5a = null;
            this.saida5 = null;
        }
        this.periodo5 = periodo5;
    }

    public String getLastSaida() {
        return SIPUtil.coalesce((String[])new String[]{this.saida5, this.saida4, this.saida3, this.saida2, this.saida1});
    }

    public String getFirstEntrada() {
        return SIPUtil.coalesce((String[])new String[]{this.entrada1, this.entrada2, this.entrada3, this.entrada4, this.entrada5});
    }

    public LocalTime getLastSaidaLocalTime() {
        for (int i = JornadaDiaMovimento.saidas().length - 1; i >= 0; --i) {
            JornadaDiaMovimento movimento = JornadaDiaMovimento.saidas()[i];
            LocalTime hora = movimento.get(this);
            if (hora == null) continue;
            return hora;
        }
        return null;
    }

    public LocalTime getFirstEntradaLocalTime() {
        for (JornadaDiaMovimento movimento : JornadaDiaMovimento.entradas()) {
            LocalTime time = movimento.get(this);
            if (time == null) continue;
            return time;
        }
        return null;
    }

    public Duration getDurationOfJornada() {
        DateTime saida;
        DateTime entrada = DateTime.now().withTime(this.getFirstEntradaLocalTime());
        if (entrada.isAfter((ReadableInstant)(saida = entrada.withTime(this.getLastSaidaLocalTime())))) {
            saida = saida.plusDays(1);
        }
        return new Interval((ReadableInstant)entrada, (ReadableInstant)saida).toDuration();
    }

    public JornadaDia withDiaDaSemana(JornadaDiaSemana diaDaSemana) {
        JornadaDia novaJorandaDia = new JornadaDia(this.jornadaDiaPK.getEntidade(), this.jornadaDiaPK.getJornada(), diaDaSemana.getCodigo());
        novaJorandaDia.entrada1 = this.entrada1;
        novaJorandaDia.entrada1a = this.entrada1a;
        novaJorandaDia.entrada1b = this.entrada1b;
        novaJorandaDia.entrada2 = this.entrada2;
        novaJorandaDia.entrada2a = this.entrada2a;
        novaJorandaDia.entrada2b = this.entrada2b;
        novaJorandaDia.entrada3 = this.entrada3;
        novaJorandaDia.entrada3a = this.entrada3a;
        novaJorandaDia.entrada3b = this.entrada3b;
        novaJorandaDia.entrada4 = this.entrada4;
        novaJorandaDia.entrada4a = this.entrada4a;
        novaJorandaDia.entrada4b = this.entrada4b;
        novaJorandaDia.entrada5 = this.entrada5;
        novaJorandaDia.entrada5a = this.entrada5a;
        novaJorandaDia.entrada5b = this.entrada5b;
        novaJorandaDia.saida1 = this.saida1;
        novaJorandaDia.saida1a = this.saida1a;
        novaJorandaDia.saida1b = this.saida1b;
        novaJorandaDia.saida2 = this.saida2;
        novaJorandaDia.saida2a = this.saida2a;
        novaJorandaDia.saida2b = this.saida2b;
        novaJorandaDia.saida3 = this.saida3;
        novaJorandaDia.saida3a = this.saida3a;
        novaJorandaDia.saida3b = this.saida3b;
        novaJorandaDia.saida4 = this.saida4;
        novaJorandaDia.saida4a = this.saida4a;
        novaJorandaDia.saida4b = this.saida4b;
        novaJorandaDia.saida5 = this.saida5;
        novaJorandaDia.saida5a = this.saida5a;
        novaJorandaDia.saida5b = this.saida5b;
        novaJorandaDia.diasDescanso = this.diasDescanso;
        novaJorandaDia.diasTrabalhados = this.diasTrabalhados;
        novaJorandaDia.horasDescanso = this.horasDescanso;
        novaJorandaDia.horasNormais = this.horasNormais;
        novaJorandaDia.periodo2 = this.periodo2;
        novaJorandaDia.periodo3 = this.periodo3;
        novaJorandaDia.periodo4 = this.periodo4;
        novaJorandaDia.periodo5 = this.periodo4;
        return novaJorandaDia;
    }

    public Duration getTotalHorasDeNormais() {
        DateTime dataHoraUltimaSaida;
        String primeiraEntrada = this.entrada1;
        String ultimaSaida = SIPUtil.coalesce((String[])new String[]{this.saida5, this.saida4, this.saida3, this.saida2, this.saida1});
        DateTime dataHoraPrimeiraEntrada = TimeUtils.toDateTime((Date)new Date(), (String)primeiraEntrada);
        if (dataHoraPrimeiraEntrada.isAfter((ReadableInstant)(dataHoraUltimaSaida = TimeUtils.toDateTime((Date)new Date(), (String)ultimaSaida)))) {
            dataHoraUltimaSaida = dataHoraUltimaSaida.plusDays(1);
        }
        Interval interval = new Interval((ReadableInstant)dataHoraPrimeiraEntrada, (ReadableInstant)dataHoraUltimaSaida);
        return interval.toDuration();
    }

    public JornadaDiaSemana getDiaDaSemana() {
        return this.jornadaDiaPK.getDia();
    }

    public List<Interval> getIntervalsBetweenHorarios(Date dataBase) {
        DateTime dataTimeBase = new DateTime((Object)dataBase);
        LinkedList<Interval> intervals = new LinkedList<Interval>();
        if (this.periodo2.booleanValue()) {
            intervals.add(this.getInterval(dataTimeBase, this.saida1, this.entrada2));
        }
        if (this.periodo3.booleanValue()) {
            intervals.add(this.getInterval(dataTimeBase, this.saida2, this.entrada3));
        }
        if (this.periodo4.booleanValue()) {
            intervals.add(this.getInterval(dataTimeBase, this.saida3, this.entrada4));
        }
        if (this.periodo5.booleanValue()) {
            intervals.add(this.getInterval(dataTimeBase, this.saida4, this.entrada5));
        }
        return intervals;
    }

    private Interval getInterval(DateTime dataTimeBase, String saida, String entrada) {
        LocalTime saidaTime = TimeUtils.toLocalTime((String)saida);
        LocalTime entradaTime = TimeUtils.toLocalTime((String)entrada);
        Interval interval = new Interval((ReadableInstant)dataTimeBase.withTime(saidaTime), (ReadableInstant)dataTimeBase.withTime(entradaTime));
        return interval;
    }

    public String getHorariosLiteral() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.defaultHorario(this.getEntrada1())).append(" \u00e0s ").append(this.defaultHorario(this.getSaida1()));
        if (this.getPeriodo2().booleanValue()) {
            sb.append(" - ").append(this.defaultHorario(this.getEntrada2())).append(" \u00e0s ").append(this.defaultHorario(this.getSaida2()));
        }
        if (this.getPeriodo3().booleanValue()) {
            sb.append(" - ").append(this.defaultHorario(this.getEntrada3())).append(" \u00e0s ").append(this.defaultHorario(this.getSaida3()));
        }
        if (this.getPeriodo4().booleanValue()) {
            sb.append(" - ").append(this.defaultHorario(this.getEntrada4())).append(" \u00e0s ").append(this.defaultHorario(this.getSaida4()));
        }
        if (this.getPeriodo5().booleanValue()) {
            sb.append(" - ").append(this.defaultHorario(this.getEntrada5())).append(" \u00e0s ").append(this.defaultHorario(this.getSaida5()));
        }
        return sb.toString();
    }

    private String defaultHorario(String horario) {
        if (horario == null) {
            return "(VAZIO)";
        }
        return horario;
    }

    public String getHorasReduzidas() {
        return this.horasReduzidas;
    }

    public void setHorasReduzidas(String horasReduzidas) {
        this.horasReduzidas = horasReduzidas;
    }

    public Boolean getHorasReduzidasFeriados() {
        return this.horasReduzidasFeriados;
    }

    public void setHorasReduzidasFeriados(Boolean horasReduzidasFeriados) {
        this.horasReduzidasFeriados = horasReduzidasFeriados;
    }

    public Integer getDiaHoraReduzida() {
        return this.diaHoraReduzida;
    }

    public void setDiaHoraReduzida(Integer diaHoraReduzida) {
        this.diaHoraReduzida = diaHoraReduzida;
    }

    public Integer getSegundoDiaHoraReduzida() {
        return this.segundoDiaHoraReduzida;
    }

    public void setSegundoDiaHoraReduzida(Integer segundoDiaHoraReduzida) {
        this.segundoDiaHoraReduzida = segundoDiaHoraReduzida;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.jornadaDiaPK != null ? this.jornadaDiaPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JornadaDia)) {
            return false;
        }
        JornadaDia other = (JornadaDia)object;
        return (this.jornadaDiaPK != null || other.jornadaDiaPK == null) && (this.jornadaDiaPK == null || this.jornadaDiaPK.equals(other.jornadaDiaPK));
    }

    public String toString() {
        return "entity.JornadaDias[ jornadaDiasPK=" + this.jornadaDiaPK + " ]";
    }

    public JornadaDia() {
    }
}

