/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.JornadaEventual;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Table(name="JORNADA_EVENTUAL_COLETIVA")
@Entity
@FilterConfigType(autoFilter=true)
@Audited
public class JornadaColetiva
implements Serializable,
GenericEntity,
Filterable {
    private static final long serialVersionUID = 1L;
    public static final String GET_NEXT_ITEM = "SELECT COALESCE(MAX(j.codigo), 0) + 1 FROM JornadaColetiva j WHERE j.entidadeCodigo = :entidadeCodigo";
    public static final String FIND_FOR_FILTER = "SELECT j FROM JornadaColetiva j where (concat(j.codigo) LIKE concat('%', :param, '%')) AND j.entidadeCodigo = :entidadeCodigo";
    @FilterConfig(label="C\u00f3digo", inputType=FilterInputType.NUMBER)
    @Id
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=512)
    @Column(name="DESCRICAO")
    private String descricao;
    @FilterConfig(label="C\u00f3digo da Jornada", inputType=FilterInputType.NUMBER)
    @NotNull
    @Column(name="JORNADA")
    private Short jornadaCodigo;
    @NotNull
    @Column(name="EMPRESA")
    @Size(min=1, max=3)
    private String entidadeCodigo;
    @Column(name="DATA_INCLUSAO")
    @Temporal(value=TemporalType.DATE)
    private Date dataInclusao;
    @FilterConfig(label="Data Inicio", inputType=FilterInputType.CALENDAR)
    @Column(name="DATA_INICIAL")
    @Temporal(value=TemporalType.DATE)
    private Date dataInicial;
    @FilterConfig(label="Data Final", inputType=FilterInputType.CALENDAR)
    @Column(name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    private Date dataFinal;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @FilterConfig(label="Nome da Jornada", inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="JORNADA", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Jornada jornada;
    @Column(name="USUARIO")
    private Integer usuarioCodigo;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="USUARIO", insertable=false, updatable=false)
    private Usuario usuario;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="jornadaColetiva", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<JornadaEventual> jornadasEventuais = new ArrayList<JornadaEventual>();

    public JornadaColetiva() {
    }

    public JornadaColetiva(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Short getJornadaCodigo() {
        return this.jornadaCodigo;
    }

    public void setJornadaCodigo(Short jornadaCodigo) {
        this.jornadaCodigo = jornadaCodigo;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public Date getDataInclusao() {
        return this.dataInclusao;
    }

    public void setDataInclusao(Date dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    public Jornada getJornada() {
        return this.jornada;
    }

    public void setJornada(Jornada jornada) {
        if (jornada == null) {
            this.jornadaCodigo = null;
            this.entidadeCodigo = null;
        } else {
            this.jornadaCodigo = jornada.getJornadaPK().getCodigo();
            this.entidadeCodigo = jornada.getJornadaPK().getEntidade();
        }
        this.jornada = jornada;
    }

    public Integer getUsuarioCodigo() {
        return this.usuarioCodigo;
    }

    public void setUsuarioCodigo(Integer usuarioCodigo) {
        this.usuarioCodigo = usuarioCodigo;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
        this.usuarioCodigo = usuario == null ? null : this.usuario.getCodigo();
    }

    public List<JornadaEventual> getJornadasEventuais() {
        return this.jornadasEventuais;
    }

    public void setJornadasEventuais(List<JornadaEventual> jornadasEventuais) {
        this.jornadasEventuais = jornadasEventuais;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JornadaColetiva that = (JornadaColetiva)o;
        return this.codigo != null ? this.codigo.equals(that.codigo) : that.codigo == null;
    }

    public int hashCode() {
        return this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public String toString() {
        return "JornadaColetiva{codigo='" + this.codigo + '\'' + '}';
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.hashCode());
    }

    public String getItemId() {
        return String.valueOf(this.getCodigo());
    }

    public String getItemLabel() {
        return String.valueOf(this.getCodigo());
    }

    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }
}

