/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="JORNADA_ALTERNADA")
@FilterConfigType(autoFilter=true)
@Audited
public class JornadaAlternada
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_JORNADA_ALTERNADA";
    @Id
    @NotNull
    @Column(name="ID")
    private Integer id;
    @NotNull
    @Column(name="EMPRESA")
    @Size(min=1, max=3)
    private String entidadeCodigo;
    @FilterConfig(label="Registro", inputType=FilterInputType.NUMBER)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @FilterConfig(label="C\u00f3digo da Jornada", inputType=FilterInputType.NUMBER)
    @NotNull
    @Column(name="JORNADA")
    private Short jornadaCodigo;
    @FilterConfig(label="Per. In\u00edcio", inputType=FilterInputType.NUMBER)
    @NotNull
    @Column(name="DIA_INICIO")
    private Short diaInicio;
    @FilterConfig(label="Per. Fim", inputType=FilterInputType.NUMBER)
    @NotNull
    @Column(name="DIA_TERMINO")
    private Short diaTermino;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @FilterConfig(label="Nome do Trabalhador", inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @FilterConfig(label="Nome da Jornada", inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="JORNADA", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Jornada jornada;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Short getJornadaCodigo() {
        return this.jornadaCodigo;
    }

    public void setJornadaCodigo(Short jornadaCodigo) {
        this.jornadaCodigo = jornadaCodigo;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        if (trabalhador == null) {
            this.entidadeCodigo = null;
            this.registro = null;
        } else {
            this.entidadeCodigo = trabalhador.getTrabalhadorPK().getEntidade();
            this.registro = trabalhador.getTrabalhadorPK().getRegistro();
        }
        this.trabalhador = trabalhador;
    }

    public Jornada getJornada() {
        return this.jornada;
    }

    public void setJornada(Jornada jornada) {
        this.jornadaCodigo = jornada == null ? null : jornada.getJornadaPK().getCodigo();
        this.jornada = jornada;
    }

    public Short getDiaInicio() {
        return this.diaInicio;
    }

    public void setDiaInicio(Short diaInicio) {
        this.diaInicio = diaInicio;
    }

    public Short getDiaTermino() {
        return this.diaTermino;
    }

    public void setDiaTermino(Short diaTermino) {
        this.diaTermino = diaTermino;
    }

    public String toString() {
        return "JornadaAlternada [id=" + this.id + ", entidadeCodigo=" + this.entidadeCodigo + ", registro=" + this.registro + ", jornadaCodigo=" + this.jornadaCodigo + ", diaInicio=" + this.diaInicio + ", diaTermino=" + this.diaTermino + ", trabalhador=" + this.trabalhador + ", jornada=" + this.jornada + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.diaInicio == null ? 0 : this.diaInicio.hashCode());
        result = 31 * result + (this.diaTermino == null ? 0 : this.diaTermino.hashCode());
        result = 31 * result + (this.entidadeCodigo == null ? 0 : this.entidadeCodigo.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.jornada == null ? 0 : this.jornada.hashCode());
        result = 31 * result + (this.jornadaCodigo == null ? 0 : this.jornadaCodigo.hashCode());
        result = 31 * result + (this.registro == null ? 0 : this.registro.hashCode());
        result = 31 * result + (this.trabalhador == null ? 0 : this.trabalhador.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JornadaAlternada other = (JornadaAlternada)obj;
        if (this.diaInicio == null ? other.diaInicio != null : !this.diaInicio.equals(other.diaInicio)) {
            return false;
        }
        if (this.diaTermino == null ? other.diaTermino != null : !this.diaTermino.equals(other.diaTermino)) {
            return false;
        }
        if (this.entidadeCodigo == null ? other.entidadeCodigo != null : !this.entidadeCodigo.equals(other.entidadeCodigo)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.jornada == null ? other.jornada != null : !this.jornada.equals(other.jornada)) {
            return false;
        }
        if (this.jornadaCodigo == null ? other.jornadaCodigo != null : !this.jornadaCodigo.equals(other.jornadaCodigo)) {
            return false;
        }
        if (this.registro == null ? other.registro != null : !this.registro.equals(other.registro)) {
            return false;
        }
        return !(this.trabalhador == null ? other.trabalhador != null : !this.trabalhador.equals(other.trabalhador));
    }
}

