/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.api.SearchNome;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.JornadaDia;
import br.com.fiorilli.sip.persistence.entity.JornadaDiaDSR;
import br.com.fiorilli.sip.persistence.entity.JornadaDiaSemana;
import br.com.fiorilli.sip.persistence.entity.JornadaPK;
import br.com.fiorilli.sip.persistence.entity.JornadaTipoLimiteDia;
import br.com.fiorilli.sip.persistence.entity.ParametroFalta;
import br.com.fiorilli.sip.persistence.entity.ParametroHoraExtra;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Type;

@FilterConfigType(autoFilter=true)
@Entity
@Table(name="JORNADA")
@Audited
public class Jornada
implements Serializable,
GenericEntity,
Filterable {
    public static final String FIND_FOR_FILTER = "SELECT j FROM Jornada j where j.jornadaPK.entidade = :entidadeCodigo \tand ((\t\t((length(cast(:param as text)) <= 3)) and (cast(j.jornadaPK.codigo as text) = cast(:param as text)))\t\tor ((length(cast(:param as text)) > 3) and \t\t   ((concat(j.jornadaPK.codigo, j.nome) LIKE concat('%', cast(:param as text), '%')) \t\t   or (concat('#', j.apelido) LIKE concat(cast(:param as text), '%')))\t\t))";
    public static final String EXISTS_BY_PK = "SELECT CASE WHEN COALESCE(COUNT(j.jornadaPK.codigo), 0) > 0 THEN TRUE ELSE FALSE END FROM Jornada j WHERE j.jornadaPK = :pk";
    public static final String GET_JORNADA_AND_DIAS = "SELECT j FROM Jornada j LEFT JOIN FETCH j.jornadasDias WHERE j.jornadaPK.entidade = :entidade AND j.jornadaPK.codigo = :codigo";
    public static final String FIND_FOR_REPLICATE_HORA_EXTRA = "SELECT j.jornadaPK.codigo FROM Jornada j WHERE j.jornadaPK.entidade = :entidadeCodigo AND j.jornadaPK.codigo NOT IN (SELECT p.jornadaCodigo FROM ParametroHoraExtra p WHERE p.entidadeCodigo = :entidadeCodigo   AND p.vinculoCodigo = :vinculoCodigo   AND p.eventoCodigo = :eventoCodigo)";
    public static final String FIND_FOR_REPLICATE_FALTA = "SELECT j.jornadaPK.codigo FROM Jornada j WHERE j.jornadaPK.entidade = :entidadeCodigo AND j.jornadaPK.codigo NOT IN (SELECT p.jornadaCodigo FROM ParametroFalta p WHERE p.entidadeCodigo = j.jornadaPK.entidade   AND p.vinculoCodigo = :vinculoCodigo   AND p.eventoHorasCodigo = :eventoHorasCodigo   AND p.eventoDiasCodigo = :eventoDiasCodigo) ";
    public static final String FIND_FOR_REPLICATE_VALE_ALIMENTACAO = "SELECT j.jornadaPK.codigo FROM Jornada j WHERE j.jornadaPK.entidade = :entidadeCodigo AND j.jornadaPK.codigo NOT IN (SELECT p.jornadaCodigo FROM ParametroValeAlimentacao p WHERE p.entidadeCodigo = j.jornadaPK.entidade   AND p.vinculoCodigo = :vinculoCodigo   AND p.eventoCodigo = :eventoCodigo) ";
    public static final String FIND_BY_REGISTRO = "SELECT jo FROM Trabalhador tr LEFT JOIN tr.jornada jo LEFT JOIN FETCH jo.jornadasDias WHERE tr.trabalhadorPK.entidade = :entidadeCodigo   AND tr.trabalhadorPK.registro = :registro";
    public static final String FIND_BY_ENTIDADE_TO_WS = "SELECT new br.com.fiorilli.sipweb.vo.ws.JornadaMinWsVo(j.jornadaPK.codigo, j.nome)FROM Jornada j WHERE j.jornadaPK.entidade = :entidade ";
    public static final String FIND_BY_PK_TO_WS = "SELECT new br.com.fiorilli.sipweb.vo.ws.JornadaWsVo(j) FROM Jornada j WHERE j.jornadaPK = :pk";
    public static final String GET_NEXT_CODIGO = "SELECT COALESCE(MAX(j.jornadaPK.codigo), 0) + 1 FROM Jornada j WHERE j.jornadaPK.entidade = :entidadeCodigo ";
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected JornadaPK jornadaPK;
    @SearchNome
    @FilterConfig(label="Nome", order=2, condition=FilterCondition.CONTENHA)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Type(type="BooleanTypeSip")
    @Column(name="ENTRADA1_AUTOMATICA")
    private Boolean entrada1Automatica;
    @Type(type="BooleanTypeSip")
    @Column(name="ENTRADA2_AUTOMATICA")
    private Boolean entrada2Automatica;
    @Type(type="BooleanTypeSip")
    @Column(name="ENTRADA3_AUTOMATICA")
    private Boolean entrada3Automatica;
    @Type(type="BooleanTypeSip")
    @Column(name="ENTRADA4_AUTOMATICA")
    private Boolean entrada4Automatica;
    @Type(type="BooleanTypeSip")
    @Column(name="ENTRADA5_AUTOMATICA")
    private Boolean entrada5Automatica;
    @Type(type="BooleanTypeSip")
    @Column(name="SAIDA1_AUTOMATICA")
    private Boolean saida1Automatica;
    @Type(type="BooleanTypeSip")
    @Column(name="SAIDA2_AUTOMATICA")
    private Boolean saida2Automatica;
    @Type(type="BooleanTypeSip")
    @Column(name="SAIDA3_AUTOMATICA")
    private Boolean saida3Automatica;
    @Type(type="BooleanTypeSip")
    @Column(name="SAIDA4_AUTOMATICA")
    private Boolean saida4Automatica;
    @Type(type="BooleanTypeSip")
    @Column(name="SAIDA5_AUTOMATICA")
    private Boolean saida5Automatica;
    @Type(type="BooleanTypeSip")
    @Column(name="ENCAIXARBATIDAS")
    private Boolean encaixarBatidas;
    @Type(type="BooleanTypeSip")
    @Column(name="IGNORAR_INTERVALOS")
    private Boolean ignorarIntervalos;
    @Enumerated
    @Column(name="TIPO_LIMITE_DIA")
    private JornadaTipoLimiteDia tipoLimiteDia;
    @Size(max=5)
    @Column(name="HORA_LIMITE_DIA")
    private String horaLimiteDia;
    @Type(type="BooleanTypeSip")
    @Column(name="JORNADA_LIVRE")
    private Boolean jornadaLivre;
    @Size(max=5)
    @Column(name="LIMITE_DIARIO")
    private String limiteDiarioFalta;
    @Size(max=5)
    @Column(name="HRCOMPENSACAO")
    private String toleranciaCompensacao;
    @Column(name="ESOCIAL_VIGENCIA_INI")
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date eSocialDataVigenciaInicial;
    @Column(name="ESOCIAL_VIGENCIA_FIM")
    @Temporal(value=TemporalType.DATE)
    private Date eSocialDataVigenciaFinal;
    @Size(max=5)
    @Column(name="APELIDO", unique=true)
    private String apelido;
    @FilterConfigJoin(fetch=true, type=FilterJoinType.LEFT)
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="jornada", fetch=FetchType.LAZY, orphanRemoval=true)
    private List<JornadaDia> jornadasDias;
    @OneToMany(mappedBy="jornada", fetch=FetchType.LAZY)
    private List<ParametroHoraExtra> parametrosHoraExtra;
    @OneToMany(mappedBy="jornada", fetch=FetchType.LAZY)
    private List<ParametroFalta> parametrosFalta;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Entidade entidade;
    @Type(type="BooleanTypeSip")
    @Column(name="JORNADA_GENERICA")
    private Boolean generica;
    @Size(max=5)
    @Column(name="HORA_TRABALHADA_MAXIMA")
    private String horaTrabalhadaMaxima;
    @Size(max=5)
    @Column(name="PERIODO_INICIO")
    private String periodoInicio;
    @Size(max=5)
    @Column(name="PERIODO_FIM")
    private String periodoFim;
    @Type(type="BooleanTypeSip")
    @Column(name="IGNORAR_FERIADOS")
    private Boolean ignorarFeriados;
    @Type(type="BooleanTypeSip")
    @Column(name="IGNORAR_PONTOS_FACULTATIVOS")
    private Boolean ignorarPontosFacultativos;
    @Type(type="BooleanTypeSip")
    @Column(name="IGNORAR_TOLERANCIA_FALTAS")
    private Boolean ignorarToleranciaFaltas;
    @Type(type="BooleanTypeSip")
    @Column(name="DESC_DIA_ATRASO")
    private Boolean descontarODiaTodo;
    @Type(type="BooleanTypeSip")
    @Column(name="DESC_UMTERCO")
    private Boolean descontarUmTerco;
    @Type(type="BooleanTypeSip")
    @Column(name="DESC_DOISTERCOS")
    private Boolean descontarDoisTerco;
    @Type(type="BooleanTypeSip")
    @Column(name="HORAS_COMPENSADAS")
    private Boolean horasCompensadas;
    @Type(type="BooleanTypeSip")
    @Column(name="HORA_FECHAMENTO_DIA")
    private Boolean horaFechamentoDia;
    @Size(max=5)
    @Column(name="HORA_FECHAMENTO")
    private String horaFechamento;
    @Column(name="DH_ALTERACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraAlteracao;
    @Column(name="STATUS_ESOCIAL")
    private Integer statusEsocial;
    @Column(name="TP_JORNADA")
    private Integer tpJornada;
    @Size(max=30)
    @Column(name="CODIGO_ESOCIAL")
    private String codigoEsocial;
    @Type(type="BooleanTypeSip")
    @Column(name="APURAR_HORA_EXTRA_DIA")
    private Boolean apurarHoraExtraDia;
    @Type(type="BooleanTypeSip")
    @Column(name="INTERVALO_JORNADA_FIXA")
    private Boolean intervaloJornadaFixa;
    @Size(max=5)
    @Column(name="LIMITE_DIARIO_HE")
    private String limiteDiarioHoraExtra;
    @Type(type="BooleanTypeSip")
    @Column(name="INTERVALO_LIVRE_FALTA")
    private Boolean intervaloLivreFalta;
    @Column(name="COD_HOR_REP")
    private Integer codHorRep;
    @Basic(optional=false)
    @NotNull
    @Column(name="DIA_SEMANA_DSR")
    private Short diaSemanaDSR;
    @Size(max=5)
    @Column(name="INTERVALO_MINIMO_HE")
    private String intervaloMinimoHoraExtra;

    public Jornada() {
        this.jornadaPK = new JornadaPK();
        this.jornadasDias = new ArrayList<JornadaDia>();
        this.eSocialDataVigenciaInicial = new Date();
    }

    public Jornada(JornadaPK jornadaPK) {
        this.jornadaPK = jornadaPK;
    }

    public Jornada(String entidade, short codigo) {
        this.jornadaPK = new JornadaPK(entidade, codigo);
    }

    public boolean addJornadaDia(JornadaDia e) {
        return this.jornadasDias.add(e);
    }

    public boolean removeJornadaDia(JornadaDia o) {
        return this.jornadasDias.remove(o);
    }

    public JornadaPK getJornadaPK() {
        return this.jornadaPK;
    }

    public void setJornadaPK(JornadaPK jornadaPK) {
        this.jornadaPK = jornadaPK;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Boolean getEntrada1Automatica() {
        return this.entrada1Automatica;
    }

    public void setEntrada1Automatica(Boolean entrada1Automatica) {
        this.entrada1Automatica = entrada1Automatica;
    }

    public Boolean getSaida1Automatica() {
        return this.saida1Automatica;
    }

    public void setSaida1Automatica(Boolean saida1Automatica) {
        this.saida1Automatica = saida1Automatica;
    }

    public Boolean getEntrada2Automatica() {
        return this.entrada2Automatica;
    }

    public void setEntrada2Automatica(Boolean entrada2Automatica) {
        this.entrada2Automatica = entrada2Automatica;
    }

    public Boolean getSaida2Automatica() {
        return this.saida2Automatica;
    }

    public void setSaida2Automatica(Boolean saida2Automatica) {
        this.saida2Automatica = saida2Automatica;
    }

    public Boolean getEncaixarBatidas() {
        return this.encaixarBatidas;
    }

    public void setEncaixarBatidas(Boolean encaixarbatidas) {
        this.encaixarBatidas = encaixarbatidas;
    }

    public Boolean getJornadaLivre() {
        return this.jornadaLivre;
    }

    public void setJornadaLivre(Boolean jornadaLivre) {
        this.jornadaLivre = jornadaLivre;
    }

    public List<JornadaDia> getJornadasDias() {
        return this.jornadasDias;
    }

    public void setJornadasDias(List<JornadaDia> jornadasDias) {
        this.jornadasDias = jornadasDias;
    }

    public Boolean getSaida3Automatica() {
        return this.saida3Automatica;
    }

    public void setSaida3Automatica(Boolean saida3Automatica) {
        this.saida3Automatica = saida3Automatica;
    }

    public Boolean getEntrada3Automatica() {
        return this.entrada3Automatica;
    }

    public void setEntrada3Automatica(Boolean entrada3Automatica) {
        this.entrada3Automatica = entrada3Automatica;
    }

    public String getLimiteDiarioFalta() {
        return this.limiteDiarioFalta;
    }

    public void setLimiteDiarioFalta(String limiteDiarioFalta) {
        this.limiteDiarioFalta = limiteDiarioFalta;
    }

    public List<ParametroHoraExtra> getParametrosHoraExtra() {
        return this.parametrosHoraExtra;
    }

    public void setParametrosHoraExtra(List<ParametroHoraExtra> parametrosHoraExtra) {
        this.parametrosHoraExtra = parametrosHoraExtra;
    }

    public List<ParametroFalta> getParametrosFalta() {
        return this.parametrosFalta;
    }

    public void setParametrosFalta(List<ParametroFalta> parametrosFalta) {
        this.parametrosFalta = parametrosFalta;
    }

    public Boolean getEntrada4Automatica() {
        return this.entrada4Automatica;
    }

    public void setEntrada4Automatica(Boolean entrada4Automatica) {
        this.entrada4Automatica = entrada4Automatica;
    }

    public Boolean getEntrada5Automatica() {
        return this.entrada5Automatica;
    }

    public void setEntrada5Automatica(Boolean entrada5Automatica) {
        this.entrada5Automatica = entrada5Automatica;
    }

    public Boolean getSaida4Automatica() {
        return this.saida4Automatica;
    }

    public void setSaida4Automatica(Boolean saida4Automatica) {
        this.saida4Automatica = saida4Automatica;
    }

    public Boolean getSaida5Automatica() {
        return this.saida5Automatica;
    }

    public void setSaida5Automatica(Boolean saida5Automatica) {
        this.saida5Automatica = saida5Automatica;
    }

    public String getToleranciaCompensacao() {
        return this.toleranciaCompensacao;
    }

    public void setToleranciaCompensacao(String toleranciaCompensacao) {
        this.toleranciaCompensacao = toleranciaCompensacao;
    }

    public Date geteSocialDataVigenciaInicial() {
        return this.eSocialDataVigenciaInicial;
    }

    public void seteSocialDataVigenciaInicial(Date eSocialDataVigenciaInicial) {
        this.eSocialDataVigenciaInicial = eSocialDataVigenciaInicial;
    }

    public Date geteSocialDataVigenciaFinal() {
        return this.eSocialDataVigenciaFinal;
    }

    public void seteSocialDataVigenciaFinal(Date eSocialDataVigenciaFinal) {
        this.eSocialDataVigenciaFinal = eSocialDataVigenciaFinal;
    }

    public JornadaTipoLimiteDia getTipoLimiteDia() {
        return this.tipoLimiteDia;
    }

    public void setTipoLimiteDia(JornadaTipoLimiteDia tipoLimiteDia) {
        this.tipoLimiteDia = tipoLimiteDia;
    }

    public String getHoraLimiteDia() {
        return this.horaLimiteDia;
    }

    public void setHoraLimiteDia(String horaLimiteDia) {
        this.horaLimiteDia = StringUtils.isNotBlank((CharSequence)StringUtils.replace((String)horaLimiteDia, (String)":", (String)"")) ? horaLimiteDia : null;
    }

    public boolean isTipoLimiteDiaNenhum() {
        return this.tipoLimiteDia == null || this.tipoLimiteDia == JornadaTipoLimiteDia.NENHUM_LIMITE;
    }

    public JornadaDiaDSR getDiaSemanaDSR() {
        return this.diaSemanaDSR != null ? JornadaDiaDSR.get(this.diaSemanaDSR.intValue()) : JornadaDiaDSR.DOMINGO;
    }

    public void setDiaSemanaDSR(JornadaDiaDSR diaSemanaDSR) {
        this.diaSemanaDSR = diaSemanaDSR == null ? Short.valueOf(JornadaDiaDSR.DOMINGO.getCodigo().shortValue()) : Short.valueOf(diaSemanaDSR.getCodigo().shortValue());
    }

    public String getIntervaloMinimoHoraExtra() {
        return this.intervaloMinimoHoraExtra;
    }

    public void setIntervaloMinimoHoraExtra(String intervaloMinimoHoraExtra) {
        this.intervaloMinimoHoraExtra = intervaloMinimoHoraExtra;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Jornada jornada = (Jornada)o;
        return Objects.equals(this.jornadaPK, jornada.jornadaPK);
    }

    public int hashCode() {
        return Objects.hash(this.jornadaPK);
    }

    public String toString() {
        return "Jornada{jornadaPK=" + this.jornadaPK + ", nome='" + this.nome + '\'' + '}';
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.hashCode());
    }

    public String getItemId() {
        return String.valueOf(this.jornadaPK.getCodigo());
    }

    public String getItemLabel() {
        return this.nome;
    }

    public Boolean getIgnorarIntervalos() {
        return this.ignorarIntervalos;
    }

    public void setIgnorarIntervalos(Boolean ignorarIntervalos) {
        this.ignorarIntervalos = ignorarIntervalos;
    }

    public JornadaDia getJornadaDiaByDate(Date data) {
        JornadaDiaSemana diaSemana = JornadaDiaSemana.getByDate(data);
        for (JornadaDia jornadasDia : this.jornadasDias) {
            if (jornadasDia.jornadaDiaPK.getDia() != diaSemana) continue;
            return jornadasDia;
        }
        return null;
    }

    public String getApelido() {
        return this.apelido;
    }

    public void setApelido(String apelido) {
        this.apelido = apelido;
    }

    public Boolean getGenerica() {
        return this.generica;
    }

    public void setGenerica(Boolean generica) {
        this.generica = generica;
    }

    public String getHoraTrabalhadaMaxima() {
        return this.horaTrabalhadaMaxima;
    }

    public void setHoraTrabalhadaMaxima(String horaTrabalhadaMaxima) {
        this.horaTrabalhadaMaxima = horaTrabalhadaMaxima;
    }

    public String getPeriodoInicio() {
        return this.periodoInicio;
    }

    public void setPeriodoInicio(String periodoInicio) {
        this.periodoInicio = periodoInicio;
    }

    public String getPeriodoFim() {
        return this.periodoFim;
    }

    public void setPeriodoFim(String periodoFim) {
        this.periodoFim = periodoFim;
    }

    public Boolean getIgnorarFeriados() {
        return this.ignorarFeriados;
    }

    public void setIgnorarFeriados(Boolean ignorarFeriados) {
        this.ignorarFeriados = ignorarFeriados;
    }

    public Boolean getIgnorarPontosFacultativos() {
        return this.ignorarPontosFacultativos;
    }

    public void setIgnorarPontosFacultativos(Boolean ignorarPontosFacultativos) {
        this.ignorarPontosFacultativos = ignorarPontosFacultativos;
    }

    public Boolean getIgnorarToleranciaFaltas() {
        return this.ignorarToleranciaFaltas;
    }

    public void setIgnorarToleranciaFaltas(Boolean ignorarToleranciaFaltas) {
        this.ignorarToleranciaFaltas = ignorarToleranciaFaltas;
    }

    public Boolean getDescontarODiaTodo() {
        return this.descontarODiaTodo;
    }

    public void setDescontarODiaTodo(Boolean descontarODiaTodo) {
        this.descontarODiaTodo = descontarODiaTodo;
    }

    public Boolean getDescontarUmTerco() {
        return this.descontarUmTerco;
    }

    public void setDescontarUmTerco(Boolean descontarUmterco) {
        this.descontarUmTerco = descontarUmterco;
    }

    public Boolean getDescontarDoisTerco() {
        return this.descontarDoisTerco;
    }

    public void setDescontarDoisTerco(Boolean descontarDoisTerco) {
        this.descontarDoisTerco = descontarDoisTerco;
    }

    public Boolean getHorasCompensadas() {
        return this.horasCompensadas;
    }

    public void setHorasCompensadas(Boolean horasCompensadas) {
        this.horasCompensadas = horasCompensadas;
    }

    public Boolean getHoraFechamentoDia() {
        return this.horaFechamentoDia;
    }

    public void setHoraFechamentoDia(Boolean horaFechamentoDia) {
        this.horaFechamentoDia = horaFechamentoDia;
    }

    public String getHoraFechamento() {
        return this.horaFechamento;
    }

    public void setHoraFechamento(String horaFechamento) {
        this.horaFechamento = horaFechamento;
    }

    public Integer getStatusEsocial() {
        return this.statusEsocial;
    }

    public void setStatusEsocial(Integer statusEsocial) {
        this.statusEsocial = statusEsocial;
    }

    public Integer getTpJornada() {
        return this.tpJornada;
    }

    public void setTpJornada(Integer tpJornada) {
        this.tpJornada = tpJornada;
    }

    public String getCodigoEsocial() {
        return this.codigoEsocial;
    }

    public void setCodigoEsocial(String codigoEsocial) {
        this.codigoEsocial = codigoEsocial;
    }

    public Boolean getApurarHoraExtraDia() {
        return this.apurarHoraExtraDia;
    }

    public void setApurarHoraExtraDia(Boolean apurarHoraExtraDia) {
        this.apurarHoraExtraDia = apurarHoraExtraDia;
    }

    public Boolean getIntervaloJornadaFixa() {
        return this.intervaloJornadaFixa;
    }

    public void setIntervaloJornadaFixa(Boolean intervaloJornadaFixa) {
        this.intervaloJornadaFixa = intervaloJornadaFixa;
    }

    public String getLimiteDiarioHoraExtra() {
        return this.limiteDiarioHoraExtra;
    }

    public void setLimiteDiarioHoraExtra(String limiteDiarioHoraExtra) {
        this.limiteDiarioHoraExtra = limiteDiarioHoraExtra;
    }

    public Boolean getIntervaloLivreFalta() {
        return this.intervaloLivreFalta;
    }

    public void setIntervaloLivreFalta(Boolean intervaloLivreFalta) {
        this.intervaloLivreFalta = intervaloLivreFalta;
    }

    public Integer getCodHorRep() {
        return this.codHorRep;
    }

    public void setCodHorRep(Integer codHorRep) {
        this.codHorRep = codHorRep;
    }
}

