/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.DocumentoDigital;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorCargo;
import br.com.fiorilli.sip.persistence.entity.MovimentoSefip;
import br.com.fiorilli.sip.persistence.entity.Pessoa;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="INTEGRACAO_AUDESP")
@Audited
public class IntegracaoAudesp
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENARATOR = "GEN_INTEGRACAO_ENVIO";
    @Id
    @Column(unique=true, nullable=false)
    private int id;
    @Column(name="TIMESTAMP_ENVIO", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraEnvio;
    @Column(name="MES", nullable=false, length=2)
    private String mes;
    @Column(name="ANO", nullable=false, length=4)
    private String ano;
    @Column(name="USUARIO_ID", nullable=false, length=2)
    private Integer usuarioId;
    @JoinColumn(name="USUARIO_ID", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuario;
    @ManyToMany
    @JoinTable(name="AUDESP_ATO_NORMATIVO", joinColumns={@JoinColumn(name="ID_ENVIO_AUDESP")}, inverseJoinColumns={@JoinColumn(name="ID_DOCDIGITAL")})
    private List<DocumentoDigital> documentoDigitalList;
    @ManyToMany
    @JoinTable(name="AUDESP_CARGO", joinColumns={@JoinColumn(name="ID_ENVIO_AUDESP")}, inverseJoinColumns={@JoinColumn(name="ID_CARGO", referencedColumnName="ID")})
    private List<Cargo> cargoList;
    @ManyToMany
    @JoinTable(name="AUDESP_PESSOA", joinColumns={@JoinColumn(name="ID_ENVIO_AUDESP")}, inverseJoinColumns={@JoinColumn(name="CPF")})
    private List<Pessoa> pessoaList;
    @ManyToMany
    @JoinTable(name="AUDESP_HISTTRABCARGO", joinColumns={@JoinColumn(name="ID_ENVIO_AUDESP")}, inverseJoinColumns={@JoinColumn(name="ID_HISTTRABCARGO")})
    private List<HistoricoTrabalhadorCargo> historicoTrabalhadorCargoList;
    @ManyToMany
    @JoinTable(name="AUDESP_MOVTOSEFIP", joinColumns={@JoinColumn(name="ID_ENVIO_AUDESP")}, inverseJoinColumns={@JoinColumn(name="ID_MOVTOSEFIP")})
    private List<MovimentoSefip> movimentoSefipList;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getDataHoraEnvio() {
        return this.dataHoraEnvio;
    }

    public void setDataHoraEnvio(Date timestampEnvio) {
        this.dataHoraEnvio = timestampEnvio;
    }

    public Integer getUsuarioId() {
        return this.usuarioId;
    }

    public void setUsuarioId(Integer usuarioId) {
        this.usuarioId = usuarioId;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuarioId = usuario != null ? usuario.getCodigo() : null;
        this.usuario = usuario;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegracaoAudesp other = (IntegracaoAudesp)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "IntegracaoAudesp [id=" + this.id + "]";
    }

    public String getMes() {
        return this.mes;
    }

    public void setMes(String mes) {
        this.mes = mes;
    }

    public String getAno() {
        return this.ano;
    }

    public void setAno(String ano) {
        this.ano = ano;
    }

    public List<DocumentoDigital> getDocumentoDigitalList() {
        if (this.documentoDigitalList == null) {
            this.documentoDigitalList = new ArrayList<DocumentoDigital>();
        }
        return this.documentoDigitalList;
    }

    public void addDocumentoDigital(DocumentoDigital documento) {
        List<DocumentoDigital> list = this.getDocumentoDigitalList();
        if (!list.contains(documento)) {
            list.add(documento);
        }
    }

    public List<Cargo> getCargoList() {
        if (this.cargoList == null) {
            this.cargoList = new ArrayList<Cargo>();
        }
        return this.cargoList;
    }

    public void setCargoList(List<Cargo> cargolList) {
        this.cargoList = cargolList;
    }

    public List<Pessoa> getPessoaList() {
        if (this.pessoaList == null) {
            this.pessoaList = new ArrayList<Pessoa>();
        }
        return this.pessoaList;
    }

    public void addCargo(Cargo cargo) {
        List<Cargo> cargoList = this.getCargoList();
        if (!cargoList.contains(cargo)) {
            cargoList.add(cargo);
        }
    }

    public void addPessoa(Pessoa pessoa) {
        List<Pessoa> pessoaList = this.getPessoaList();
        if (!pessoaList.contains(pessoa)) {
            pessoaList.add(pessoa);
        }
    }

    public void setPessoaList(List<Pessoa> pessoaList) {
        this.pessoaList = pessoaList;
    }

    public List<HistoricoTrabalhadorCargo> getHistoricoTrabalhadorCargoList() {
        if (this.historicoTrabalhadorCargoList == null) {
            this.historicoTrabalhadorCargoList = new ArrayList<HistoricoTrabalhadorCargo>();
        }
        return this.historicoTrabalhadorCargoList;
    }

    public void setHistoricoTrabalhadorCargoList(List<HistoricoTrabalhadorCargo> historicoTrabalhadorCargoList) {
        this.historicoTrabalhadorCargoList = historicoTrabalhadorCargoList;
    }

    public List<MovimentoSefip> getMovimentoSefipList() {
        if (this.movimentoSefipList == null) {
            this.movimentoSefipList = new ArrayList<MovimentoSefip>();
        }
        return this.movimentoSefipList;
    }

    public void setMovimentoSefipList(List<MovimentoSefip> movimentoSefipList) {
        this.movimentoSefipList = movimentoSefipList;
    }
}

