/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.api.SearchCodigo;
import br.com.fiorilli.sip.persistence.api.SearchNome;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.AtividadeCargo;
import br.com.fiorilli.sip.persistence.entity.InstrucaoRais;
import br.gov.sp.tce.persistence.entity.Escolaridade;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="INSTRUCAO")
@Audited
public class Instrucao
implements Serializable,
GenericEntity,
Filterable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_FOR_FILTER = "SELECT i FROM Instrucao i WHERE UPPER(i.nome) LIKE UPPER('%'||:param||'%') ORDER BY i.nome";
    public static final String FIND_ALL = "SELECT i FROM Instrucao i ORDER BY i.nome";
    @SearchCodigo
    @FilterConfig(label="C\u00f3digo", inputType=FilterInputType.NUMBER)
    @Id
    @NotNull
    @Size(min=1, max=2)
    @Column(name="CODIGO")
    private String codigo;
    @SearchNome
    @FilterConfig(label="Nome", condition=FilterCondition.COMECE)
    @Size(max=150)
    @Column(name="NOME")
    private String nome;
    @Basic(optional=false)
    @NotNull
    @Column(name="RAIS")
    private String rais;
    @Column(name="CODIGO_AUDESP")
    private Integer codigoAudesp;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="instrucao", fetch=FetchType.LAZY)
    private List<AtividadeCargo> atividadesCargo;

    public Instrucao() {
    }

    public Instrucao(String codigo) {
        this.codigo = codigo;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public List<AtividadeCargo> getAtividadesCargo() {
        return this.atividadesCargo;
    }

    public void setAtividadesCargo(List<AtividadeCargo> atividadesCargo) {
        this.atividadesCargo = atividadesCargo;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Instrucao)) {
            return false;
        }
        Instrucao other = (Instrucao)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.Instrucao[ codigo=" + this.codigo + " ]";
    }

    @Override
    public String getHashId() {
        return this.codigo;
    }

    public InstrucaoRais getRais() {
        return InstrucaoRais.of(this.rais);
    }

    public void setRais(InstrucaoRais rais) {
        this.rais = rais != null ? rais.getCodigo() : null;
    }

    public String getItemId() {
        return this.codigo;
    }

    public String getItemLabel() {
        return this.nome;
    }

    public Escolaridade getCodigoAudesp() {
        return Escolaridade.of(this.codigoAudesp);
    }

    public void setCodigoAudesp(Escolaridade escolariedade) {
        this.codigoAudesp = escolariedade == null ? null : Integer.valueOf(escolariedade.getId());
    }
}

