/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.api.SearchEntidade;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.Epi;
import br.com.fiorilli.sip.persistence.entity.IdentificadorTipo;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="INSTITUICAO_ENSINO")
@Audited
public class InstituicaoEnsino
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_INSTITUICAO_ENSINO";
    @FilterConfig(label="C\u00f3digo", inputType=FilterInputType.NUMBER)
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="ID")
    private Integer codigo;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Entidade entidade1;
    @SearchEntidade
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @Size(max=18)
    @Column(name="IDENTIFICADOR")
    private String identificador;
    @FilterConfig(label="Nome", condition=FilterCondition.COMECE)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Embedded
    private Endereco endereco;
    @Size(max=60)
    @Column(name="CONTATO")
    private String contato;
    @Size(max=11)
    @Column(name="TELEFONE")
    private String telefone;
    @Size(max=60)
    @Column(name="EMAIL")
    private String email;
    @Size(max=30)
    @Column(name="CONVENIO")
    private String convenio;

    @PostLoad
    public void postLoad() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
    }

    public InstituicaoEnsino() {
    }

    public InstituicaoEnsino(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Entidade getEntidade1() {
        return this.entidade1;
    }

    public void setEntidade1(Entidade entidade1) {
        this.entidade1 = entidade1;
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String empresa) {
        this.entidadeCodigo = empresa;
    }

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Endereco getEndereco() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public String getContato() {
        return this.contato;
    }

    public void setContato(String contato) {
        this.contato = contato;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public static String getGenerator() {
        return GENERATOR;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getConvenio() {
        return this.convenio;
    }

    public void setConvenio(String convenio) {
        this.convenio = convenio;
    }

    public IdentificadorTipo getTipoIdentificador() {
        return IdentificadorTipo.getCnpj();
    }

    public String toString() {
        return "entity.InstituicaoEnsino[ codigo=" + this.codigo + " ]";
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Epi)) {
            return false;
        }
        InstituicaoEnsino other = (InstituicaoEnsino)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }
}

