/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

public enum IdentificadorTipo {
    CPF("0", "999.999.999-99"),
    CNPJ("1", "99.999.999/9999-99"),
    CEI("2", "999.999.9999/99");

    private final String codigo;
    private final String mascara;

    private IdentificadorTipo(String codigo, String mascara) {
        this.codigo = codigo;
        this.mascara = mascara;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public static final IdentificadorTipo get(String codigo) {
        if (CNPJ.getCodigo().equals(codigo)) {
            return CNPJ;
        }
        if (CEI.getCodigo().equals(codigo)) {
            return CEI;
        }
        return CPF;
    }

    public static final IdentificadorTipo getCnpj() {
        return CNPJ;
    }

    public boolean isCPF() {
        return CPF.equals((Object)this);
    }

    public boolean isCEI() {
        return CEI.equals((Object)this);
    }

    public String getMascara() {
        return this.mascara;
    }
}

