/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Vaga;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="HISTORICO_VAGA")
@Audited
public class HistoricoVaga
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_VAGA = "SELECT h FROM HistoricoVaga h LEFT JOIN FETCH h.vaga v LEFT JOIN FETCH v.documentoCriacao.tipolegalCriacao tc LEFT JOIN FETCH v.documentoExtincao.tipolegalExtincao te LEFT JOIN FETCH h.trabalhador t WHERE h.idVaga = :id ";
    @NotNull
    @Id
    @Size(max=10)
    @Column(name="ID")
    private Integer id;
    @Column(name="DH_TRANSF")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraTranferencia;
    @NotNull
    @Size(max=6)
    @Column(name="ID_VAGA")
    private Integer idVaga;
    @JoinColumn(name="ID_VAGA", referencedColumnName="ID", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Vaga vaga;
    @NotNull
    @Size(max=6)
    @Column(name="REGISTRO")
    private String registro;
    @NotNull
    @Size(max=3)
    @Column(name="EMPRESA")
    private String entidade;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Trabalhador trabalhador;

    public HistoricoVaga() {
    }

    public HistoricoVaga(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getDataHoraTranferencia() {
        return this.dataHoraTranferencia;
    }

    public void setDataHoraTranferencia(Date dataHoraTranferencia) {
        this.dataHoraTranferencia = dataHoraTranferencia;
    }

    public Integer getIdVaga() {
        return this.idVaga;
    }

    public void setIdVaga(Integer idVaga) {
        this.idVaga = idVaga;
    }

    public Vaga getVaga() {
        if (this.vaga == null) {
            this.vaga = new Vaga();
        }
        return this.vaga;
    }

    public void setVaga(Vaga vaga) {
        this.vaga = vaga;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HistoricoVaga other = (HistoricoVaga)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "HistoricoVaga [id=" + this.id + "]";
    }
}

