/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorUnidadePK;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Entity
@Table(name="HISTTRAB_UNIDADE")
@Audited
public class HistoricoTrabalhadorUnidade
implements Serializable,
Documento {
    public static final String FIND_BY_TRABALHADOR = "SELECT h FROM HistoricoTrabalhadorUnidade h JOIN FETCH h.trabalhador JOIN FETCH h.unidadeAtual LEFT JOIN FETCH h.tipoLegal LEFT JOIN FETCH h.unidadeAnterior WHERE h.trabalhador.trabalhadorPK = :trabalhadorPK";
    public static final String FIND_BY_TRABALHADOR_TO_WS = "SELECT new br.com.fiorilli.sipweb.vo.ws.historico.trabalhador.HistoricoTrabUnidadeWsVo(h.tipoLegal.codigo, h.tipoLegal.nome, h.numeroDocumento, h.dataDocumento, h.observacao, h.unidadeAtual.departamentoDespesa, h.unidadeAtual.nome) FROM HistoricoTrabalhadorUnidade h WHERE h.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY h.dataHoraInclusao, h.historicoTrabalhadorUnidadePK.item ";
    public static final String GET_NEXT_ITEM = "select coalesce(max(h.historicoTrabalhadorUnidadePK.item), 0) + 1 from HistoricoTrabalhadorUnidade h where h.trabalhador.trabalhadorPK = :trabalhadorPK order by h.dataHoraInclusao desc";
    public static final String FIND_LAST_BY_TRABALHADOR = "SELECT h.historicoTrabalhadorUnidadePK FROM HistoricoTrabalhadorUnidade h WHERE h.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY h.dataHoraInclusao DESC";
    public static final String IS_RATEADO = "SELECT CASE WHEN en.opcoesGerais.rateio = 'S' AND tr.ratear = 'S' THEN true ELSE false END FROM Trabalhador tr JOIN tr.entidade en WHERE tr.trabalhadorPK = :trabalhadorPK";
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected HistoricoTrabalhadorUnidadePK historicoTrabalhadorUnidadePK;
    @Column(name="DHTRANSF")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraTransferencia;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numeroDocumento;
    @Column(name="DHINCLUSAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraInclusao;
    @Column(name="DHALTERACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraAlteracao;
    @Lob
    @Size(max=0x7FFFFFFF)
    @Column(name="OBS")
    private String observacao;
    @JoinColumn(name="USUARIO_INCLUSAO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioInclusao;
    @JoinColumn(name="USUARIO_ALTERACAO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioAlteracao;
    @Column(name="ANTERIOR")
    private Integer unidadeAnteriorCodigo;
    @JoinColumn(name="ANTERIOR", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Unidade unidadeAnterior;
    @JoinColumn(name="UNIDADE", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Unidade unidadeAtual;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;

    public HistoricoTrabalhadorUnidade() {
    }

    public HistoricoTrabalhadorUnidade(HistoricoTrabalhadorUnidadePK histtrabUnidadePK) {
        this.historicoTrabalhadorUnidadePK = histtrabUnidadePK;
    }

    public HistoricoTrabalhadorUnidade(String entidade, String registro, int unidade, short item) {
        this.historicoTrabalhadorUnidadePK = new HistoricoTrabalhadorUnidadePK(entidade, registro, unidade, item);
    }

    public HistoricoTrabalhadorUnidadePK getHistoricoTrabalhadorUnidadePK() {
        return this.historicoTrabalhadorUnidadePK;
    }

    public void setHistoricoTrabalhadorUnidadePK(HistoricoTrabalhadorUnidadePK histtrabUnidadePK) {
        this.historicoTrabalhadorUnidadePK = histtrabUnidadePK;
    }

    public Date getDataHoraTransferencia() {
        return this.dataHoraTransferencia;
    }

    public void setDataHoraTransferencia(Date dhtransf) {
        this.dataHoraTransferencia = dhtransf;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date datadoc) {
        this.dataDocumento = datadoc;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String numdoc) {
        this.numeroDocumento = numdoc;
    }

    public Date getDataHoraInclusao() {
        return this.dataHoraInclusao;
    }

    public void setDataHoraInclusao(Date dhinclusao) {
        this.dataHoraInclusao = dhinclusao;
    }

    public Date getDataHoraAlteracao() {
        return this.dataHoraAlteracao;
    }

    public void setDataHoraAlteracao(Date dhalteracao) {
        this.dataHoraAlteracao = dhalteracao;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public Usuario getUsuarioInclusao() {
        return this.usuarioInclusao;
    }

    public void setUsuarioInclusao(Usuario usuarioInclusao) {
        this.usuarioInclusao = usuarioInclusao;
    }

    public Usuario getUsuarioAlteracao() {
        return this.usuarioAlteracao;
    }

    public void setUsuarioAlteracao(Usuario usuarioAlteracao) {
        this.usuarioAlteracao = usuarioAlteracao;
    }

    public Unidade getUnidadeAnterior() {
        return this.unidadeAnterior;
    }

    public void setUnidadeAnterior(Unidade unidadeAnterior) {
        this.unidadeAnterior = unidadeAnterior;
        if (unidadeAnterior != null) {
            this.unidadeAnteriorCodigo = unidadeAnterior.getCodigo();
        } else {
            unidadeAnterior = null;
        }
    }

    public Unidade getUnidadeAtual() {
        return this.unidadeAtual;
    }

    public void setUnidadeAtual(Unidade unidade) {
        this.unidadeAtual = unidade;
        if (this.unidadeAtual != null) {
            this.historicoTrabalhadorUnidadePK.setUnidade(this.unidadeAtual.getCodigo());
        } else {
            this.historicoTrabalhadorUnidadePK.setUnidade(null);
        }
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        if (trabalhador != null) {
            this.getHistoricoTrabalhadorUnidadePK().setEntidade(trabalhador.getTrabalhadorPK().getEntidade());
            this.getHistoricoTrabalhadorUnidadePK().setRegistro(trabalhador.getTrabalhadorPK().getRegistro());
        } else {
            this.getHistoricoTrabalhadorUnidadePK().setEntidade(null);
            this.getHistoricoTrabalhadorUnidadePK().setRegistro(null);
        }
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal tipolegal) {
        this.tipoLegal = tipolegal;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.historicoTrabalhadorUnidadePK != null ? this.historicoTrabalhadorUnidadePK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HistoricoTrabalhadorUnidade)) {
            return false;
        }
        HistoricoTrabalhadorUnidade other = (HistoricoTrabalhadorUnidade)object;
        return (this.historicoTrabalhadorUnidadePK != null || other.historicoTrabalhadorUnidadePK == null) && (this.historicoTrabalhadorUnidadePK == null || this.historicoTrabalhadorUnidadePK.equals(other.historicoTrabalhadorUnidadePK));
    }

    public String toString() {
        return "entity.HisttrabUnidade[ histtrabUnidadePK=" + this.historicoTrabalhadorUnidadePK + " ]";
    }

    public Integer getUnidadeAnteriorCodigo() {
        return this.unidadeAnteriorCodigo;
    }

    public void setUnidadeAnteriorCodigo(Integer unidadeAnteriorCodigo) {
        this.unidadeAnteriorCodigo = unidadeAnteriorCodigo;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegal != null ? this.tipoLegal.getCodigo() : null;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.getDataDocumento();
    }

    @Override
    public void setData(Date value) {
        this.setDataDocumento(value);
    }
}

