/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorSubdivisaoPK;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Entity
@Table(name="HISTTRAB_SUBDIVISAO")
@Audited
public class HistoricoTrabalhadorSubdivisao
implements Serializable,
Documento {
    public static final String FIND_BY_TRABALHADOR = "SELECT h FROM HistoricoTrabalhadorSubdivisao h JOIN FETCH h.trabalhador JOIN FETCH h.subdivisao LEFT JOIN FETCH h.tipoLegal LEFT JOIN FETCH h.subdivisaoAnterior WHERE h.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY h.historicoTrabalhadorSubdivisaoPK.item";
    public static final String FIND_BY_TRABALHADOR_TO_WS = "SELECT new br.com.fiorilli.sipweb.vo.ws.historico.trabalhador.HistoricoTrabSubdivisaoWsVo(h.tipoLegal.codigo, h.tipoLegal.nome, h.numeroDocumento, h.dataDocumento, h.observacao, h.subdivisao.subdivisaoPK.codigo, h.subdivisao.nome) FROM HistoricoTrabalhadorSubdivisao h WHERE h.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY h.dataHoraInclusao, h.historicoTrabalhadorSubdivisaoPK.item";
    public static final String GET_NEXT_ITEM = "select coalesce(max(h.historicoTrabalhadorSubdivisaoPK.item), 0) + 1 from HistoricoTrabalhadorSubdivisao h where h.trabalhador.trabalhadorPK = :trabalhadorPK order by h.dataHoraInclusao desc";
    public static final String FIND_LAST_BY_TRABALHADOR = "select h.historicoTrabalhadorSubdivisaoPK from HistoricoTrabalhadorSubdivisao h where h.trabalhador.trabalhadorPK = :trabalhadorPK order by h.dataHoraInclusao desc";
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected HistoricoTrabalhadorSubdivisaoPK historicoTrabalhadorSubdivisaoPK;
    @Column(name="DHTRANSF")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraTransferencia;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numeroDocumento;
    @Column(name="DHINCLUSAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraInclusao;
    @Column(name="DHALTERACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraAlteracao;
    @Lob
    @Size(max=0x7FFFFFFF)
    @Column(name="OBS")
    private String observacao;
    @JoinColumn(name="USUARIO_INCLUSAO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioInclusao;
    @JoinColumn(name="USUARIO_ALTERACAO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioAlteracao;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @Size(min=1, max=6)
    @Column(name="ANTERIOR")
    private String subdivisaoAnteriorCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="ANTERIOR", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Subdivisao subdivisaoAnterior;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="SUBDIVISAO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Subdivisao subdivisao;
    @Column(name="DTLOTACAO_AUDESP")
    @Temporal(value=TemporalType.DATE)
    private Date dataLotacaoAudesp;

    public HistoricoTrabalhadorSubdivisao() {
    }

    public HistoricoTrabalhadorSubdivisao(HistoricoTrabalhadorSubdivisaoPK histtrabSubdivisaoPK) {
        this.historicoTrabalhadorSubdivisaoPK = histtrabSubdivisaoPK;
    }

    public HistoricoTrabalhadorSubdivisao(String entidade, String registro, String subdivisao, short item) {
        this.historicoTrabalhadorSubdivisaoPK = new HistoricoTrabalhadorSubdivisaoPK(entidade, registro, subdivisao, item);
    }

    public HistoricoTrabalhadorSubdivisaoPK getHistoricoTrabalhadorSubdivisaoPK() {
        return this.historicoTrabalhadorSubdivisaoPK;
    }

    public void setHistoricoTrabalhadorSubdivisaoPK(HistoricoTrabalhadorSubdivisaoPK histtrabSubdivisaoPK) {
        this.historicoTrabalhadorSubdivisaoPK = histtrabSubdivisaoPK;
    }

    public Date getDataHoraTransferencia() {
        return this.dataHoraTransferencia;
    }

    public void setDataHoraTransferencia(Date dhtransf) {
        this.dataHoraTransferencia = dhtransf;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date datadoc) {
        this.dataDocumento = datadoc;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String numdoc) {
        this.numeroDocumento = numdoc;
    }

    public Date getDataHoraInclusao() {
        return this.dataHoraInclusao;
    }

    public void setDataHoraInclusao(Date dhinclusao) {
        this.dataHoraInclusao = dhinclusao;
    }

    public Date getDataHoraAlteracao() {
        return this.dataHoraAlteracao;
    }

    public void setDataHoraAlteracao(Date dhalteracao) {
        this.dataHoraAlteracao = dhalteracao;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public Usuario getUsuarioInclusao() {
        return this.usuarioInclusao;
    }

    public void setUsuarioInclusao(Usuario usuarioInclusao) {
        this.usuarioInclusao = usuarioInclusao;
    }

    public Usuario getUsuarioAlteracao() {
        return this.usuarioAlteracao;
    }

    public void setUsuarioAlteracao(Usuario usuarioAlteracao) {
        this.usuarioAlteracao = usuarioAlteracao;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        if (trabalhador != null) {
            this.getHistoricoTrabalhadorSubdivisaoPK().setEntidade(trabalhador.getTrabalhadorPK().getEntidade());
            this.getHistoricoTrabalhadorSubdivisaoPK().setRegistro(trabalhador.getTrabalhadorPK().getRegistro());
        } else {
            this.getHistoricoTrabalhadorSubdivisaoPK().setEntidade(null);
            this.getHistoricoTrabalhadorSubdivisaoPK().setRegistro(null);
        }
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    public void setTipolegal(TipoDocumentoLegal tipoLegal) {
        this.tipoLegal = tipoLegal;
    }

    public Subdivisao getSubdivisaoAnterior() {
        return this.subdivisaoAnterior;
    }

    public void setSubdivisaoAnterior(Subdivisao subdivisaoAnterior) {
        this.subdivisaoAnterior = subdivisaoAnterior;
        this.subdivisaoAnteriorCodigo = subdivisaoAnterior != null ? subdivisaoAnterior.getCodigo() : null;
    }

    public Subdivisao getSubdivisao() {
        return this.subdivisao;
    }

    public void setSubdivisao(Subdivisao subdivisao) {
        this.subdivisao = subdivisao;
        if (subdivisao != null) {
            this.historicoTrabalhadorSubdivisaoPK.setSubdivisao(subdivisao.getCodigo());
        } else {
            this.historicoTrabalhadorSubdivisaoPK.setSubdivisao(null);
        }
    }

    public Date getDataLotacaoAudesp() {
        return this.dataLotacaoAudesp;
    }

    public void setDataLotacaoAudesp(Date dataLotacaoAudesp) {
        this.dataLotacaoAudesp = dataLotacaoAudesp;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.historicoTrabalhadorSubdivisaoPK != null ? this.historicoTrabalhadorSubdivisaoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HistoricoTrabalhadorSubdivisao)) {
            return false;
        }
        HistoricoTrabalhadorSubdivisao other = (HistoricoTrabalhadorSubdivisao)object;
        return (this.historicoTrabalhadorSubdivisaoPK != null || other.historicoTrabalhadorSubdivisaoPK == null) && (this.historicoTrabalhadorSubdivisaoPK == null || this.historicoTrabalhadorSubdivisaoPK.equals(other.historicoTrabalhadorSubdivisaoPK));
    }

    public String toString() {
        return "entity.HisttrabSubdivisao[ histtrabSubdivisaoPK=" + this.historicoTrabalhadorSubdivisaoPK + " ]";
    }

    public String getSubdivisaoAnteriorCodigo() {
        return this.subdivisaoAnteriorCodigo;
    }

    public void setSubdivisaoAnteriorCodigo(String subdivisaoAnteriorCodigo) {
        this.subdivisaoAnteriorCodigo = subdivisaoAnteriorCodigo;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegal != null ? this.tipoLegal.getCodigo() : null;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.getDataDocumento();
    }

    @Override
    public void setData(Date value) {
        this.setDataDocumento(value);
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal value) {
        this.setTipolegal(value);
    }
}

