/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorSalarioInicialPK;
import br.com.fiorilli.sip.persistence.entity.Salario;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Entity
@Table(name="HISTTRAB_SALARIO_INICIAL")
@Audited
public class HistoricoTrabalhadorSalarioInicial
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_TRABALHADOR_TO_WS = "SELECT new br.com.fiorilli.sipweb.vo.ws.historico.trabalhador.HistoricoTrabSalarioWsVo(h.tipoLegal.codigo, h.tipoLegal.nome, h.numeroDocumento, h.dataDocumento, h.observacao, h.salario.salarioPK.codigo, h.salario.nome, h.salario.valor) FROM HistoricoTrabalhadorSalarioInicial h WHERE h.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY h.dataHoraInclusao, h.historicoTrabalhadorSalarioInicialPK.item";
    @EmbeddedId
    protected HistoricoTrabalhadorSalarioInicialPK historicoTrabalhadorSalarioInicialPK;
    @Column(name="DHTRANSF")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraTransferencia;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numeroDocumento;
    @Column(name="DHINCLUSAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraInclusao;
    @Column(name="DHALTERACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraAlteracao;
    @Lob
    @Size(max=0x7FFFFFFF)
    @Column(name="OBS")
    private String observacao;
    @Size(min=1, max=10)
    @Column(name="ANTERIOR")
    private String salarioAnteriorCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="ANTERIOR", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Salario salarioAnterior;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REFSAL", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Salario salario;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @JoinColumn(name="USUARIO_INCLUSAO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioInclusao;
    @JoinColumn(name="USUARIO_ALTERACAO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioAlteracao;

    public HistoricoTrabalhadorSalarioInicialPK getHistoricoTrabalhadorSalarioInicialPK() {
        return this.historicoTrabalhadorSalarioInicialPK;
    }

    public void setHistoricoTrabalhadorSalarioInicialPK(HistoricoTrabalhadorSalarioInicialPK historicoTrabalhadorSalarioInicialPK) {
        this.historicoTrabalhadorSalarioInicialPK = historicoTrabalhadorSalarioInicialPK;
    }

    public Date getDataHoraTransferencia() {
        return this.dataHoraTransferencia;
    }

    public void setDataHoraTransferencia(Date dataHoraTransferencia) {
        this.dataHoraTransferencia = dataHoraTransferencia;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date dataDocumento) {
        this.dataDocumento = dataDocumento;
    }

    public void setTipoLegalCodigo(Integer tipoLegalCodigo) {
        this.tipoLegalCodigo = tipoLegalCodigo;
    }

    public Date getDataHoraInclusao() {
        return this.dataHoraInclusao;
    }

    public void setDataHoraInclusao(Date dataHoraInclusao) {
        this.dataHoraInclusao = dataHoraInclusao;
    }

    public Date getDataHoraAlteracao() {
        return this.dataHoraAlteracao;
    }

    public void setDataHoraAlteracao(Date dataHoraAlteracao) {
        this.dataHoraAlteracao = dataHoraAlteracao;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public String getSalarioAnteriorCodigo() {
        return this.salarioAnteriorCodigo;
    }

    public void setSalarioAnteriorCodigo(String salarioAnteriorCodigo) {
        this.salarioAnteriorCodigo = salarioAnteriorCodigo;
    }

    public Salario getSalarioAnterior() {
        return this.salarioAnterior;
    }

    public void setSalarioAnterior(Salario salarioAnterior) {
        this.salarioAnterior = salarioAnterior;
    }

    public Salario getSalario() {
        return this.salario;
    }

    public void setSalario(Salario salario) {
        this.salario = salario;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public Usuario getUsuarioInclusao() {
        return this.usuarioInclusao;
    }

    public void setUsuarioInclusao(Usuario usuarioInclusao) {
        this.usuarioInclusao = usuarioInclusao;
    }

    public Usuario getUsuarioAlteracao() {
        return this.usuarioAlteracao;
    }

    public void setUsuarioAlteracao(Usuario usuarioAlteracao) {
        this.usuarioAlteracao = usuarioAlteracao;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal value) {
        this.tipoLegal = value;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String value) {
        this.numeroDocumento = value;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.dataDocumento;
    }

    @Override
    public void setData(Date value) {
        this.dataDocumento = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricoTrabalhadorSalarioInicial that = (HistoricoTrabalhadorSalarioInicial)o;
        return Objects.equals(this.historicoTrabalhadorSalarioInicialPK, that.historicoTrabalhadorSalarioInicialPK);
    }

    public int hashCode() {
        return Objects.hash(this.historicoTrabalhadorSalarioInicialPK);
    }
}

