/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorSalarioPK;
import br.com.fiorilli.sip.persistence.entity.Salario;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="HISTTRAB_SALARIO")
@Audited
public class HistoricoTrabalhadorSalario
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_TRABALHADOR = "SELECT h FROM HistoricoTrabalhadorSalario h JOIN FETCH h.trabalhador JOIN FETCH h.salario LEFT JOIN FETCH h.tipoLegal LEFT JOIN FETCH h.evento LEFT JOIN FETCH h.salarioAnterior WHERE h.trabalhador.trabalhadorPK = :trabalhadorPK order by h.dataHoraInclusao desc";
    public static final String FIND_BY_TRABALHADOR_TO_WS = "SELECT new br.com.fiorilli.sipweb.vo.ws.historico.trabalhador.HistoricoTrabSalarioWsVo(h.tipoLegal.codigo, h.tipoLegal.nome, h.numeroDocumento, h.dataDocumento, h.observacao, h.salario.salarioPK.codigo, h.salario.nome, h.salario.valor) FROM HistoricoTrabalhadorSalario h WHERE h.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY h.dataHoraInclusao, h.historicoTrabalhadorSalarioPK.item";
    public static final String GET_NEXT_ITEM = "select coalesce(max(h.historicoTrabalhadorSalarioPK.item), 0) + 1 from HistoricoTrabalhadorSalario h where h.trabalhador.trabalhadorPK = :trabalhadorPK ";
    public static final String FIND_LAST_BY_TRABALHADOR = "select h.historicoTrabalhadorSalarioPK from HistoricoTrabalhadorSalario h where h.trabalhador.trabalhadorPK = :trabalhadorPK order by h.dataHoraInclusao desc";
    public static final String FIND_BY_DATA_TERMINO = "SELECT h FROM HistoricoTrabalhadorSalario h where h.dataFinalVigencia < :hoje and ((h.retornoAutomaticoExecutado = false) or (h.retornoAutomaticoExecutado is null))";
    @EmbeddedId
    protected HistoricoTrabalhadorSalarioPK historicoTrabalhadorSalarioPK;
    @Column(name="DHTRANSF")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraTransferencia;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numeroDocumento;
    @Column(name="DHINCLUSAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraInclusao;
    @Column(name="DHALTERACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraAlteracao;
    @Column(name="DATAINICIO_VIGENCIA")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataInicioVigencia;
    @Column(name="DATAFINAL_VIGENCIA")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataFinalVigencia;
    @Lob
    @Size(max=0x7FFFFFFF)
    @Column(name="OBS")
    private String observacao;
    @JoinColumn(name="USUARIO_INCLUSAO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioInclusao;
    @JoinColumn(name="USUARIO_ALTERACAO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioAlteracao;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @Size(min=1, max=10)
    @Column(name="ANTERIOR")
    private String salarioAnteriorCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="ANTERIOR", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Salario salarioAnterior;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REFSAL", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Salario salario;
    @Type(type="BooleanTypeSip")
    @Column(name="RETORNO_AUTOMATICO_EXECUTADO")
    private Boolean retornoAutomaticoExecutado;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento evento;
    @Size(min=1, max=3)
    @Column(name="EVENTO")
    private String eventoCodigo;

    public HistoricoTrabalhadorSalario() {
        this.historicoTrabalhadorSalarioPK = new HistoricoTrabalhadorSalarioPK();
    }

    public HistoricoTrabalhadorSalario(HistoricoTrabalhadorSalarioPK histtrabSalarioPK) {
        this.historicoTrabalhadorSalarioPK = histtrabSalarioPK;
    }

    public HistoricoTrabalhadorSalario(String entidade, String registro, String refsal, short item) {
        this.historicoTrabalhadorSalarioPK = new HistoricoTrabalhadorSalarioPK(entidade, registro, refsal, item);
    }

    public HistoricoTrabalhadorSalarioPK getHistoricoTrabalhadorSalarioPK() {
        return this.historicoTrabalhadorSalarioPK;
    }

    public void setHistoricoTrabalhadorSalarioPK(HistoricoTrabalhadorSalarioPK historicoTrabalhadorSalarioPK) {
        this.historicoTrabalhadorSalarioPK = historicoTrabalhadorSalarioPK;
    }

    public Date getDataHoraTransferencia() {
        return this.dataHoraTransferencia;
    }

    public void setDataHoraTransferencia(Date dhtransf) {
        this.dataHoraTransferencia = dhtransf;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date datadoc) {
        this.dataDocumento = datadoc;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String numdoc) {
        this.numeroDocumento = numdoc;
    }

    public Date getDataHoraInclusao() {
        return this.dataHoraInclusao;
    }

    public void setDataHoraInclusao(Date dhinclusao) {
        this.dataHoraInclusao = dhinclusao;
    }

    public Date getDataHoraAlteracao() {
        return this.dataHoraAlteracao;
    }

    public void setDataHoraAlteracao(Date dhalteracao) {
        this.dataHoraAlteracao = dhalteracao;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public Usuario getUsuarioInclusao() {
        return this.usuarioInclusao;
    }

    public void setUsuarioInclusao(Usuario usuarioInclusao) {
        this.usuarioInclusao = usuarioInclusao;
    }

    public Usuario getUsuarioAlteracao() {
        return this.usuarioAlteracao;
    }

    public void setUsuarioAlteracao(Usuario usuarioAlteracao) {
        this.usuarioAlteracao = usuarioAlteracao;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        if (trabalhador == null) {
            this.historicoTrabalhadorSalarioPK.setRegistro(null);
            this.historicoTrabalhadorSalarioPK.setEntidade(null);
        } else {
            this.historicoTrabalhadorSalarioPK.setRegistro(trabalhador.getTrabalhadorPK().getRegistro());
            this.historicoTrabalhadorSalarioPK.setEntidade(trabalhador.getTrabalhadorPK().getEntidade());
        }
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal tipoLegal) {
        this.tipoLegalCodigo = tipoLegal != null ? tipoLegal.getCodigo() : null;
        this.tipoLegal = tipoLegal;
    }

    public Salario getSalario() {
        return this.salario;
    }

    public void setSalario(Salario salario) {
        this.salario = salario;
        if (salario == null) {
            this.historicoTrabalhadorSalarioPK.setRefsal(null);
        } else {
            this.historicoTrabalhadorSalarioPK.setRefsal(salario.getSalarioPK().getCodigo());
        }
    }

    public Salario getSalarioAnterior() {
        return this.salarioAnterior;
    }

    public void setSalarioAnterior(Salario salarioAnterior) {
        this.salarioAnterior = salarioAnterior;
        this.salarioAnteriorCodigo = salarioAnterior == null ? null : salarioAnterior.getSalarioPK().getCodigo();
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.historicoTrabalhadorSalarioPK != null ? this.historicoTrabalhadorSalarioPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HistoricoTrabalhadorSalario)) {
            return false;
        }
        HistoricoTrabalhadorSalario other = (HistoricoTrabalhadorSalario)object;
        return (this.historicoTrabalhadorSalarioPK != null || other.historicoTrabalhadorSalarioPK == null) && (this.historicoTrabalhadorSalarioPK == null || this.historicoTrabalhadorSalarioPK.equals(other.historicoTrabalhadorSalarioPK));
    }

    public String toString() {
        return "entity.HisttrabSalario[ histtrabSalarioPK=" + this.historicoTrabalhadorSalarioPK + " ]";
    }

    public String getSalarioAnteriorCodigo() {
        return this.salarioAnteriorCodigo;
    }

    public void setSalarioAnteriorCodigo(String salarioAnteriorCodigo) {
        this.salarioAnteriorCodigo = salarioAnteriorCodigo;
    }

    public Date getDataInicioVigencia() {
        return this.dataInicioVigencia;
    }

    public void setDataInicioVigencia(Date dataInicioVigencia) {
        this.dataInicioVigencia = dataInicioVigencia;
    }

    public Date getDataFinalVigencia() {
        return this.dataFinalVigencia;
    }

    public void setDataFinalVigencia(Date dataTerminoVigencia) {
        this.dataFinalVigencia = dataTerminoVigencia;
    }

    public Boolean getRetornoAutomaticoExecutado() {
        return this.retornoAutomaticoExecutado;
    }

    public void setRetornoAutomaticoExecutado(Boolean retornoAutomaticoExecutado) {
        this.retornoAutomaticoExecutado = retornoAutomaticoExecutado;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        this.eventoCodigo = evento != null ? evento.getEventoPK().getCodigo() : null;
        this.evento = evento;
    }

    public String getEventoCodigo() {
        return this.eventoCodigo;
    }

    public void setEventoCodigo(String eventoCodigo) {
        this.eventoCodigo = eventoCodigo;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegal != null ? this.tipoLegal.getCodigo() : null;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.getDataDocumento();
    }

    @Override
    public void setData(Date value) {
        this.setDataDocumento(value);
    }
}

