/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorNomePK;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Entity
@Table(name="HISTTRAB_NOME")
@Audited
public class HistoricoTrabalhadorNome
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected HistoricoTrabalhadorNomePK historicoTrabalhadorNomePK;
    @Column(name="DHTRANSF")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraTransferencia;
    @Size(max=60)
    @Column(name="NOME_NOVO")
    private String nomeAtual;
    @Size(max=60)
    @Column(name="NOME_ANTERIOR")
    private String nomeAnterior;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numeroDocumento;
    @Lob
    @Size(max=0x7FFFFFFF)
    @Column(name="OBS")
    private String observacao;
    @JoinColumn(name="USUARIO", referencedColumnName="CODIGO")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Usuario usuario;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;

    public HistoricoTrabalhadorNome() {
        this.historicoTrabalhadorNomePK = new HistoricoTrabalhadorNomePK();
    }

    public HistoricoTrabalhadorNome(HistoricoTrabalhadorNomePK historicoTrabalhadorNomePK) {
        this.historicoTrabalhadorNomePK = historicoTrabalhadorNomePK;
    }

    public HistoricoTrabalhadorNome(String entidade, String registro, short item) {
        this.historicoTrabalhadorNomePK = new HistoricoTrabalhadorNomePK(entidade, registro, item);
    }

    public HistoricoTrabalhadorNomePK getHistoricoTrabalhadorNomePK() {
        return this.historicoTrabalhadorNomePK;
    }

    public void setHistoricoTrabalhadorNomePK(HistoricoTrabalhadorNomePK historicoTrabalhadorNomePK) {
        this.historicoTrabalhadorNomePK = historicoTrabalhadorNomePK;
    }

    public Date getDataHoraTransferencia() {
        return this.dataHoraTransferencia;
    }

    public void setDataHoraTransferencia(Date dhtransf) {
        this.dataHoraTransferencia = dhtransf;
    }

    public String getNomeAtual() {
        return this.nomeAtual;
    }

    public void setNomeAtual(String nomeNovo) {
        this.nomeAtual = nomeNovo;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String obs) {
        this.observacao = obs;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date datadoc) {
        this.dataDocumento = datadoc;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String numdoc) {
        this.numeroDocumento = numdoc;
    }

    public String getNomeAnterior() {
        return this.nomeAnterior;
    }

    public void setNomeAnterior(String nomeAnterior) {
        this.nomeAnterior = nomeAnterior;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        if (trabalhador != null) {
            this.getHistoricoTrabalhadorNomePK().setEntidade(trabalhador.getTrabalhadorPK().getEntidade());
            this.getHistoricoTrabalhadorNomePK().setRegistro(trabalhador.getTrabalhadorPK().getRegistro());
        } else {
            this.getHistoricoTrabalhadorNomePK().setEntidade(null);
            this.getHistoricoTrabalhadorNomePK().setRegistro(null);
        }
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal tipolegal) {
        this.tipoLegal = tipolegal;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.historicoTrabalhadorNomePK != null ? this.historicoTrabalhadorNomePK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HistoricoTrabalhadorNome)) {
            return false;
        }
        HistoricoTrabalhadorNome other = (HistoricoTrabalhadorNome)object;
        return (this.historicoTrabalhadorNomePK != null || other.historicoTrabalhadorNomePK == null) && (this.historicoTrabalhadorNomePK == null || this.historicoTrabalhadorNomePK.equals(other.historicoTrabalhadorNomePK));
    }

    public String toString() {
        return "HistoricoTrabalhadorNome{historicoTrabalhadorNomePK=" + this.historicoTrabalhadorNomePK + ", dataHoraTransferencia=" + this.dataHoraTransferencia + ", nomeAtual='" + this.nomeAtual + '\'' + ", nomeAnterior='" + this.nomeAnterior + '\'' + ", dataDocumento=" + this.dataDocumento + ", numeroDocumento='" + this.numeroDocumento + '\'' + ", observacao='" + this.observacao + '\'' + '}';
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegal != null ? this.tipoLegal.getCodigo() : null;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.getDataDocumento();
    }

    @Override
    public void setData(Date value) {
        this.setDataDocumento(value);
    }
}

