/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorLocalTrabalhoPK;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Entity
@Table(name="HISTTRAB_LOCALTRAB")
@Audited
public class HistoricoTrabalhadorLocalTrabalho
implements Serializable,
Documento {
    public static final String FIND_BY_TRABALHADOR = "SELECT h FROM HistoricoTrabalhadorLocalTrabalho h JOIN FETCH h.trabalhador LEFT JOIN FETCH h.tipoLegal JOIN FETCH h.localTrabalho LEFT JOIN FETCH h.localTrabalhoAnterior WHERE h.trabalhador.trabalhadorPK = :trabalhadorPK";
    public static final String FIND_BY_TRABALHADOR_TO_WS = "SELECT new br.com.fiorilli.sipweb.vo.ws.historico.trabalhador.HistoricoTrabLocalTrabalhoWsVo(h.tipoLegal.codigo, h.tipoLegal.nome, h.numeroDocumento, h.dataDocumento, h.observacao, h.localTrabalho.localTrabalhoPK.codigo, h.localTrabalho.nome) FROM HistoricoTrabalhadorLocalTrabalho h WHERE h.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY h.dataHoraInclusao, h.historicoTrabalhadorLocalTrabalhoPK.item";
    public static final String GET_NEXT_ITEM = "select coalesce(max(h.historicoTrabalhadorLocalTrabalhoPK.item), 0) + 1 from HistoricoTrabalhadorLocalTrabalho h where h.trabalhador.trabalhadorPK = :trabalhadorPK order by h.dataHoraInclusao desc";
    public static final String FIND_LAST_BY_TRABALHADOR = "select h.historicoTrabalhadorLocalTrabalhoPK from HistoricoTrabalhadorLocalTrabalho h where h.trabalhador.trabalhadorPK = :trabalhadorPK order by h.dataHoraInclusao desc";
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected HistoricoTrabalhadorLocalTrabalhoPK historicoTrabalhadorLocalTrabalhoPK;
    @Column(name="DHTRANSF")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraTransferencia;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numeroDocumento;
    @Column(name="DHINCLUSAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraInclusao;
    @Column(name="DHALTERACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraAlteracao;
    @Lob
    @Size(max=0x7FFFFFFF)
    @Column(name="OBS")
    private String observacao;
    @JoinColumn(name="USUARIO_INCLUSAO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioInclusao;
    @JoinColumn(name="USUARIO_ALTERACAO", referencedColumnName="CODIGO")
    @ManyToOne
    private Usuario usuarioAlteracao;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @Size(min=1, max=6)
    @Column(name="ANTERIOR")
    private String localTrabalhoAnteriorCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="ANTERIOR", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private LocalTrabalho localTrabalhoAnterior;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="LOCALTRAB", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private LocalTrabalho localTrabalho;

    public HistoricoTrabalhadorLocalTrabalho() {
    }

    public HistoricoTrabalhadorLocalTrabalho(HistoricoTrabalhadorLocalTrabalhoPK histtrabLocaltrabPK) {
        this.historicoTrabalhadorLocalTrabalhoPK = histtrabLocaltrabPK;
    }

    public HistoricoTrabalhadorLocalTrabalho(String entidade, String registro, String localtrab, short item) {
        this.historicoTrabalhadorLocalTrabalhoPK = new HistoricoTrabalhadorLocalTrabalhoPK(entidade, registro, localtrab, item);
    }

    public HistoricoTrabalhadorLocalTrabalhoPK getHistoricoTrabalhadorLocalTrabalhoPK() {
        return this.historicoTrabalhadorLocalTrabalhoPK;
    }

    public void setHistoricoTrabalhadorLocalTrabalhoPK(HistoricoTrabalhadorLocalTrabalhoPK histtrabLocaltrabPK) {
        this.historicoTrabalhadorLocalTrabalhoPK = histtrabLocaltrabPK;
    }

    public Date getDataHoraTransferencia() {
        return this.dataHoraTransferencia;
    }

    public void setDataHoraTransferencia(Date dhtransf) {
        this.dataHoraTransferencia = dhtransf;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date datadoc) {
        this.dataDocumento = datadoc;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String numdoc) {
        this.numeroDocumento = numdoc;
    }

    public Date getDataHoraInclusao() {
        return this.dataHoraInclusao;
    }

    public void setDataHoraInclusao(Date dhinclusao) {
        this.dataHoraInclusao = dhinclusao;
    }

    public Date getDataHoraAlteracao() {
        return this.dataHoraAlteracao;
    }

    public void setDataHoraAlteracao(Date dhalteracao) {
        this.dataHoraAlteracao = dhalteracao;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public Usuario getUsuarioInclusao() {
        return this.usuarioInclusao;
    }

    public void setUsuarioInclusao(Usuario usuarioInclusao) {
        this.usuarioInclusao = usuarioInclusao;
    }

    public Usuario getUsuarioAlteracao() {
        return this.usuarioAlteracao;
    }

    public void setUsuarioAlteracao(Usuario usuarioAlteracao) {
        this.usuarioAlteracao = usuarioAlteracao;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        if (trabalhador == null) {
            this.historicoTrabalhadorLocalTrabalhoPK.setRegistro(null);
            this.historicoTrabalhadorLocalTrabalhoPK.setEntidade(null);
        } else {
            this.historicoTrabalhadorLocalTrabalhoPK.setRegistro(trabalhador.getTrabalhadorPK().getRegistro());
            this.historicoTrabalhadorLocalTrabalhoPK.setEntidade(trabalhador.getTrabalhadorPK().getEntidade());
        }
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal tipolegal) {
        this.tipoLegal = tipolegal;
    }

    public LocalTrabalho getLocalTrabalhoAnterior() {
        return this.localTrabalhoAnterior;
    }

    public void setLocalTrabalhoAnterior(LocalTrabalho localTrabalhoAnterior) {
        this.localTrabalhoAnterior = localTrabalhoAnterior;
        this.localTrabalhoAnteriorCodigo = localTrabalhoAnterior != null ? localTrabalhoAnterior.getLocalTrabalhoPK().getCodigo() : null;
    }

    public LocalTrabalho getLocalTrabalho() {
        return this.localTrabalho;
    }

    public void setLocalTrabalho(LocalTrabalho localTrabalho) {
        this.localTrabalho = localTrabalho;
        if (localTrabalho != null) {
            this.historicoTrabalhadorLocalTrabalhoPK.setLocalTrabalho(localTrabalho.getLocalTrabalhoPK().getCodigo());
        } else {
            this.historicoTrabalhadorLocalTrabalhoPK.setLocalTrabalho(null);
        }
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.historicoTrabalhadorLocalTrabalhoPK != null ? this.historicoTrabalhadorLocalTrabalhoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HistoricoTrabalhadorLocalTrabalho)) {
            return false;
        }
        HistoricoTrabalhadorLocalTrabalho other = (HistoricoTrabalhadorLocalTrabalho)object;
        return (this.historicoTrabalhadorLocalTrabalhoPK != null || other.historicoTrabalhadorLocalTrabalhoPK == null) && (this.historicoTrabalhadorLocalTrabalhoPK == null || this.historicoTrabalhadorLocalTrabalhoPK.equals(other.historicoTrabalhadorLocalTrabalhoPK));
    }

    public String toString() {
        return "entity.HisttrabLocaltrab[ histtrabLocaltrabPK=" + this.historicoTrabalhadorLocalTrabalhoPK + " ]";
    }

    public String getLocalTrabalhoAnteriorCodigo() {
        return this.localTrabalhoAnteriorCodigo;
    }

    public void setLocalTrabalhoAnteriorCodigo(String localTrabalhoAnteriorCodigo) {
        this.localTrabalhoAnteriorCodigo = localTrabalhoAnteriorCodigo;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegal != null ? this.tipoLegal.getCodigo() : null;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.getDataDocumento();
    }

    @Override
    public void setData(Date value) {
        this.setDataDocumento(value);
    }
}

