/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorJornadaPK;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorPK;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="HISTTRAB_JORNADA")
@Audited
public class HistoricoTrabalhadorJornada
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_TRABALHADOR = "SELECT h FROM HistoricoTrabalhadorJornada h JOIN FETCH h.trabalhador JOIN FETCH h.jornada LEFT JOIN FETCH h.tipoLegal LEFT JOIN FETCH h.jornadaAnterior WHERE h.trabalhador.trabalhadorPK = :trabalhadorPK order by h.pk.item";
    @EmbeddedId
    private HistoricoTrabalhadorJornadaPK pk;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador trabalhador;
    @Column(name="DHTRANSF")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraTransferencia;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private TipoDocumentoLegal tipoLegal;
    @Column(name="NUMDOC")
    @Size(max=16)
    private String numeroDocumento;
    @Column(name="DHINCLUSAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraInclusao;
    @Column(name="DHALTERACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraAlteracao;
    @Column(name="OBS")
    @Size(max=512)
    private String observacao;
    @Column(name="JORNADA", insertable=false, updatable=false)
    @Basic(optional=false)
    @NotNull
    private Integer jornadaCodigo;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="JORNADA", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Jornada jornada;
    @Column(name="ANTERIOR")
    @Basic(optional=false)
    private Integer jornadaAnteriorCodigo;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="ANTERIOR", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Jornada jornadaAnterior;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="USUARIO_INCLUSAO", referencedColumnName="CODIGO", updatable=false)
    private Usuario usuarioInclusao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="USUARIO_ALTERACAO", referencedColumnName="CODIGO")
    private Usuario usuarioAlteracao;

    public HistoricoTrabalhadorJornada() {
    }

    public HistoricoTrabalhadorJornada(TrabalhadorPK trabalhadorPK, Jornada jornadaAnterior, Date dataDocumento) {
        this.pk = new HistoricoTrabalhadorJornadaPK(trabalhadorPK);
        this.dataDocumento = dataDocumento;
        this.jornadaAnterior = jornadaAnterior;
        if (jornadaAnterior != null && jornadaAnterior.getJornadaPK().getCodigo() != null) {
            this.jornadaAnteriorCodigo = jornadaAnterior.getJornadaPK().getCodigo().intValue();
        }
    }

    public HistoricoTrabalhadorJornadaPK getPk() {
        return this.pk;
    }

    public void setPk(HistoricoTrabalhadorJornadaPK pk) {
        this.pk = pk;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public Date getDataHoraTransferencia() {
        return this.dataHoraTransferencia;
    }

    public void setDataHoraTransferencia(Date dataHoraTransferencia) {
        this.dataHoraTransferencia = dataHoraTransferencia;
    }

    public void setTipoLegalCodigo(Integer tipoLegalCodigo) {
        this.tipoLegalCodigo = tipoLegalCodigo;
    }

    public Date getDataHoraInclusao() {
        return this.dataHoraInclusao;
    }

    public void setDataHoraInclusao(Date dataHoraInclusao) {
        this.dataHoraInclusao = dataHoraInclusao;
    }

    public Date getDataHoraAlteracao() {
        return this.dataHoraAlteracao;
    }

    public void setDataHoraAlteracao(Date dataHoraAlteracao) {
        this.dataHoraAlteracao = dataHoraAlteracao;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public Integer getJornadaCodigo() {
        return this.jornadaCodigo;
    }

    public void setJornadaCodigo(Integer jornadaCodigo) {
        this.jornadaCodigo = jornadaCodigo;
    }

    public Jornada getJornada() {
        return this.jornada;
    }

    public void setJornada(Jornada jornada) {
        this.jornada = jornada;
        if (jornada != null) {
            this.jornadaCodigo = jornada.getJornadaPK().getCodigo().intValue();
            if (this.pk != null) {
                this.pk.setJornada(this.jornadaCodigo);
            }
        } else {
            this.jornadaCodigo = null;
        }
    }

    public Integer getJornadaAnteriorCodigo() {
        return this.jornadaAnteriorCodigo;
    }

    public void setJornadaAnteriorCodigo(Integer jornadaAnteriorCodigo) {
        this.jornadaAnteriorCodigo = jornadaAnteriorCodigo;
    }

    public Jornada getJornadaAnterior() {
        return this.jornadaAnterior;
    }

    public void setJornadaAnterior(Jornada jornadaAnterior) {
        this.jornadaAnterior = jornadaAnterior;
    }

    public Usuario getUsuarioInclusao() {
        return this.usuarioInclusao;
    }

    public void setUsuarioInclusao(Usuario usuarioInclusao) {
        this.usuarioInclusao = usuarioInclusao;
    }

    public Usuario getUsuarioAlteracao() {
        return this.usuarioAlteracao;
    }

    public void setUsuarioAlteracao(Usuario usuarioAlteracao) {
        this.usuarioAlteracao = usuarioAlteracao;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal value) {
        this.tipoLegal = value;
        if (this.tipoLegal != null) {
            this.tipoLegalCodigo = this.tipoLegal.getCodigo();
        }
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String value) {
        this.numeroDocumento = value;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.dataDocumento;
    }

    @Override
    public void setData(Date value) {
        this.dataDocumento = value;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricoTrabalhadorJornada that = (HistoricoTrabalhadorJornada)o;
        return Objects.equals(this.pk, that.pk);
    }

    public int hashCode() {
        return Objects.hashCode(this.pk);
    }
}

