/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorDivisaoPK;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="HISTTRAB_DIVISAO")
@Audited
public class HistoricoTrabalhadorDivisao
implements Serializable,
Documento {
    public static final String FIND_BY_TRABALHADOR = "SELECT h FROM HistoricoTrabalhadorDivisao h JOIN FETCH h.trabalhador LEFT JOIN FETCH h.divisao LEFT JOIN FETCH h.tipoLegal LEFT JOIN FETCH h.usuarioInclusao LEFT JOIN FETCH h.divisaoAnterior WHERE h.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY h.historicoTrabalhadorDivisaoPK.item";
    public static final String FIND_BY_TRABALHADOR_TO_WS = "SELECT new br.com.fiorilli.sipweb.vo.ws.historico.trabalhador.HistoricoTrabDivisaoWsVo(h.tipoLegal.codigo, h.tipoLegal.nome, h.numeroDocumento, h.dataDocumento, h.observacao, h.divisao.divisaoPK.codigo, h.divisao.nome) FROM HistoricoTrabalhadorDivisao h WHERE h.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY h.dataHoraInclusao, h.historicoTrabalhadorDivisaoPK.item";
    public static final String GET_NEXT_ITEM = "select coalesce(max(h.historicoTrabalhadorDivisaoPK.item), 0) + 1 from HistoricoTrabalhadorDivisao h where h.trabalhador.trabalhadorPK = :trabalhadorPK order by h.dataHoraInclusao desc";
    public static final String FIND_LAST_BY_TRABALHADOR = "SELECT h.historicoTrabalhadorDivisaoPK FROM HistoricoTrabalhadorDivisao h WHERE h.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY h.dataHoraInclusao DESC";
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected HistoricoTrabalhadorDivisaoPK historicoTrabalhadorDivisaoPK;
    @Column(name="DHTRANSF")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraTransferencia;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numeroDocumento;
    @Column(name="DHINCLUSAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraInclusao;
    @Column(name="DHALTERACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraAlteracao;
    @Lob
    @Size(max=0x7FFFFFFF)
    @Column(name="OBS")
    private String observacao;
    @JoinColumn(name="USUARIO_INCLUSAO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioInclusao;
    @JoinColumn(name="USUARIO_ALTERACAO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioAlteracao;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="ANTERIOR")
    private String divisaoAnteriorCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="ANTERIOR", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Divisao divisaoAnterior;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="DIVISAO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Divisao divisao;

    public HistoricoTrabalhadorDivisao() {
    }

    public HistoricoTrabalhadorDivisao(HistoricoTrabalhadorDivisaoPK histtrabDivisaoPK) {
        this.historicoTrabalhadorDivisaoPK = histtrabDivisaoPK;
    }

    public HistoricoTrabalhadorDivisao(String entidade, String registro, String divisao, short item) {
        this.historicoTrabalhadorDivisaoPK = new HistoricoTrabalhadorDivisaoPK(entidade, registro, divisao, item);
    }

    public HistoricoTrabalhadorDivisaoPK getHistoricoTrabalhadorDivisaoPK() {
        return this.historicoTrabalhadorDivisaoPK;
    }

    public void setHistoricoTrabalhadorDivisaoPK(HistoricoTrabalhadorDivisaoPK historicoTrabalhadorDivisaoPK) {
        this.historicoTrabalhadorDivisaoPK = historicoTrabalhadorDivisaoPK;
    }

    public Date getDataHoraTransferencia() {
        return this.dataHoraTransferencia;
    }

    public void setDataHoraTransferencia(Date dhtransf) {
        this.dataHoraTransferencia = dhtransf;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date datadoc) {
        this.dataDocumento = datadoc;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String numdoc) {
        this.numeroDocumento = numdoc;
    }

    public Date getDataHoraInclusao() {
        return this.dataHoraInclusao;
    }

    public void setDataHoraInclusao(Date dhinclusao) {
        this.dataHoraInclusao = dhinclusao;
    }

    public Date getDataHoraAlteracao() {
        return this.dataHoraAlteracao;
    }

    public void setDataHoraAlteracao(Date dhalteracao) {
        this.dataHoraAlteracao = dhalteracao;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public Usuario getUsuarioInclusao() {
        return this.usuarioInclusao;
    }

    public void setUsuarioInclusao(Usuario usuarioInclusao) {
        this.usuarioInclusao = usuarioInclusao;
    }

    public Usuario getUsuarioAlteracao() {
        return this.usuarioAlteracao;
    }

    public void setUsuarioAlteracao(Usuario usuarioAlteracao) {
        this.usuarioAlteracao = usuarioAlteracao;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        if (trabalhador == null) {
            this.historicoTrabalhadorDivisaoPK.setRegistro(null);
            this.historicoTrabalhadorDivisaoPK.setEntidade(null);
        } else {
            this.historicoTrabalhadorDivisaoPK.setRegistro(trabalhador.getTrabalhadorPK().getRegistro());
            this.historicoTrabalhadorDivisaoPK.setEntidade(trabalhador.getTrabalhadorPK().getEntidade());
        }
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal tipolegal) {
        this.tipoLegal = tipolegal;
    }

    public Divisao getDivisaoAnterior() {
        return this.divisaoAnterior;
    }

    public void setDivisaoAnterior(Divisao divisaoAnterior) {
        this.divisaoAnteriorCodigo = divisaoAnterior != null ? divisaoAnterior.getCodigo() : null;
        this.divisaoAnterior = divisaoAnterior;
    }

    public Divisao getDivisao() {
        if (this.divisao == null) {
            this.divisao = new Divisao();
        }
        return this.divisao;
    }

    public void setDivisao(Divisao divisao) {
        this.divisao = divisao;
        if (divisao != null) {
            this.historicoTrabalhadorDivisaoPK.setDivisao(divisao.getDivisaoPK().getCodigo());
        } else {
            this.historicoTrabalhadorDivisaoPK.setDivisao(null);
        }
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.historicoTrabalhadorDivisaoPK != null ? this.historicoTrabalhadorDivisaoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HistoricoTrabalhadorDivisao)) {
            return false;
        }
        HistoricoTrabalhadorDivisao other = (HistoricoTrabalhadorDivisao)object;
        return (this.historicoTrabalhadorDivisaoPK != null || other.historicoTrabalhadorDivisaoPK == null) && (this.historicoTrabalhadorDivisaoPK == null || this.historicoTrabalhadorDivisaoPK.equals(other.historicoTrabalhadorDivisaoPK));
    }

    public String toString() {
        return "entity.HisttrabDivisao[ histtrabDivisaoPK=" + this.historicoTrabalhadorDivisaoPK + " ]";
    }

    public String getDivisaoAnteriorCodigo() {
        return this.divisaoAnteriorCodigo;
    }

    public void setDivisaoAnteriorCodigo(String divisaoAnteriorCodigo) {
        this.divisaoAnteriorCodigo = divisaoAnteriorCodigo;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegal != null ? this.tipoLegal.getCodigo() : null;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.getDataDocumento();
    }

    @Override
    public void setData(Date value) {
        this.setDataDocumento(value);
    }
}

