/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorCargoInicialPK;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="HISTTRAB_CARGO_INICIAL")
@IdClass(value=HistoricoTrabalhadorCargoInicialPK.class)
@Audited
public class HistoricoTrabalhadorCargoInicial
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_TRABALHADOR_TO_WS = "SELECT new br.com.fiorilli.sipweb.vo.ws.historico.trabalhador.HistoricoTrabCargoWsVo(h.tipoLegal.codigo, h.tipoLegal.nome, h.numeroDocumento, h.dataDocumento, h.observacao, h.cargo.cargoPK.codigo, h.cargo.nome, h.dataPosse, h.dataExercicio) FROM HistoricoTrabalhadorCargoInicial h WHERE h.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY h.dataHoraInclusao, h.item";
    @Id
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @Id
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;
    @Id
    @NotNull
    @Size(min=1, max=4)
    @Column(name="CARGO")
    private String cargoCodigo;
    @Id
    @NotNull
    @Column(name="ITEM")
    private Short item;
    @Column(name="DHTRANSF")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraTransferencia;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numeroDocumento;
    @Column(name="DHINCLUSAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraInclusao;
    @Column(name="DHALTERACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraAlteracao;
    @Column(name="DTPOSSE")
    @Temporal(value=TemporalType.DATE)
    private Date dataPosse;
    @Column(name="DTEXERCICIO")
    @Temporal(value=TemporalType.DATE)
    private Date dataExercicio;
    @Size(min=1, max=4)
    @Column(name="ANTERIOR")
    private String cargoAnteriorCodigo;
    @Size(max=512)
    @Column(name="OBS")
    private String observacao;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CARGO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Cargo cargo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="ANTERIOR", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Cargo cargoAnterior;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public String getCargoCodigo() {
        return this.cargoCodigo;
    }

    public void setCargoCodigo(String cargoCodigo) {
        this.cargoCodigo = cargoCodigo;
    }

    public Short getItem() {
        return this.item;
    }

    public void setItem(Short item) {
        this.item = item;
    }

    public Date getDataHoraTransferencia() {
        return this.dataHoraTransferencia;
    }

    public void setDataHoraTransferencia(Date dataHoraTransferencia) {
        this.dataHoraTransferencia = dataHoraTransferencia;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date dataDocumento) {
        this.dataDocumento = dataDocumento;
    }

    public void setTipoLegalCodigo(Integer tipoLegalCodigo) {
        this.tipoLegalCodigo = tipoLegalCodigo;
    }

    public Date getDataHoraInclusao() {
        return this.dataHoraInclusao;
    }

    public void setDataHoraInclusao(Date dataHoraInclusao) {
        this.dataHoraInclusao = dataHoraInclusao;
    }

    public Date getDataHoraAlteracao() {
        return this.dataHoraAlteracao;
    }

    public void setDataHoraAlteracao(Date dataHoraAlteracao) {
        this.dataHoraAlteracao = dataHoraAlteracao;
    }

    public Date getDataPosse() {
        return this.dataPosse;
    }

    public void setDataPosse(Date dataPosse) {
        this.dataPosse = dataPosse;
    }

    public Date getDataExercicio() {
        return this.dataExercicio;
    }

    public void setDataExercicio(Date dataExercicio) {
        this.dataExercicio = dataExercicio;
    }

    public String getCargoAnteriorCodigo() {
        return this.cargoAnteriorCodigo;
    }

    public void setCargoAnteriorCodigo(String cargoAnteriorCodigo) {
        this.cargoAnteriorCodigo = cargoAnteriorCodigo;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public Cargo getCargo() {
        return this.cargo;
    }

    public void setCargo(Cargo cargo) {
        this.cargo = cargo;
    }

    public Cargo getCargoAnterior() {
        return this.cargoAnterior;
    }

    public void setCargoAnterior(Cargo cargoAnterior) {
        this.cargoAnterior = cargoAnterior;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal value) {
        this.tipoLegal = value;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return null;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String value) {
        this.numeroDocumento = value;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.getDataDocumento();
    }

    @Override
    public void setData(Date value) {
        this.setDataDocumento(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricoTrabalhadorCargoInicial that = (HistoricoTrabalhadorCargoInicial)o;
        return Objects.equals(this.entidadeCodigo, that.entidadeCodigo) && Objects.equals(this.registro, that.registro) && Objects.equals(this.cargoCodigo, that.cargoCodigo) && Objects.equals(this.item, that.item);
    }

    public int hashCode() {
        return Objects.hash(this.entidadeCodigo, this.registro, this.cargoCodigo, this.item);
    }
}

