/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorCargoAudesp;
import br.com.fiorilli.sip.persistence.entity.SituacaoFuncional;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="HISTTRAB_CARGO")
@Audited
public class HistoricoTrabalhadorCargo
implements Serializable,
Documento {
    public static final String FIND_BY_TRABALHADOR = "SELECT h FROM HistoricoTrabalhadorCargo h JOIN FETCH h.trabalhador JOIN FETCH h.cargo LEFT JOIN FETCH h.tipoLegal WHERE h.trabalhador.trabalhadorPK = :trabalhadorPK order by h.item";
    public static final String FIND_BY_TRABALHADOR_TO_WS = "SELECT new br.com.fiorilli.sipweb.vo.ws.historico.trabalhador.HistoricoTrabCargoWsVo(h.tipoLegal.codigo, h.tipoLegal.nome, h.numeroDocumento, h.dataDocumento, h.observacao, h.cargo.cargoPK.codigo, h.cargo.nome, h.dataPosse, h.dataExercicio) FROM HistoricoTrabalhadorCargo h WHERE h.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY h.dataHoraInclusao, h.item";
    public static final String FIND_BY_DATA_TERMINO = "SELECT h FROM HistoricoTrabalhadorCargo h where h.dataTermino < :hoje and h.id = (select max(_h.id) from HistoricoTrabalhadorCargo _h where _h.trabalhador = h.trabalhador) and ((h.retornoAutomaticoExecutado = false) or (h.retornoAutomaticoExecutado is null))";
    public static final String GENERATOR = "GEN_HISTTRABCARGO";
    private static final long serialVersionUID = 1L;
    @Id
    private Integer id;
    @Column(name="ITEM")
    @NotNull
    private Short item;
    @Column(name="DHTRANSF")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraTransferencia;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @Column(name="DHINCLUSAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraInclusao;
    @Column(name="DHALTERACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraAlteracao;
    @Column(name="DTPOSSE")
    @Temporal(value=TemporalType.DATE)
    private Date dataPosse;
    @Column(name="DTEXERCICIO")
    @Temporal(value=TemporalType.DATE)
    private Date dataExercicio;
    @Size(max=512)
    @Column(name="OBS")
    private String observacao;
    @Column(name="TIPO")
    private Integer tipo;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numeroDocumento;
    @Column(name="CARGO")
    private String cargoCodigo;
    @Basic(optional=false)
    @Size(min=1, max=4)
    @Column(name="ANTERIOR")
    private String cargoAnteriorCodigo;
    @Column(name="DATA_TERMINO")
    @Temporal(value=TemporalType.DATE)
    private Date dataTermino;
    @Type(type="BooleanTypeSip")
    @Column(name="RETORNO_AUTOMATICO_EXECUTADO")
    private Boolean retornoAutomaticoExecutado;
    @Embedded
    private HistoricoTrabalhadorCargoAudesp audesp;
    @JoinColumn(name="USUARIO_INCLUSAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioInclusao;
    @Column(name="USUARIO_INCLUSAO")
    private Integer usuarioCodigo;
    @JoinColumn(name="USUARIO_ALTERACAO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioAlteracao;
    @Column
    private String registro;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CARGO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Cargo cargo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="ANTERIOR", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Cargo cargoAnterior;
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Entidade entidade;
    @Column(name="ID_ANTERIOR")
    private Integer idAnterior;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ANTERIOR", referencedColumnName="ID", insertable=false, updatable=false)
    private HistoricoTrabalhadorCargo historicoAnterior;
    @Enumerated
    @Column(name="SITUACAO_FUNCIONAL")
    private SituacaoFuncional situacaoFuncional;

    public HistoricoTrabalhadorCargo() {
    }

    public HistoricoTrabalhadorCargo(int id) {
        this.id = id;
    }

    public final Integer getId() {
        return this.id;
    }

    public final void setId(Integer id) {
        this.id = id;
        this.item = 0;
    }

    public Date getDataHoraTransferencia() {
        return this.dataHoraTransferencia;
    }

    public void setDataHoraTransferencia(Date dhtransf) {
        this.dataHoraTransferencia = dhtransf;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date datadoc) {
        this.dataDocumento = datadoc;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String numdoc) {
        this.numeroDocumento = numdoc;
    }

    public Date getDataHoraInclusao() {
        return this.dataHoraInclusao;
    }

    public void setDataHoraInclusao(Date dhinclusao) {
        this.dataHoraInclusao = dhinclusao;
    }

    public Date getDataHoraAlteracao() {
        return this.dataHoraAlteracao;
    }

    public void setDataHoraAlteracao(Date dhalteracao) {
        this.dataHoraAlteracao = dhalteracao;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public Integer getTipo() {
        return this.tipo;
    }

    public void setTipo(Integer tipo) {
        this.tipo = tipo;
    }

    public Date getDataPosse() {
        return this.dataPosse;
    }

    public void setDataPosse(Date dataPosse) {
        this.dataPosse = dataPosse;
    }

    public Date getDataExercicio() {
        return this.dataExercicio;
    }

    public void setDataExercicio(Date dataExercicio) {
        this.dataExercicio = dataExercicio;
    }

    public Usuario getUsuarioInclusao() {
        return this.usuarioInclusao;
    }

    public void setUsuarioInclusao(Usuario usuarioInclusao) {
        this.usuarioCodigo = usuarioInclusao != null ? usuarioInclusao.getCodigo() : null;
        this.usuarioInclusao = usuarioInclusao;
    }

    public Usuario getUsuarioAlteracao() {
        return this.usuarioAlteracao;
    }

    public void setUsuarioAlteracao(Usuario usuarioAlteracao) {
        this.usuarioAlteracao = usuarioAlteracao;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        if (trabalhador != null && trabalhador.getTrabalhadorPK() != null) {
            this.entidadeCodigo = trabalhador.getTrabalhadorPK().getEntidade();
            this.registro = trabalhador.getTrabalhadorPK().getRegistro();
        } else {
            this.entidadeCodigo = null;
            this.registro = null;
        }
        this.trabalhador = trabalhador;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal tipoLegal) {
        this.tipoLegalCodigo = tipoLegal != null ? tipoLegal.getCodigo() : null;
        this.tipoLegal = tipoLegal;
    }

    public Cargo getCargoAnterior() {
        return this.cargoAnterior;
    }

    public void setCargoAnterior(Cargo cargoAnterior) {
        if (cargoAnterior != null && cargoAnterior.getCargoPK() != null) {
            this.cargoAnteriorCodigo = cargoAnterior.getCargoPK().getCodigo();
        }
        this.cargoAnterior = cargoAnterior;
    }

    public Cargo getCargo() {
        return this.cargo;
    }

    public void setCargo(Cargo cargo) {
        this.cargoCodigo = cargo != null && cargo.getCargoPK() != null ? cargo.getCargoPK().getCodigo() : null;
        this.cargo = cargo;
    }

    public String getCargoAnteriorCodigo() {
        return this.cargoAnteriorCodigo;
    }

    public void setCargoAnteriorCodigo(String cargoAnteriorCodigo) {
        this.cargoAnteriorCodigo = cargoAnteriorCodigo;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
        if (entidade == null) {
            this.setEntidadeCodigo(null);
        } else {
            this.setEntidadeCodigo(entidade.getCodigo());
        }
    }

    public HistoricoTrabalhadorCargoAudesp getAudesp() {
        if (this.audesp == null) {
            this.audesp = new HistoricoTrabalhadorCargoAudesp();
        }
        return this.audesp;
    }

    public void setAudesp(HistoricoTrabalhadorCargoAudesp audesp) {
        this.audesp = audesp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HistoricoTrabalhadorCargo other = (HistoricoTrabalhadorCargo)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "HistoricoTrabalhadorCargo [id=" + this.id + "]";
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public String getCargoCodigo() {
        return this.cargoCodigo;
    }

    public void setCargoCodigo(String cargoCodigo) {
        this.cargoCodigo = cargoCodigo;
    }

    public Boolean getRetornoAutomaticoExecutado() {
        return this.retornoAutomaticoExecutado;
    }

    public void setRetornoAutomaticoExecutado(Boolean retornoAutomaticoExecutado) {
        this.retornoAutomaticoExecutado = retornoAutomaticoExecutado;
    }

    public Date getDataTermino() {
        return this.dataTermino;
    }

    public void setDataTermino(Date dataTermino) {
        this.dataTermino = dataTermino;
    }

    public Integer getUsuarioCodigo() {
        return this.usuarioCodigo;
    }

    public void setUsuarioCodigo(Integer usuarioCodigo) {
        this.usuarioCodigo = usuarioCodigo;
    }

    public SituacaoFuncional getSituacaoFuncional() {
        return this.situacaoFuncional;
    }

    public void setSituacaoFuncional(SituacaoFuncional situacaoFuncional) {
        this.situacaoFuncional = situacaoFuncional;
    }

    public Short getItem() {
        return this.item;
    }

    public void setItem(Short item) {
        this.item = item;
    }

    public Integer getIdAnterior() {
        return this.idAnterior;
    }

    public void setIdAnterior(Integer idAnterior) {
        this.idAnterior = idAnterior;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegal != null ? this.tipoLegal.getCodigo() : null;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.getDataDocumento();
    }

    @Override
    public void setData(Date value) {
        this.setDataDocumento(value);
    }

    public void setTipoLegalCodigo(Integer tipoLegalCodigo) {
        this.tipoLegalCodigo = tipoLegalCodigo;
    }
}

