/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Atividade;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorAtividadePK;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Entity
@Table(name="HISTTRAB_ATIVIDADE")
@Audited
public class HistoricoTrabalhadorAtividade
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected HistoricoTrabalhadorAtividadePK historicoTrabalhadorAtividadePK;
    @Column(name="DHTRANSF")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraTransferencia;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numeroDocumento;
    @Column(name="DHINCLUSAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraInclusao;
    @Column(name="DHALTERACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraAlteracao;
    @Lob
    @Size(max=0x7FFFFFFF)
    @Column(name="OBS")
    private String observacao;
    @JoinColumn(name="USUARIO_INCLUSAO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioInclusao;
    @JoinColumn(name="USUARIO_ALTERACAO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioAlteracao;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="ATIVIDADE", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Atividade atividade;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="ANTERIOR", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Atividade atividadeAnterior;
    @Column(name="ANTERIOR")
    private Integer atividadeAnteriorCodigo;

    public HistoricoTrabalhadorAtividade() {
        this.historicoTrabalhadorAtividadePK = new HistoricoTrabalhadorAtividadePK();
    }

    public HistoricoTrabalhadorAtividade(HistoricoTrabalhadorAtividadePK historicoTrabalhadorAtividadePK) {
        this.historicoTrabalhadorAtividadePK = historicoTrabalhadorAtividadePK;
    }

    public HistoricoTrabalhadorAtividade(String entidade, String registro, Integer atividade, Short item) {
        this.historicoTrabalhadorAtividadePK = new HistoricoTrabalhadorAtividadePK(entidade, registro, atividade, item);
    }

    public HistoricoTrabalhadorAtividadePK getHistoricoTrabalhadorAtividadePK() {
        return this.historicoTrabalhadorAtividadePK;
    }

    public void setHistoricoTrabalhadorAtividadePK(HistoricoTrabalhadorAtividadePK historicoTrabalhadorAtividadePK) {
        this.historicoTrabalhadorAtividadePK = historicoTrabalhadorAtividadePK;
    }

    public Date getDataHoraTransferencia() {
        return this.dataHoraTransferencia;
    }

    public void setDataHoraTransferencia(Date dataHoraTransferencia) {
        this.dataHoraTransferencia = dataHoraTransferencia;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date dataDocumento) {
        this.dataDocumento = dataDocumento;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
    }

    public Date getDataHoraInclusao() {
        return this.dataHoraInclusao;
    }

    public void setDataHoraInclusao(Date dataHoraInclusao) {
        this.dataHoraInclusao = dataHoraInclusao;
    }

    public Date getDataHoraAlteracao() {
        return this.dataHoraAlteracao;
    }

    public void setDataHoraAlteracao(Date dataHoraAlteracao) {
        this.dataHoraAlteracao = dataHoraAlteracao;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public Usuario getUsuarioInclusao() {
        return this.usuarioInclusao;
    }

    public void setUsuarioInclusao(Usuario usuarioInclusao) {
        this.usuarioInclusao = usuarioInclusao;
    }

    public Usuario getUsuarioAlteracao() {
        return this.usuarioAlteracao;
    }

    public void setUsuarioAlteracao(Usuario usuarioAlteracao) {
        this.usuarioAlteracao = usuarioAlteracao;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        if (trabalhador == null) {
            this.historicoTrabalhadorAtividadePK.setRegistro(null);
            this.historicoTrabalhadorAtividadePK.setEntidade(null);
        } else {
            this.historicoTrabalhadorAtividadePK.setRegistro(trabalhador.getTrabalhadorPK().getRegistro());
            this.historicoTrabalhadorAtividadePK.setEntidade(trabalhador.getTrabalhadorPK().getEntidade());
        }
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal tipoLegal) {
        this.tipoLegalCodigo = tipoLegal != null ? tipoLegal.getCodigo() : null;
        this.tipoLegal = tipoLegal;
    }

    public void setTipoLegalCodigo(Integer tipoLegalCodigo) {
        this.tipoLegalCodigo = tipoLegalCodigo;
    }

    public Atividade getAtividade() {
        return this.atividade;
    }

    public void setAtividade(Atividade atividade) {
        this.atividade = atividade;
        if (atividade != null) {
            this.historicoTrabalhadorAtividadePK.setAtividade(atividade.getAtividadePK().getCodigo());
        } else {
            this.historicoTrabalhadorAtividadePK.setAtividade(null);
        }
    }

    public Atividade getAtividadeAnterior() {
        return this.atividadeAnterior;
    }

    public void setAtividadeAnterior(Atividade atividadeAnterior) {
        this.atividadeAnterior = atividadeAnterior;
        this.atividadeAnteriorCodigo = atividadeAnterior != null ? atividadeAnterior.getAtividadePK().getCodigo() : null;
    }

    public Integer getAtividadeAnteriorCodigo() {
        return this.atividadeAnteriorCodigo;
    }

    public void setAtividadeAnteriorCodigo(Integer atividadeAnteriorCodigo) {
        this.atividadeAnteriorCodigo = atividadeAnteriorCodigo;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegal != null ? this.tipoLegal.getCodigo() : null;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.getDataDocumento();
    }

    @Override
    public void setData(Date value) {
        this.setDataDocumento(value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.historicoTrabalhadorAtividadePK == null ? 0 : this.historicoTrabalhadorAtividadePK.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HistoricoTrabalhadorAtividade other = (HistoricoTrabalhadorAtividade)obj;
        return !(this.historicoTrabalhadorAtividadePK == null ? other.historicoTrabalhadorAtividadePK != null : !this.historicoTrabalhadorAtividadePK.equals(other.historicoTrabalhadorAtividadePK));
    }

    public String toString() {
        return "HistoricoTrabalhadorAtividade [historicoAtividadeSalarioPK=" + this.historicoTrabalhadorAtividadePK + "]";
    }
}

