/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPNumberUtil;
import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CriterioResultado;
import br.com.fiorilli.sip.persistence.entity.DocumentoDescricao;
import br.com.fiorilli.sip.persistence.entity.HistsalPK;
import br.com.fiorilli.sip.persistence.entity.LocalPublicacao;
import br.com.fiorilli.sip.persistence.entity.OperacaoAlteracaoSalarial;
import br.com.fiorilli.sip.persistence.entity.SalarioAlterado;
import br.com.fiorilli.sip.persistence.entity.TipoAtoAlteracaoSalarial;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.TipoOperacaoAlteracaoSalarial;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="HISTSAL")
@Audited
public class HistoricoAlteracaoSalarial
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_HISTSAL";
    @EmbeddedId
    protected HistsalPK histsalPK;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=4)
    @Column(name="ANO")
    private String ano;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=2)
    @Column(name="MES")
    private String mes;
    @Size(max=10)
    @Column(name="OPERACAO")
    private String operacao;
    @Column(name="TOPERACAO")
    private Character tipoOperacao;
    @Column(name="VLRHISTSAL")
    private BigDecimal valor;
    @Column(name="DATA")
    @Temporal(value=TemporalType.DATE)
    private Date data;
    @Column(name="HORA")
    @Temporal(value=TemporalType.TIME)
    private Date hora;
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @Size(max=16)
    @Column(name="NUMDOC")
    private String numeroDocumento;
    @Column(name="DATAHORADESFEZ")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date datahoradesfez;
    @Column(name="CRITERIO_RESULTADO")
    private Short criterioResultado;
    @Column(name="CASAS_DECIMAIS")
    private Short casasDecimais;
    @Type(type="BooleanTypeSip")
    @Column(name="ARREDONDAR_DEZENA")
    private Boolean arredondarDezena;
    @Column(name="TIPOATO")
    @Enumerated
    private TipoAtoAlteracaoSalarial tipoAto;
    @Size(max=256)
    @Column(name="OBS")
    private String obs;
    @Column(name="DTVIGENCIADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dtvigenciadoc;
    @Column(name="ID_ATO_PESSOAL")
    private Integer idAtoPessoal;
    @JoinColumn(name="USUARIODESFEZ", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuariodesfez;
    @JoinColumn(name="USUARIO", referencedColumnName="CODIGO")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Usuario usuario;
    @Column(name="TIPOLEGAL", nullable=false)
    private Integer tipoLegalCodigo;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @Column(name="LOCAL_PUBLICACAO")
    private Integer localPublicacaoCodigo;
    @JoinColumn(name="LOCAL_PUBLICACAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private LocalPublicacao localPublicacao;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="historicoAlteracaoSalarial", fetch=FetchType.LAZY)
    private List<SalarioAlterado> histsalSalsList;

    public HistoricoAlteracaoSalarial() {
    }

    public HistoricoAlteracaoSalarial(HistsalPK histsalPK) {
        this.histsalPK = histsalPK;
    }

    public HistoricoAlteracaoSalarial(HistsalPK histsalPK, String ano, String mes) {
        this.histsalPK = histsalPK;
        this.ano = ano;
        this.mes = mes;
    }

    public HistoricoAlteracaoSalarial(String entidade, int codhistsal) {
        this.histsalPK = new HistsalPK(entidade, codhistsal);
    }

    public HistsalPK getHistsalPK() {
        return this.histsalPK;
    }

    public void setHistsalPK(HistsalPK histsalPK) {
        this.histsalPK = histsalPK;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BigDecimal calculaNovoValor(BigDecimal valorAtual) throws Exception {
        BigDecimal value = null;
        if (TipoOperacaoAlteracaoSalarial.PORCENTAGEM.equals((Object)this.getTipoOperacaoType())) {
            BigDecimal porcentagem = this.getValor().divide(SIPNumberUtil.NUMERO_100);
            if (OperacaoAlteracaoSalarial.PARA_MAIS.equals((Object)this.getOperacaoType())) {
                value = valorAtual.multiply(porcentagem.add(BigDecimal.ONE));
            } else {
                if (!OperacaoAlteracaoSalarial.PARA_MENOS.equals((Object)this.getOperacaoType())) throw new Exception("Opera\u00e7\u00e3o n\u00e3o suportada: Porcentagem/Igual");
                value = valorAtual.multiply(BigDecimal.ONE.subtract(porcentagem));
            }
        } else {
            switch (this.getOperacaoType()) {
                case PARA_MAIS: {
                    value = valorAtual.add(this.getValor());
                    break;
                }
                case PARA_MENOS: {
                    value = valorAtual.subtract(this.getValor());
                    break;
                }
                case IGUAL: {
                    value = new BigDecimal(this.getValor().doubleValue());
                }
            }
        }
        value = CriterioResultado.ARREDONDAMENTO.equals((Object)this.getCriterioResultadoType()) ? SIPNumberUtil.round((BigDecimal)value, (int)this.getCasasDecimais().shortValue()) : SIPNumberUtil.truncate((BigDecimal)value, (int)this.getCasasDecimais().shortValue());
        if (this.getArredondarDezena() == false) return value;
        return this.arredondaDezena(value);
    }

    private BigDecimal arredondaDezena(BigDecimal value) {
        BigDecimal intValue = new BigDecimal(value.intValue());
        BigDecimal fractionValue = value.subtract(intValue);
        if (SIPNumberUtil.isLeftGreaterThenRight((BigDecimal)value, (BigDecimal)intValue)) {
            return value.subtract(fractionValue).add(BigDecimal.ONE);
        }
        return value;
    }

    public String getDocumentoDescricao() {
        return new DocumentoDescricao(this.getTipoLegal(), this.getNumeroDocumento(), this.getDataDocumento()).getDescricao();
    }

    public String getAno() {
        return this.ano;
    }

    public void setAno(String ano) {
        this.ano = ano;
    }

    public String getMes() {
        return this.mes;
    }

    public void setMes(String mes) {
        this.mes = mes;
    }

    public String getOperacao() {
        return this.operacao;
    }

    public OperacaoAlteracaoSalarial getOperacaoType() {
        return OperacaoAlteracaoSalarial.get(this.operacao);
    }

    public void setOperacao(String operacao) {
        this.operacao = operacao;
    }

    public Character getTipoOperacao() {
        return this.tipoOperacao;
    }

    public TipoOperacaoAlteracaoSalarial getTipoOperacaoType() {
        return TipoOperacaoAlteracaoSalarial.get(this.getTipoOperacao());
    }

    public void setTipoOperacao(Character toperacao) {
        this.tipoOperacao = toperacao;
    }

    public BigDecimal getValor() {
        return this.valor;
    }

    public void setValor(BigDecimal value) {
        this.valor = value;
    }

    @Override
    public Date getData() {
        return this.data;
    }

    @Override
    public void setData(Date data) {
        this.data = data;
    }

    public Date getHora() {
        return this.hora;
    }

    public void setHora(Date hora) {
        this.hora = hora;
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date datadoc) {
        this.dataDocumento = datadoc;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String numdoc) {
        this.numeroDocumento = numdoc;
    }

    public Date getDatahoradesfez() {
        return this.datahoradesfez;
    }

    public void setDatahoradesfez(Date datahoradesfez) {
        this.datahoradesfez = datahoradesfez;
    }

    public Short getCriterioResultado() {
        return this.criterioResultado;
    }

    public CriterioResultado getCriterioResultadoType() {
        return CriterioResultado.toEntity(this.criterioResultado);
    }

    public void setCriterioResultado(Short criterioResultado) {
        this.criterioResultado = criterioResultado;
    }

    public TipoAtoAlteracaoSalarial getTipoAto() {
        return this.tipoAto;
    }

    public void setTipoAto(TipoAtoAlteracaoSalarial tipoAto) {
        this.tipoAto = tipoAto;
    }

    public Short getCasasDecimais() {
        return this.casasDecimais;
    }

    public void setCasasDecimais(Short casasDecimais) {
        this.casasDecimais = casasDecimais;
    }

    public Boolean getArredondarDezena() {
        return this.arredondarDezena;
    }

    public void setArredondarDezena(Boolean arredondarDezena) {
        this.arredondarDezena = arredondarDezena;
    }

    public String getObs() {
        return this.obs;
    }

    public void setObs(String obs) {
        this.obs = obs;
    }

    public Date getDtvigenciadoc() {
        return this.dtvigenciadoc;
    }

    public void setDtvigenciadoc(Date dtvigenciadoc) {
        this.dtvigenciadoc = dtvigenciadoc;
    }

    public Integer getIdAtoPessoal() {
        return this.idAtoPessoal;
    }

    public void setIdAtoPessoal(Integer idAtoPessoal) {
        this.idAtoPessoal = idAtoPessoal;
    }

    public Usuario getUsuariodesfez() {
        return this.usuariodesfez;
    }

    public void setUsuariodesfez(Usuario usuariodesfez) {
        this.usuariodesfez = usuariodesfez;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal tipolegal) {
        this.tipoLegal = tipolegal;
        this.tipoLegalCodigo = tipolegal != null ? tipolegal.getCodigo() : null;
    }

    public Integer getLocalPublicacaoCodigo() {
        return this.localPublicacaoCodigo;
    }

    public void setLocalPublicacaoCodigo(Integer localPublicacaoCodigo) {
        this.localPublicacaoCodigo = localPublicacaoCodigo;
    }

    public LocalPublicacao getLocalPublicacao() {
        return this.localPublicacao;
    }

    public void setLocalPublicacao(LocalPublicacao localPublicacao) {
        this.localPublicacao = localPublicacao;
        this.localPublicacaoCodigo = localPublicacao != null ? localPublicacao.getCodigo() : null;
    }

    public List<SalarioAlterado> getHistsalSalsList() {
        return this.histsalSalsList;
    }

    public void setHistsalSalsList(List<SalarioAlterado> histsalSalsList) {
        this.histsalSalsList = histsalSalsList;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.histsalPK != null ? this.histsalPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HistoricoAlteracaoSalarial)) {
            return false;
        }
        HistoricoAlteracaoSalarial other = (HistoricoAlteracaoSalarial)object;
        return (this.histsalPK != null || other.histsalPK == null) && (this.histsalPK == null || this.histsalPK.equals(other.histsalPK));
    }

    public String toString() {
        return "entity.Histsal[ histsalPK=" + this.histsalPK + " ]";
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    public void setTipoLegalCodigo(Integer tipoLegalCodigo) {
        this.tipoLegalCodigo = tipoLegalCodigo;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }
}

